'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Namespace Mbark.Sensors

    Public Class SensorCollection
        Implements ICollection

        Private mSensors As New ArrayList
    
        Public Sub Add(ByVal sensor As ISensor)
            If Not mSensors.Contains(sensor) Then mSensors.Add(sensor)
        End Sub

        Public Sub Duplicate(ByVal sensorSet As SensorCollection)
            If sensorSet Is Nothing Then Throw New ArgumentNullException("sensorSet")
            mSensors.Clear()
            mSensors.AddRange(sensorSet.AsArrayList)
        End Sub

        Public Sub Remove(ByVal sensor As ISensor)
            mSensors.Remove(sensor)
        End Sub

        Default Public ReadOnly Property Item(ByVal index As Integer) As ISensor
            Get
                Return DirectCast(mSensors(index), ISensor)
            End Get
        End Property

        Public ReadOnly Property ByDefinitionString(ByVal definition As String) As ISensor
            Get
                ' SLOW
                For i As Integer = 0 To mSensors.Count - 1
                    Dim sensor As ISensor = DirectCast(mSensors(i), ISensor)
                    If SensorTypeDefinition.CreateDefinition(sensor).ToString = definition Then Return sensor
                Next
            End Get
        End Property

        Friend ReadOnly Property AsArrayList() As IList
            Get
                Return mSensors
            End Get
        End Property

        Public Function Contains(ByVal sensor As ISensor) As Boolean
            Return mSensors.Contains(sensor)
        End Function

        Public Function RequiresRecoveryCount() As Integer
            Dim count As Integer = 0
            For i As Integer = 0 To mSensors.Count - 1
                If Not Item(i).Disabled AndAlso Item(i).RequiresRecovery Then count += 1
            Next
            Return count
        End Function


        Public Function IndexOf(ByVal sensor As ISensor) As Integer
            Return mSensors.IndexOf(sensor)
        End Function

#Region "ICollection Implementation"

        Public Sub CopyTo(ByVal array As System.Array, ByVal index As Integer) Implements ICollection.CopyTo
            mSensors.CopyTo(array, index)
        End Sub

        Public Sub CopyTo(ByVal sensors As SensorCollection, ByVal index As Integer)
            If sensors Is Nothing Then Throw New ArgumentNullException("sensors")
            mSensors.CopyTo(sensors.mSensors.ToArray, index)
        End Sub

        Public ReadOnly Property Count() As Integer Implements ICollection.count
            Get
                Return mSensors.Count
            End Get
        End Property

        Public ReadOnly Property IsSynchronized() As Boolean Implements System.Collections.ICollection.IsSynchronized
            Get
                Return mSensors.IsSynchronized
            End Get
        End Property

        Public ReadOnly Property SyncRoot() As Object Implements System.Collections.ICollection.SyncRoot
            Get
                Return mSensors.SyncRoot
            End Get
        End Property

        Public Function GetEnumerator() As System.Collections.IEnumerator Implements System.Collections.IEnumerable.GetEnumerator
            Return mSensors.GetEnumerator
        End Function
#End Region

    End Class

End Namespace
