'
'  Multimodal Biometric Applicaiton Resource Kit (MBARK)
'
'  File author(s):
'       Ross J. Micheals (rossm@nist.gov)
'       Kayee Kwong (kayee@nist.gov)
'
' 
' | LICENSE & DISCLAIMER                                                                                |
' |                                                                                                     |
' | This software was developed at the National Institute of Standards and Technology (NIST) by         |
' | employees of the Federal Government in the course of their official duties. Pursuant to title 17    |
' | Section 105 of the United States Code. This software is not subject to copyright protection and     |
' | is in the public domain. NIST assumes no responsibility whatsoever for use by other parties of      |
' | its source code or open source server, and makes no guarantees, expressed or implied, about its     |
' | quality, reliability, or any other characteristic.                                                  |
' |                                                                                                     |
' | Specific hardware and software products identified in this open source project were used in order   |
' | to perform technology transfer and collaboration. In no case does such identification imply         |
' | recommendation or endorsement by the National Institute of Standards and Technology, nor            |
' | does it imply that the products and equipment identified are necessarily the best available for the |
' | purpose.                                                                                            |
' 

Option Strict On

Imports System.Drawing
Imports System.Globalization
Imports System.Windows.Forms

Imports Mbark.UI
Imports Mbark.SensorMessages


Namespace Mbark.Sensors

    Public Class CaptureResultPanel
        Inherits RadioGroupBox

#Region " Windows Form Designer generated code "

        Public Sub New()
            MyBase.New()

            'This call is required by the Windows Form Designer.
            InitializeComponent()

            'Add any initialization after the InitializeComponent() call

        End Sub

        'UserControl overrides dispose to clean up the component list.
        Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
            If disposing Then
                If Not (components Is Nothing) Then
                    components.Dispose()
                End If
            End If
            MyBase.Dispose(disposing)
        End Sub

        'Required by the Windows Form Designer
        Private components As System.ComponentModel.IContainer

        'NOTE: The following procedure is required by the Windows Form Designer
        'It can be modified using the Windows Form Designer.  
        'Do not modify it using the code editor.
        Friend WithEvents CorruptImageCheckBox As System.Windows.Forms.CheckBox
        Friend WithEvents SmoothPictureBox As Mbark.UI.SmoothPictureBox
        Friend WithEvents RejectCheckBox As System.Windows.Forms.CheckBox
        Friend WithEvents WrongTaskComboBoxAdv As Syncfusion.Windows.Forms.Tools.ComboBoxAdv
        Public WithEvents WrongTaskCheckBox As System.Windows.Forms.CheckBox
        <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
            Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(CaptureResultPanel))
            Me.SmoothPictureBox = New Mbark.UI.SmoothPictureBox
            Me.RejectCheckBox = New System.Windows.Forms.CheckBox
            Me.CorruptImageCheckBox = New System.Windows.Forms.CheckBox
            Me.WrongTaskCheckBox = New System.Windows.Forms.CheckBox
            Me.WrongTaskComboBoxAdv = New Syncfusion.Windows.Forms.Tools.ComboBoxAdv
            Me.InnerPanel.SuspendLayout()
            CType(Me.WrongTaskComboBoxAdv, System.ComponentModel.ISupportInitialize).BeginInit()
            '
            'InnerPanel
            '
            Me.InnerPanel.Controls.Add(Me.WrongTaskComboBoxAdv)
            Me.InnerPanel.Controls.Add(Me.WrongTaskCheckBox)
            Me.InnerPanel.Controls.Add(Me.CorruptImageCheckBox)
            Me.InnerPanel.Controls.Add(Me.RejectCheckBox)
            Me.InnerPanel.Controls.Add(Me.SmoothPictureBox)
            Me.InnerPanel.Name = "InnerPanel"
            Me.InnerPanel.Size = CType(resources.GetObject("InnerPanel.Size"), System.Drawing.Size)
            Me.InnerPanel.TabIndex = CType(resources.GetObject("InnerPanel.TabIndex"), Integer)
            '
            'GroupRadioButton
            '
            Me.GroupRadioButton.Name = "GroupRadioButton"
            Me.GroupRadioButton.TabIndex = CType(resources.GetObject("GroupRadioButton.TabIndex"), Integer)
            '
            'SmoothPictureBox
            '
            Me.SmoothPictureBox.AccessibleDescription = resources.GetString("SmoothPictureBox.AccessibleDescription")
            Me.SmoothPictureBox.AccessibleName = resources.GetString("SmoothPictureBox.AccessibleName")
            Me.SmoothPictureBox.Alignment = Mbark.UI.SmoothPictureBoxAlignment.Center
            Me.SmoothPictureBox.Anchor = CType(resources.GetObject("SmoothPictureBox.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.SmoothPictureBox.AutoScroll = CType(resources.GetObject("SmoothPictureBox.AutoScroll"), Boolean)
            Me.SmoothPictureBox.AutoScrollMargin = CType(resources.GetObject("SmoothPictureBox.AutoScrollMargin"), System.Drawing.Size)
            Me.SmoothPictureBox.AutoScrollMinSize = CType(resources.GetObject("SmoothPictureBox.AutoScrollMinSize"), System.Drawing.Size)
            Me.SmoothPictureBox.BackgroundImage = CType(resources.GetObject("SmoothPictureBox.BackgroundImage"), System.Drawing.Image)
            Me.SmoothPictureBox.Backwards = False
            Me.SmoothPictureBox.BorderColor = System.Drawing.Color.Black
            Me.SmoothPictureBox.BorderThickness = 1
            Me.SmoothPictureBox.DisabledImage = Nothing
            Me.SmoothPictureBox.Dock = CType(resources.GetObject("SmoothPictureBox.Dock"), System.Windows.Forms.DockStyle)
            Me.SmoothPictureBox.Enabled = CType(resources.GetObject("SmoothPictureBox.Enabled"), Boolean)
            Me.SmoothPictureBox.EnabledImage = Nothing
            Me.SmoothPictureBox.Font = CType(resources.GetObject("SmoothPictureBox.Font"), System.Drawing.Font)
            Me.SmoothPictureBox.ImeMode = CType(resources.GetObject("SmoothPictureBox.ImeMode"), System.Windows.Forms.ImeMode)
            Me.SmoothPictureBox.Location = CType(resources.GetObject("SmoothPictureBox.Location"), System.Drawing.Point)
            Me.SmoothPictureBox.Name = "SmoothPictureBox"
            Me.SmoothPictureBox.OverlayColor = System.Drawing.Color.Black
            Me.SmoothPictureBox.OverlayFont = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
            Me.SmoothPictureBox.OverlayText = Nothing
            Me.SmoothPictureBox.RightToLeft = CType(resources.GetObject("SmoothPictureBox.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.SmoothPictureBox.Size = CType(resources.GetObject("SmoothPictureBox.Size"), System.Drawing.Size)
            Me.SmoothPictureBox.TabIndex = CType(resources.GetObject("SmoothPictureBox.TabIndex"), Integer)
            Me.SmoothPictureBox.Visible = CType(resources.GetObject("SmoothPictureBox.Visible"), Boolean)
            Me.SmoothPictureBox.WithBorder = False
            '
            'RejectCheckBox
            '
            Me.RejectCheckBox.AccessibleDescription = resources.GetString("RejectCheckBox.AccessibleDescription")
            Me.RejectCheckBox.AccessibleName = resources.GetString("RejectCheckBox.AccessibleName")
            Me.RejectCheckBox.Anchor = CType(resources.GetObject("RejectCheckBox.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.RejectCheckBox.Appearance = CType(resources.GetObject("RejectCheckBox.Appearance"), System.Windows.Forms.Appearance)
            Me.RejectCheckBox.BackgroundImage = CType(resources.GetObject("RejectCheckBox.BackgroundImage"), System.Drawing.Image)
            Me.RejectCheckBox.CheckAlign = CType(resources.GetObject("RejectCheckBox.CheckAlign"), System.Drawing.ContentAlignment)
            Me.RejectCheckBox.Dock = CType(resources.GetObject("RejectCheckBox.Dock"), System.Windows.Forms.DockStyle)
            Me.RejectCheckBox.Enabled = CType(resources.GetObject("RejectCheckBox.Enabled"), Boolean)
            Me.RejectCheckBox.FlatStyle = CType(resources.GetObject("RejectCheckBox.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.RejectCheckBox.Font = CType(resources.GetObject("RejectCheckBox.Font"), System.Drawing.Font)
            Me.RejectCheckBox.Image = CType(resources.GetObject("RejectCheckBox.Image"), System.Drawing.Image)
            Me.RejectCheckBox.ImageAlign = CType(resources.GetObject("RejectCheckBox.ImageAlign"), System.Drawing.ContentAlignment)
            Me.RejectCheckBox.ImageIndex = CType(resources.GetObject("RejectCheckBox.ImageIndex"), Integer)
            Me.RejectCheckBox.ImeMode = CType(resources.GetObject("RejectCheckBox.ImeMode"), System.Windows.Forms.ImeMode)
            Me.RejectCheckBox.Location = CType(resources.GetObject("RejectCheckBox.Location"), System.Drawing.Point)
            Me.RejectCheckBox.Name = "RejectCheckBox"
            Me.RejectCheckBox.RightToLeft = CType(resources.GetObject("RejectCheckBox.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.RejectCheckBox.Size = CType(resources.GetObject("RejectCheckBox.Size"), System.Drawing.Size)
            Me.RejectCheckBox.TabIndex = CType(resources.GetObject("RejectCheckBox.TabIndex"), Integer)
            Me.RejectCheckBox.Text = resources.GetString("RejectCheckBox.Text")
            Me.RejectCheckBox.TextAlign = CType(resources.GetObject("RejectCheckBox.TextAlign"), System.Drawing.ContentAlignment)
            Me.RejectCheckBox.Visible = CType(resources.GetObject("RejectCheckBox.Visible"), Boolean)
            '
            'CorruptImageCheckBox
            '
            Me.CorruptImageCheckBox.AccessibleDescription = resources.GetString("CorruptImageCheckBox.AccessibleDescription")
            Me.CorruptImageCheckBox.AccessibleName = resources.GetString("CorruptImageCheckBox.AccessibleName")
            Me.CorruptImageCheckBox.Anchor = CType(resources.GetObject("CorruptImageCheckBox.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.CorruptImageCheckBox.Appearance = CType(resources.GetObject("CorruptImageCheckBox.Appearance"), System.Windows.Forms.Appearance)
            Me.CorruptImageCheckBox.BackgroundImage = CType(resources.GetObject("CorruptImageCheckBox.BackgroundImage"), System.Drawing.Image)
            Me.CorruptImageCheckBox.CheckAlign = CType(resources.GetObject("CorruptImageCheckBox.CheckAlign"), System.Drawing.ContentAlignment)
            Me.CorruptImageCheckBox.Dock = CType(resources.GetObject("CorruptImageCheckBox.Dock"), System.Windows.Forms.DockStyle)
            Me.CorruptImageCheckBox.Enabled = CType(resources.GetObject("CorruptImageCheckBox.Enabled"), Boolean)
            Me.CorruptImageCheckBox.FlatStyle = CType(resources.GetObject("CorruptImageCheckBox.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.CorruptImageCheckBox.Font = CType(resources.GetObject("CorruptImageCheckBox.Font"), System.Drawing.Font)
            Me.CorruptImageCheckBox.Image = CType(resources.GetObject("CorruptImageCheckBox.Image"), System.Drawing.Image)
            Me.CorruptImageCheckBox.ImageAlign = CType(resources.GetObject("CorruptImageCheckBox.ImageAlign"), System.Drawing.ContentAlignment)
            Me.CorruptImageCheckBox.ImageIndex = CType(resources.GetObject("CorruptImageCheckBox.ImageIndex"), Integer)
            Me.CorruptImageCheckBox.ImeMode = CType(resources.GetObject("CorruptImageCheckBox.ImeMode"), System.Windows.Forms.ImeMode)
            Me.CorruptImageCheckBox.Location = CType(resources.GetObject("CorruptImageCheckBox.Location"), System.Drawing.Point)
            Me.CorruptImageCheckBox.Name = "CorruptImageCheckBox"
            Me.CorruptImageCheckBox.RightToLeft = CType(resources.GetObject("CorruptImageCheckBox.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.CorruptImageCheckBox.Size = CType(resources.GetObject("CorruptImageCheckBox.Size"), System.Drawing.Size)
            Me.CorruptImageCheckBox.TabIndex = CType(resources.GetObject("CorruptImageCheckBox.TabIndex"), Integer)
            Me.CorruptImageCheckBox.Text = resources.GetString("CorruptImageCheckBox.Text")
            Me.CorruptImageCheckBox.TextAlign = CType(resources.GetObject("CorruptImageCheckBox.TextAlign"), System.Drawing.ContentAlignment)
            Me.CorruptImageCheckBox.Visible = CType(resources.GetObject("CorruptImageCheckBox.Visible"), Boolean)
            '
            'WrongTaskCheckBox
            '
            Me.WrongTaskCheckBox.AccessibleDescription = resources.GetString("WrongTaskCheckBox.AccessibleDescription")
            Me.WrongTaskCheckBox.AccessibleName = resources.GetString("WrongTaskCheckBox.AccessibleName")
            Me.WrongTaskCheckBox.Anchor = CType(resources.GetObject("WrongTaskCheckBox.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.WrongTaskCheckBox.Appearance = CType(resources.GetObject("WrongTaskCheckBox.Appearance"), System.Windows.Forms.Appearance)
            Me.WrongTaskCheckBox.BackgroundImage = CType(resources.GetObject("WrongTaskCheckBox.BackgroundImage"), System.Drawing.Image)
            Me.WrongTaskCheckBox.CheckAlign = CType(resources.GetObject("WrongTaskCheckBox.CheckAlign"), System.Drawing.ContentAlignment)
            Me.WrongTaskCheckBox.Dock = CType(resources.GetObject("WrongTaskCheckBox.Dock"), System.Windows.Forms.DockStyle)
            Me.WrongTaskCheckBox.Enabled = CType(resources.GetObject("WrongTaskCheckBox.Enabled"), Boolean)
            Me.WrongTaskCheckBox.FlatStyle = CType(resources.GetObject("WrongTaskCheckBox.FlatStyle"), System.Windows.Forms.FlatStyle)
            Me.WrongTaskCheckBox.Font = CType(resources.GetObject("WrongTaskCheckBox.Font"), System.Drawing.Font)
            Me.WrongTaskCheckBox.Image = CType(resources.GetObject("WrongTaskCheckBox.Image"), System.Drawing.Image)
            Me.WrongTaskCheckBox.ImageAlign = CType(resources.GetObject("WrongTaskCheckBox.ImageAlign"), System.Drawing.ContentAlignment)
            Me.WrongTaskCheckBox.ImageIndex = CType(resources.GetObject("WrongTaskCheckBox.ImageIndex"), Integer)
            Me.WrongTaskCheckBox.ImeMode = CType(resources.GetObject("WrongTaskCheckBox.ImeMode"), System.Windows.Forms.ImeMode)
            Me.WrongTaskCheckBox.Location = CType(resources.GetObject("WrongTaskCheckBox.Location"), System.Drawing.Point)
            Me.WrongTaskCheckBox.Name = "WrongTaskCheckBox"
            Me.WrongTaskCheckBox.RightToLeft = CType(resources.GetObject("WrongTaskCheckBox.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.WrongTaskCheckBox.Size = CType(resources.GetObject("WrongTaskCheckBox.Size"), System.Drawing.Size)
            Me.WrongTaskCheckBox.TabIndex = CType(resources.GetObject("WrongTaskCheckBox.TabIndex"), Integer)
            Me.WrongTaskCheckBox.Text = resources.GetString("WrongTaskCheckBox.Text")
            Me.WrongTaskCheckBox.TextAlign = CType(resources.GetObject("WrongTaskCheckBox.TextAlign"), System.Drawing.ContentAlignment)
            Me.WrongTaskCheckBox.Visible = CType(resources.GetObject("WrongTaskCheckBox.Visible"), Boolean)
            '
            'WrongTaskComboBoxAdv
            '
            Me.WrongTaskComboBoxAdv.AccessibleDescription = resources.GetString("WrongTaskComboBoxAdv.AccessibleDescription")
            Me.WrongTaskComboBoxAdv.AccessibleName = resources.GetString("WrongTaskComboBoxAdv.AccessibleName")
            Me.WrongTaskComboBoxAdv.Anchor = CType(resources.GetObject("WrongTaskComboBoxAdv.Anchor"), System.Windows.Forms.AnchorStyles)
            Me.WrongTaskComboBoxAdv.BackgroundImage = CType(resources.GetObject("WrongTaskComboBoxAdv.BackgroundImage"), System.Drawing.Image)
            Me.WrongTaskComboBoxAdv.Dock = CType(resources.GetObject("WrongTaskComboBoxAdv.Dock"), System.Windows.Forms.DockStyle)
            Me.WrongTaskComboBoxAdv.Enabled = CType(resources.GetObject("WrongTaskComboBoxAdv.Enabled"), Boolean)
            Me.WrongTaskComboBoxAdv.FlatStyle = Syncfusion.Windows.Forms.Tools.ComboFlatStyle.System
            Me.WrongTaskComboBoxAdv.Font = CType(resources.GetObject("WrongTaskComboBoxAdv.Font"), System.Drawing.Font)
            Me.WrongTaskComboBoxAdv.IgnoreThemeBackground = True
            Me.WrongTaskComboBoxAdv.ImeMode = CType(resources.GetObject("WrongTaskComboBoxAdv.ImeMode"), System.Windows.Forms.ImeMode)
            Me.WrongTaskComboBoxAdv.IntegralHeight = CType(resources.GetObject("WrongTaskComboBoxAdv.IntegralHeight"), Boolean)
            Me.WrongTaskComboBoxAdv.Location = CType(resources.GetObject("WrongTaskComboBoxAdv.Location"), System.Drawing.Point)
            Me.WrongTaskComboBoxAdv.MaxDropDownItems = CType(resources.GetObject("WrongTaskComboBoxAdv.MaxDropDownItems"), Integer)
            Me.WrongTaskComboBoxAdv.Name = "WrongTaskComboBoxAdv"
            Me.WrongTaskComboBoxAdv.RightToLeft = CType(resources.GetObject("WrongTaskComboBoxAdv.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.WrongTaskComboBoxAdv.Size = CType(resources.GetObject("WrongTaskComboBoxAdv.Size"), System.Drawing.Size)
            Me.WrongTaskComboBoxAdv.TabIndex = CType(resources.GetObject("WrongTaskComboBoxAdv.TabIndex"), Integer)
            Me.WrongTaskComboBoxAdv.Text = resources.GetString("WrongTaskComboBoxAdv.Text")
            Me.WrongTaskComboBoxAdv.Visible = CType(resources.GetObject("WrongTaskComboBoxAdv.Visible"), Boolean)
            '
            'CaptureResultPanel
            '
            Me.AccessibleDescription = resources.GetString("$this.AccessibleDescription")
            Me.AccessibleName = resources.GetString("$this.AccessibleName")
            Me.AutoScroll = CType(resources.GetObject("$this.AutoScroll"), Boolean)
            Me.AutoScrollMargin = CType(resources.GetObject("$this.AutoScrollMargin"), System.Drawing.Size)
            Me.AutoScrollMinSize = CType(resources.GetObject("$this.AutoScrollMinSize"), System.Drawing.Size)
            Me.BackgroundImage = CType(resources.GetObject("$this.BackgroundImage"), System.Drawing.Image)
            Me.Enabled = CType(resources.GetObject("$this.Enabled"), Boolean)
            Me.Font = CType(resources.GetObject("$this.Font"), System.Drawing.Font)
            Me.ImeMode = CType(resources.GetObject("$this.ImeMode"), System.Windows.Forms.ImeMode)
            Me.Location = CType(resources.GetObject("$this.Location"), System.Drawing.Point)
            Me.Name = "CaptureResultPanel"
            Me.RightToLeft = CType(resources.GetObject("$this.RightToLeft"), System.Windows.Forms.RightToLeft)
            Me.Size = CType(resources.GetObject("$this.Size"), System.Drawing.Size)
            Me.InnerPanel.ResumeLayout(False)
            CType(Me.WrongTaskComboBoxAdv, System.ComponentModel.ISupportInitialize).EndInit()

        End Sub

#End Region

        Private mAttemptWire As SensorTaskAttempt
        Private mOriginalTaskCategory As SensorTaskCategory

        Private mWrongTaskIndexToTask As New Hashtable
        Public Sub WireAttempt(ByVal attempt As SensorTaskAttempt)
            If attempt Is Nothing Then Throw New ArgumentNullException("attempt")
            mAttemptWire = attempt
            SmoothPictureBox.EnabledImage = New Bitmap(attempt.ThumbnailImage)
            mOriginalTaskCategory = mAttemptWire.CapturedCategory

            mWrongTaskIndexToTask.Clear()
            WrongTaskComboBoxAdv.Items.Clear()

            For i As Integer = 0 To mAttemptWire.ParentTask.OriginatingFactory.ReassignableSensorTaskCategories.Count - 1
                Dim category As SensorTaskCategory = mAttemptWire.ParentTask.OriginatingFactory.ReassignableSensorTaskCategories(i)
                WrongTaskComboBoxAdv.Items.Add(SensorTaskCategorySupport.ToString(category))
                mWrongTaskIndexToTask(i) = category
                If category = mAttemptWire.CapturedCategory Then WrongTaskComboBoxAdv.SelectedIndex = i
            Next


            If WrongTaskComboBoxAdv.Items.Count = 0 Then
                ' If there isn't any category to change to, then disable the control
                WrongTaskComboBoxAdv.Items.Add(SensorTaskCategorySupport.ToString(attempt.CapturedCategory))
                WrongTaskCheckBox.Enabled = False
                WrongTaskComboBoxAdv.SelectedIndex = 0
            End If


        End Sub



        Protected Overrides Sub OnLoad(ByVal e As EventArgs)
            MyBase.OnLoad(e)
            If InDesignMode(Me) Then Return

            RejectCheckBox.Text = Messages.RejectThisImage(UICulture)
            CorruptImageCheckBox.Text = Messages.ImageIsCorrupt(UICulture)
            WrongTaskCheckBox.Text = Messages.WrongTask(UICulture)

            WrongTaskComboBoxAdv.Enabled = False
            WrongTaskComboBoxAdv.DropDownStyle = ComboBoxStyle.DropDownList
            If Not mAttemptWire Is Nothing Then
                RejectImage = mAttemptWire.IsRejected
                CorruptImage = mAttemptWire.HasCorruptImage
            End If
        End Sub

        Private mImageJustMarkedAsCorrupt As Boolean
        Public ReadOnly Property ImageJustMarkedAsCorrupt() As Boolean
            Get
                Return mImageJustMarkedAsCorrupt
            End Get
        End Property


        Protected Overrides Sub OnLayout(ByVal levent As LayoutEventArgs)
            MyBase.OnLayout(levent)
            If NearestForm Is Nothing Then Return
            RefreshAutomaticLayout(NearestForm.CreateGraphics)
            MyBase.HeaderText = "Captured Image" 'i18n
        End Sub

        Public Overrides Sub RefreshAutomaticLayout(ByVal graphics As Graphics)
            MyBase.RefreshAutomaticLayout(graphics)
            Dim baseMinimumWidth As Integer = MyBase.MinimumWidth

            RejectCheckBox.Font = GlobalUISettings.Defaults.Fonts.Small
            CorruptImageCheckBox.Font = GlobalUISettings.Defaults.Fonts.Small
            WrongTaskCheckBox.Font = GlobalUISettings.Defaults.Fonts.Small
            WrongTaskComboBoxAdv.Font = GlobalUISettings.Defaults.Fonts.Small

            ' CheckBox heights
            AutoSize.CheckBox(UICulture, graphics, WrongTaskCheckBox)
            AutoSize.CheckBox(UICulture, graphics, RejectCheckBox)
            AutoSize.CheckBox(UICulture, graphics, CorruptImageCheckBox)
            UI.AutoSize.ComboBoxAdv(UICulture, graphics, WrongTaskComboBoxAdv)

            ' Checkboxes are at the bottom of the panel, so we place them from the bottom up
            RejectCheckBox.Location = LowerLeft(InnerPanel, -RejectCheckBox.Height - TotalTopPadding - TotalBottomPadding)
            CorruptImageCheckBox.Location = UpperLeft(RejectCheckBox, -CorruptImageCheckBox.Height)

            ' Nudge the combo box in from the left margin, the checkbox should have no indent. The double indent is because it looks better
            Dim loc As Point = UpperLeft(CorruptImageCheckBox, -WrongTaskComboBoxAdv.Height)
            WrongTaskComboBoxAdv.Location = New Point(loc.X + 2 * GlobalUISettings.PaddingConstants.Undocumented.CheckboxIndent, loc.Y)
            WrongTaskCheckBox.Location = New Point(loc.X, UpperLeft(WrongTaskComboBoxAdv, -WrongTaskCheckBox.Height).Y)

            ' Fill the rest with the image
            SmoothPictureBox.Height = WrongTaskCheckBox.Location.Y - 1

            mMinimumWidth = 0
            mMinimumWidth = Math.Max(mMinimumWidth, WrongTaskCheckBox.Width + WrongTaskComboBoxAdv.Width)
            mMinimumWidth = Math.Max(mMinimumWidth, CorruptImageCheckBox.Width)
            mMinimumWidth = Math.Max(mMinimumWidth, RejectCheckBox.Width)
            mMinimumWidth = Math.Max(mMinimumWidth, baseMinimumWidth)

            ' So that the image isn't tiny, we make the minimum height the same as the width
            mMinimumHeight = mMinimumWidth

        End Sub

        Private mMinimumWidth As Integer
        Public Overrides ReadOnly Property MinimumWidth() As Integer
            Get
                Return mMinimumWidth
            End Get
        End Property

        Private mMinimumHeight As Integer
        Public Overrides ReadOnly Property MinimumHeight() As Integer
            Get
                Return mMinimumHeight
            End Get
        End Property

        Public Property CorruptImage() As Boolean
            Get
                Return CorruptImageCheckBox.CheckState = CheckState.Checked
            End Get
            Set(ByVal value As Boolean)
                If InDesignMode(Me) Or mAttemptWire Is Nothing Then Return
                If value Then
                    CorruptImageCheckBox.CheckState = CheckState.Checked
                Else
                    CorruptImageCheckBox.CheckState = CheckState.Unchecked
                End If
                mAttemptWire.HasCorruptImage = value
            End Set
        End Property

        Public Property RejectImage() As Boolean
            Get
                Return RejectCheckBox.CheckState = CheckState.Checked
            End Get
            Set(ByVal value As Boolean)
                If InDesignMode(Me) Or mAttemptWire Is Nothing Then Return
                If value Then
                    RejectCheckBox.CheckState = CheckState.Checked
                Else
                    RejectCheckBox.CheckState = CheckState.Unchecked
                End If
                mAttemptWire.IsRejected = value
            End Set
        End Property


        Private mRejectCheckStateBeforeCorruptChecked As CheckState = CheckState.Unchecked
        Private Sub CorruptImageCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles CorruptImageCheckBox.CheckedChanged

            If CorruptImageCheckBox.CheckState = CheckState.Checked Then
                mRejectCheckStateBeforeCorruptChecked = RejectCheckBox.CheckState
                RejectCheckBox.CheckState = CheckState.Checked
                RejectCheckBox.Enabled = False
                mImageJustMarkedAsCorrupt = True
            Else
                RejectCheckBox.CheckState = mRejectCheckStateBeforeCorruptChecked
                RejectCheckBox.Enabled = True
                RejectCheckBox.Refresh()
            End If

            mAttemptWire.HasCorruptImage = CorruptImageCheckBox.CheckState = CheckState.Checked
        End Sub

        Private Sub RejectCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles RejectCheckBox.CheckedChanged
            mAttemptWire.IsRejected = RejectCheckBox.CheckState = CheckState.Checked
        End Sub


        Private Sub WrongTaskCheckBox_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles WrongTaskCheckBox.CheckedChanged

            If WrongTaskCheckBox.CheckState = CheckState.Checked Then
                RejectCheckBox.Enabled = False
                CorruptImageCheckBox.Enabled = False
                WrongTaskComboBoxAdv.Enabled = True
            Else
                RejectCheckBox.Enabled = True
                CorruptImageCheckBox.Enabled = True
                WrongTaskComboBoxAdv.Enabled = False


                ' When the checkbox is unchecked, we should restore the category to its original
                mAttemptWire.CapturedCategory = Me.mOriginalTaskCategory
                For i As Integer = 0 To mAttemptWire.ParentTask.OriginatingFactory.ReassignableSensorTaskCategories.Count - 1
                    Dim category As SensorTaskCategory = mAttemptWire.ParentTask.OriginatingFactory.ReassignableSensorTaskCategories(i)
                    If category = mAttemptWire.CapturedCategory Then WrongTaskComboBoxAdv.SelectedIndex = i
                Next
            End If


            RaiseEvent WrongTaskCheckBoxCheckedChanged(Me, New EventArgs)
        End Sub

        Public Event WrongTaskCheckBoxCheckedChanged(ByVal sender As Object, ByVal e As EventArgs)
        Public Event WrongTaskComboBoxAdvSelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs)

        Private Sub WrongTaskComboBoxAdv_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles WrongTaskComboBoxAdv.SelectedIndexChanged

            ' If the map from WrongTaskComboBox.SelectedIndex to task is empty, then don't bother responding to this event
            If mWrongTaskIndexToTask.Count = 0 Then Return

            Dim newCategory As SensorTaskCategory = _
                DirectCast(mWrongTaskIndexToTask(WrongTaskComboBoxAdv.SelectedIndex), SensorTaskCategory)

            If newCategory = mAttemptWire.CapturedCategory Then Return

            ' Bind the selected category to the task wire
            mAttemptWire.CapturedCategory = newCategory

            ' Clear the target parts of those just captured
            mAttemptWire.TargetPartsOnCapture.RemoveRange(mAttemptWire.TargetPartsOnCapture.DeepCopy)

            ' Get the appropriate parts for the task
            mAttemptWire.TargetPartsOnCapture.AddRange(BodyParts.ForTask(mAttemptWire.CapturedCategory))


            RaiseEvent WrongTaskComboBoxAdvSelectedIndexChanged(Me, New EventArgs)

        End Sub
    End Class

End Namespace