''  ---
''  License
''  ---
''
''  This software was developed at the National Institute of Standards and
''  Technology (NIST) by employees of the Federal Government in the course
''  of their official duties. Pursuant to title 17 Section 105 of the
''  United States Code, this software is not subject to copyright protection
''  and is in the public domain. NIST assumes no responsibility  whatsoever for
''  its use by other parties, and makes no guarantees, expressed or implied,
''  about its quality, reliability, or any other characteristic.
''
''  ---
''  Disclaimer
''  ---
''  This software was developed to facilitate multimodal biometric data collection
''  for the Department of Homeland Security in accordance with Section 303 of the 
''  Border Security Act, codified as 8 U.S.C. 1732.  Specific hardware and software 
''  products identified in this software were used in order to perform the data 
''  collection. In no case does such identification imply recommendation or endorsement 
''  by the National Institute of Standards and Technology, nor does it imply that the 
''  products and equipment identified are necessarily the best available for the purpose.
''

'////////////////////////////////////////////////////////////////////////////////////
'
'   Module Name : mdlIADeviceControlDefs
'   Function : Constant Definition
'   Last modified date : 07/10/2002
'   Programmer : Jung Seh Hwan (LG Electronics Institute of Technology)
'
'////////////////////////////////////////////////////////////////////////////////////
Option Explicit On 

Namespace Mbark
    Public Module IADeviceControlDefs
        ' Error Definition --------------------------------------------------------
        Public Const IADC_ERROR_NONE = 0

        Public Const IADC_ERROR_OPEN = &H81020001
        Public Const IADC_ERROR_PARAMETER = &H81020002
        Public Const IADC_ERROR_TIME_OUT = &H81020003
        Public Const IADC_ERROR_OUT_RANGE = &H81020004
        Public Const IADC_ERROR_SERIAL_OPEN = &H81020005
        Public Const IADC_ERROR_SERIAL_COMM = &H81020006
        Public Const IADC_ERROR_GRABBER_OPEN = &H81020007
        Public Const IADC_ERROR_GRABBER_CAPTURE = &H81020008
        Public Const IADC_ERROR_LICENSE = &H81020009
        Public Const IADC_ERROR_FAKE_EYE = &H81020010
        Public Const IADC_ERROR_700_LED_FAILURE = &H81020011
        Public Const IADC_ERROR_800_LED_FAILURE = &H81020012
        Public Const IADC_ERROR_700_800_LED_FAILURE = &H81020013

        Public Const IADC_ERROR_UNKNOWN = &H8102FFFF


        ' Video Mode -------------------------------------------------------------
        Public Const RECOGNIZE_MODE = &H100
        Public Const ENROLL_MODE = &H200


        ' Which Illuminator for manual -------------------------------------------
        Public Const ILL_700_RIGHT = &H1
        Public Const ILL_700_LEFT = &H2
        Public Const ILL_900_RIGHT = &H4
        Public Const ILL_900_LEFT = &H8
        Public Const ILL_RIGHT = &H5
        Public Const ILL_LEFT = &HA
        Public Const ILL_ALL = &HF


        ' Indicator Mode ---------------------------------------------------------
        Public Const IND_PROCESSING_MODE = &H0
        Public Const IND_ACCEPT_MODE = &H1
        Public Const IND_REJECT_MODE = &H2
        Public Const IND_BUSY_MODE = &H3
        Public Const IND_ERROR_MODE = &H4
        Public Const IND_TURN_OFF = &H5


        ' Sound Message ----------------------------------------------------------
        Public Const SOU_IDENTIFIED = &H1
        Public Const SOU_CANNOT_IDENTIFY = &H2
        Public Const SOU_STEP_FORWARD = &H3
        Public Const SOU_STEP_BACK = &H4
        Public Const SOU_ENROLLED = &H5
        Public Const SOU_START_ENROLL = &H6


        ' OU Type ----------------------------------------------------------------
        Public Const IAOU3000_TYPE = &H200


        ' Range ------------------------------------------------------------------
        Public Const TOO_NEAR_RANGE = &H100
        Public Const OPERATING_RANGE = &H200
        Public Const TOO_FAR_RANGE = &H300
        Public Const OUT_RANGE = &H400

        ' Illuminator ------------------------------------------------------------
        Public Const RIGHT_ILLUMINATOR = 100
        Public Const LEFT_ILLUMINATOR = 200
    End Module

End Namespace


