''  ---
''  License
''  ---
''
''  This software was developed at the National Institute of Standards and
''  Technology (NIST) by employees of the Federal Government in the course
''  of their official duties. Pursuant to title 17 Section 105 of the
''  United States Code, this software is not subject to copyright protection
''  and is in the public domain. NIST assumes no responsibility  whatsoever for
''  its use by other parties, and makes no guarantees, expressed or implied,
''  about its quality, reliability, or any other characteristic.
''
''  ---
''  Disclaimer
''  ---
''  This software was developed to facilitate multimodal biometric data collection
''  for the Department of Homeland Security in accordance with Section 303 of the 
''  Border Security Act, codified as 8 U.S.C. 1732.  Specific hardware and software 
''  products identified in this software were used in order to perform the data 
''  collection. In no case does such identification imply recommendation or endorsement 
''  by the National Institute of Standards and Technology, nor does it imply that the 
''  products and equipment identified are necessarily the best available for the purpose.
''

Option Strict On

Imports System.Xml

Namespace Mbark

    Public Class ConfigurationFragment

        Protected Const ConfigXPath As String = "//configuration"
        Protected Const ConfigSectionsXPath As String = "//configuration/configSections"
        Protected Const AppSettingsXPath As String = "//configuration/appSettings"

        Public Shared ReadOnly Property EmptyConfiguration() As XmlDocument
            Get
                Dim xml As New XmlDocument
                With xml
                    .AppendChild(.CreateXmlDeclaration("1.0", Nothing, Nothing))
                    Dim root As XmlNode = .AppendChild(.CreateElement("configuration"))
                    root.AppendChild(.CreateElement("configSections"))
                    root.AppendChild(.CreateElement("appSettings"))
                End With
                Return xml
            End Get
        End Property

        Protected Shared Sub InjectApplicationSetting(ByVal xml As XmlDocument, ByVal key As String, ByVal value As String)
            If xml Is Nothing Then Throw New ArgumentNullException("xml")
            Dim parent As XmlNode = xml.SelectSingleNode(AppSettingsXPath)
            Dim element As XmlElement = xml.CreateElement("add")
            element.SetAttribute("key", key)
            element.SetAttribute("value", value)
            parent.AppendChild(element)
        End Sub

        Public Overridable Sub Inject(ByVal xml As XmlDocument)
            Throw New TrespassingException
        End Sub

    End Class


    Public Class GlobalConfiguration
        Inherits ConfigurationFragment

        Private mDevelopmentRoot As String = "C:\MBARK"
        Public Property DevelopmentRoot() As String
            Get
                Return mDevelopmentRoot
            End Get
            Set(ByVal value As String)
                mDevelopmentRoot = value
            End Set
        End Property

        Public Overrides Sub Inject(ByVal xml As XmlDocument)
            InjectApplicationSetting(xml, "Main.DevelopmentRoot", DevelopmentRoot)
        End Sub

    End Class

    Public Class DatabaseConfiguration
        Inherits ConfigurationFragment

        Private mConnectionString As String
        Public Property ConnectionString() As String
            Get
                Return mConnectionString
            End Get
            Set(ByVal Value As String)
                mConnectionString = Value
            End Set
        End Property

        Public Overrides Sub Inject(ByVal xml As XmlDocument)
            InjectApplicationSetting(xml, "Main.ConnectionString", ConnectionString())
        End Sub

    End Class

End Namespace
