/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nist.NDFS.java.demo.consumer;

import org.nist.NDFS.Buffer;
import org.nist.NDFS.SmartFlow;
import org.nist.NDFS.Flow;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

/**
 *
 * @author Imad Hamchi
 */
public class Main {

    public static void main(String[] args) {
        Flow flow = null;

        SmartFlow sf = null;

        sf = new SmartFlow();

        if (sf == null) {
            System.out.println("Error");
            return;
        }

        sf.init(args.length, args);

        if (!sf.ready_to_run()) {
            System.out.println("Error : " + sf.strerror());
            sf.destroy();
            return;
        }

        if (sf.connectToApplicationServer("consumer", "demo") == false) {
            System.out.println("Error : " + sf.strerror());
            sf.destroy();
            return;
        }

        flow = (Flow) sf.makeInputFlow("Flow_Java", "FlowDemoIn", "blocksize=16", "groupDemo");

        if (flow == null) {
            System.out.println(sf.strerror() + "Flow Failed");
            sf.destroy();
            return;
        }

        if (!flow.get_FlowType().equals("Flow_Java")) {
            System.out.println("Flow Cast Failed");
            sf.destroy();
            return;
        }

        System.out.println("Flow Demo In Starting ...");

        if (flow.start() == false) {
            System.out.println(sf.strerror());
            sf.destroy();
            return;
        }

        System.out.println("Flow Demo In Start OK");
        double value = -1;

        while (true == true) {
            Buffer buffer = flow.getBuffer();
            byte[] data = buffer.pop_data();

            ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
            DataInputStream dataStream = new DataInputStream(byteStream);
            try {
                value = dataStream.readDouble();
            } catch (IOException ex) {
                ex.printStackTrace();
            }

            if (flow.releaseBuffer(buffer) == false) {
                System.out.println("Receive Error");
            }
            System.out.println(value+" is received");

        }



    }
}

