#include "Smartflow.h"

#include "org_nist_NDFS_SmartFlowJavaLibrary.h"
#include "Flow.h"
#include "Flow_Java/Flow_Java.h"
#include <iostream>
#include <vector>

using namespace std;
using namespace smartflow;

static Smartflow * sf;
vector<Flow *> * flows;
vector<Buffer *> * buffers;

static int flows_count = -1;
static int buffers_count = -1;
/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_create
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1create
(JNIEnv *, jobject) {
	
	sf = new Smartflow;
	flows = new vector<Flow *>;
	buffers = new vector<Buffer *>;
	
}


/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_destroy
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1destroy
(JNIEnv *, jobject) {
	//delete sf;
}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_init
 * Signature: (I[Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1init__I_3Ljava_lang_String_2
(JNIEnv *env, jobject, jint argc, jobjectArray argv){
	
	int argc_ = argc;
	char **argv_;//[argc];
	
	argv_ = (char **) malloc(sizeof(char*) * (argc + 1));
	
	char blank[10] = "blank";
	
	argv_[0] = (char *) malloc(sizeof(char) * strlen(blank) + 1);
	strcpy (argv_[0], blank);
	
	for (int i=0; i < argc; i++) {
		jstring arg_  = (jstring) env->GetObjectArrayElement(argv, i);
		const char *arg = env->GetStringUTFChars(arg_, 0);
		argv_[i + 1] = (char *) malloc(sizeof(char) * strlen(arg) + 1);
		strcpy (argv_[i+1], arg);
	}
	argc_++;
	sf->init(argc_, argv_);
	//because init() removes the specific SF argument here, we should update 
	//argc and argv accordingly to argc_ and argv_
	
	for (int i=0; i < argc_; i++)
		free(argv_[i]);
	free(argv_);
}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_init
 * Signature: (I[Ljava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1init__I_3Ljava_lang_String_2Ljava_lang_String_2
(JNIEnv *env, jobject, jint argc, jobjectArray argv, jstring application) {
	
	int argc_ = argc;
	char **argv_;//[argc];
	
	argv_ = (char **) malloc(sizeof(char*) * (argc + 1));
	
	char blank[10] = "blank";
	
	argv_[0] = (char *) malloc(sizeof(char) * strlen(blank) + 1);
	strcpy (argv_[0], blank);
	
	for (int i=0; i < argc; i++) {
		jstring arg_  = (jstring) env->GetObjectArrayElement(argv, i);
		const char *arg = env->GetStringUTFChars(arg_, 0);
		argv_[i + 1] = (char *) malloc(sizeof(char) * strlen(arg) + 1);
		strcpy (argv_[i+1], arg);
	}
	argc_++;
	//sf->init(argc_, argv_);
	
	const char *strptr = env->GetStringUTFChars(application, 0);
	std::string application_(strptr, env->GetStringUTFLength(application));
	env->ReleaseStringUTFChars(application, strptr);
	
	sf->init(argc_, argv_, false, application_);
	
	//because init() removes the specific SF argument here, we should update 
	//argc and argv accordingly to argc_ and argv_
	
	for (int i=0; i < argc_; i++)
		free(argv_[i]);
	free(argv_);
	
}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_makeInputFlow
 * Signature: (Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1makeInputFlow__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2
(JNIEnv *env, jobject, jstring type, jstring name, jstring args, jstring group){
	const char *strptr = env->GetStringUTFChars(type, 0);
	std::string type_(strptr, env->GetStringUTFLength(type));
	env->ReleaseStringUTFChars(type, strptr);
	
	const char *strptr2 = env->GetStringUTFChars(name, 0);
	std::string name_(strptr2, env->GetStringUTFLength(name));
	env->ReleaseStringUTFChars(name, strptr2);
	
	const char *strptr3 = env->GetStringUTFChars(args, 0);
	std::string args_(strptr3, env->GetStringUTFLength(args));
	env->ReleaseStringUTFChars(args, strptr3);
	
	const char *strptr4 = env->GetStringUTFChars(group, 0);
	std::string group_(strptr4, env->GetStringUTFLength(group));
	env->ReleaseStringUTFChars(group, strptr4);
	Flow* newFlow = sf->makeInputFlow(type_, name_, args_, group_,DO_NOT_DROP_BUFFER);
	
	if (newFlow != 0) {
        flows_count++;
        flows->push_back(newFlow);
	}  
	else
		return -1;    
	
	return flows_count;
	
}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_makeInputFlow
 * Signature: (Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1makeInputFlow__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2I
(JNIEnv *env, jobject, jstring type, jstring name, jstring args, jstring group, jint flowControlPolicy){
	
		const char *strptr = env->GetStringUTFChars(type, 0);
		std::string type_(strptr, env->GetStringUTFLength(type));
		env->ReleaseStringUTFChars(type, strptr);
		
		const char *strptr2 = env->GetStringUTFChars(name, 0);
		std::string name_(strptr2, env->GetStringUTFLength(name));
		env->ReleaseStringUTFChars(name, strptr2);
		
		const char *strptr3 = env->GetStringUTFChars(args, 0);
		std::string args_(strptr3, env->GetStringUTFLength(args));
		env->ReleaseStringUTFChars(args, strptr3);
		
		const char *strptr4 = env->GetStringUTFChars(group, 0);
		std::string group_(strptr4, env->GetStringUTFLength(group));
		env->ReleaseStringUTFChars(group, strptr4);
		
		flow_policy_t flowControlPolicy_ = INVALID_POLICY;
		
		if (flowControlPolicy == DO_NOT_DROP_BUFFER)
			flowControlPolicy_ = DO_NOT_DROP_BUFFER;
		else if (flowControlPolicy == DROP_MOST_RECENT_BUFFER)
			flowControlPolicy_ = DROP_MOST_RECENT_BUFFER;
		else if (flowControlPolicy == DROP_OLDEST_BUFFER)
			flowControlPolicy_ = DROP_OLDEST_BUFFER;
		
		Flow* newFlow = sf->makeInputFlow(type_, name_, args_, group_, flowControlPolicy_);
		
		if (newFlow != 0) {
			flows_count++;
			flows->push_back(newFlow);
		}
		else
			return -1;    
		
		return flows_count;
		
}
	

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_makeOutputFlow
 * Signature: (Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1makeOutputFlow
(JNIEnv *env, jobject, jstring type, jstring name, jstring args, jstring group){
		const char *strptr = env->GetStringUTFChars(type, 0);
		std::string type_(strptr, env->GetStringUTFLength(type));
		env->ReleaseStringUTFChars(type, strptr);
		
		const char *strptr2 = env->GetStringUTFChars(name, 0);
		std::string name_(strptr2, env->GetStringUTFLength(name));
		env->ReleaseStringUTFChars(name, strptr2);
		
		const char *strptr3 = env->GetStringUTFChars(args, 0);
		std::string args_(strptr3, env->GetStringUTFLength(args));
		env->ReleaseStringUTFChars(args, strptr3);
		
		const char *strptr4 = env->GetStringUTFChars(group, 0);
		std::string group_(strptr4, env->GetStringUTFLength(group));
		env->ReleaseStringUTFChars(group, strptr4);
		
		Flow* newFlow = sf->makeOutputFlow(type_, name_, args_, group_);
		
		if (newFlow != 0) {
			flows_count++;
			flows->push_back(newFlow);
		}
		else
			return -1;  
		
		return flows_count;
		
}
	

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_makeSynchronizedOutputFlow
 * Signature: (Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1makeSynchronizedOutputFlow
	(JNIEnv *env, jobject, jstring type, jstring name, jint numberOfConsumersExpected, jstring args, jstring group){
		const char *strptr = env->GetStringUTFChars(type, 0);
		std::string type_(strptr, env->GetStringUTFLength(type));
		env->ReleaseStringUTFChars(type, strptr);
		
		const char *strptr2 = env->GetStringUTFChars(name, 0);
		std::string name_(strptr2, env->GetStringUTFLength(name));
		env->ReleaseStringUTFChars(name, strptr2);
		
		const char *strptr3 = env->GetStringUTFChars(args, 0);
		std::string args_(strptr3, env->GetStringUTFLength(args));
		env->ReleaseStringUTFChars(args, strptr3);
		
		const char *strptr4 = env->GetStringUTFChars(group, 0);
		std::string group_(strptr4, env->GetStringUTFLength(group));
		env->ReleaseStringUTFChars(group, strptr4);
		
		
		Flow* newFlow = sf->makeSynchronizedOutputFlow(type_, name_, numberOfConsumersExpected, args_, group_);
		
		if (newFlow != 0) {
			flows_count++;
			flows->push_back(newFlow);
		}
		else
			return -1;  
		
		return flows_count;
		
	}	

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_destroyFlow
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1destroyFlow
	(JNIEnv *, jobject, jint flow_id) {
		if (sf->destroyFlow(flows->at(flow_id)) == true)
			return JNI_TRUE;
		else
			return JNI_FALSE;
	}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_ready_to_run
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1ready_1to_1run
	(JNIEnv *, jobject) {
		if (sf->ready_to_run() == true)
			return JNI_TRUE;
		else
			return JNI_FALSE;
	}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_stop
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1stop
	(JNIEnv *, jobject){
		if (sf->stop() == true)
			return JNI_TRUE;
		else
			return JNI_FALSE;
	}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_application_name
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1application_1name
	(JNIEnv *env, jobject) {
		string application_name;
		
		application_name = sf->application_name();
		
		return env->NewStringUTF(application_name.c_str());
	}		

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_connect_to_application_server
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1connect_1to_1application_1server__
	(JNIEnv *, jobject) {
	if (sf->connect_to_application_server() == true)
		return JNI_TRUE;
	else
		return JNI_FALSE;
	}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_connect_to_application_server
 * Signature: (Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1connect_1to_1application_1server__Ljava_lang_String_2
	(JNIEnv *env, jobject, jstring clientname){
		const char *strptr = env->GetStringUTFChars(clientname, 0);
		std::string clientname_(strptr, env->GetStringUTFLength(clientname));
		env->ReleaseStringUTFChars(clientname, strptr);
		if (sf->connect_to_application_server(clientname_) == true)
			return JNI_TRUE;
		else
			return JNI_FALSE;
	}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_connect_to_application_server
 * Signature: (Ljava/lang/String;Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1connect_1to_1application_1server__Ljava_lang_String_2Ljava_lang_String_2
	(JNIEnv *env, jobject, jstring clientname, jstring clientgroup){
	
		const char *strptr = env->GetStringUTFChars(clientname, 0);
		std::string clientname_(strptr, env->GetStringUTFLength(clientname));
		env->ReleaseStringUTFChars(clientname, strptr);
		
		const char *strptr2 = env->GetStringUTFChars(clientgroup, 0);
		std::string clientgroup_(strptr2, env->GetStringUTFLength(clientgroup));
		env->ReleaseStringUTFChars(clientgroup, strptr2);
		
		if ( sf->connect_to_application_server(clientname_, clientgroup_) == true)
			return JNI_TRUE;
		else
			return JNI_FALSE;
	}
	

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_disconnect_from_application_server
 * Signature: ()Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1disconnect_1from_1application_1server
	(JNIEnv *, jobject){
		if (sf->disconnect_from_application_server() == true)
			return JNI_TRUE;
		else
			return JNI_FALSE;
			
	}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_startClient
 * Signature: (Ljava/lang/String;Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1startClient__Ljava_lang_String_2Ljava_lang_String_2
	(JNIEnv *env, jobject, jstring clientpath, jstring server){
		const char *strptr = env->GetStringUTFChars(clientpath, 0);
		std::string client_path(strptr, env->GetStringUTFLength(clientpath));
		env->ReleaseStringUTFChars(clientpath, strptr);
		
		const char *strptr2 = env->GetStringUTFChars(server, 0);
		std::string server_(strptr2, env->GetStringUTFLength(server));
		env->ReleaseStringUTFChars(server, strptr2);
		
		if (sf->startClient(client_path, server_) == true)
			return JNI_TRUE;
		else
			return JNI_FALSE;
	}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_startClient
 * Signature: (Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1startClient__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2
	(JNIEnv *env, jobject, jstring clientpath, jstring server, jstring arguments){
		const char *strptr = env->GetStringUTFChars(clientpath, 0);
		std::string client_path(strptr, env->GetStringUTFLength(clientpath));
		env->ReleaseStringUTFChars(clientpath, strptr);
		
		const char *strptr2 = env->GetStringUTFChars(server, 0);
		std::string server_(strptr2, env->GetStringUTFLength(server));
		env->ReleaseStringUTFChars(server, strptr2);
		
		const char *strptr3 = env->GetStringUTFChars(arguments, 0);
		std::string arguments_(strptr3, env->GetStringUTFLength(arguments));
		env->ReleaseStringUTFChars(arguments, strptr3);
		if (sf->startClient(client_path, server_, arguments_) == true)
			return JNI_TRUE;
		else
			return JNI_FALSE;
	}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_startClient
 * Signature: (Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1startClient__Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2Ljava_lang_String_2
		(JNIEnv *env, jobject, jstring clientpath, jstring server, jstring arguments, jstring parameters) {
			const char *strptr = env->GetStringUTFChars(clientpath, 0);
			std::string client_path(strptr, env->GetStringUTFLength(clientpath));
			env->ReleaseStringUTFChars(clientpath, strptr);
			
			const char *strptr2 = env->GetStringUTFChars(server, 0);
			std::string server_(strptr2, env->GetStringUTFLength(server));
			env->ReleaseStringUTFChars(server, strptr2);
			
			const char *strptr3 = env->GetStringUTFChars(arguments, 0);
			std::string arguments_(strptr3, env->GetStringUTFLength(arguments));
			env->ReleaseStringUTFChars(arguments, strptr3);
			
			const char *strptr4 = env->GetStringUTFChars(parameters, 0);
			std::string parameters_(strptr4, env->GetStringUTFLength(parameters));
			env->ReleaseStringUTFChars(parameters, strptr4);
			
			if (sf->startClient(client_path, server_, arguments_, parameters_) == true)
				return JNI_TRUE;
			else
				return JNI_FALSE;
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_stopClient
 * Signature: (Ljava/lang/String;Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1stopClient
		(JNIEnv *env, jobject, jstring clientName, jstring clientGroup) {
			const char *strptr = env->GetStringUTFChars(clientName, 0);
			std::string client_name(strptr, env->GetStringUTFLength(clientName));
			env->ReleaseStringUTFChars(clientName, strptr);
			
			const char *strptr2 = env->GetStringUTFChars(clientGroup, 0);
			std::string client_group(strptr2, env->GetStringUTFLength(clientGroup));
			env->ReleaseStringUTFChars(clientGroup, strptr2);
			
			if (sf->stopClient(client_name, client_group) == true )
				return JNI_TRUE;
			else
				return JNI_FALSE;
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_getApplicationDescription
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1getApplicationDescription
		(JNIEnv *env, jobject){
			string application_description;
			
			sf->getApplicationDescription(application_description);
			
			return env->NewStringUTF(application_description.c_str());
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_getServerList
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1getServerList
		(JNIEnv *env, jobject) {
			string server_list;
			
			sf->getServerList(server_list);
			
			return env->NewStringUTF(server_list.c_str());
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_getLastModifications
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1getLastModifications
		(JNIEnv *env, jobject) {
			string last_modifications;
			
			sf->getLastModifications(last_modifications);
			
			return env->NewStringUTF(last_modifications.c_str());
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_set_error
 * Signature: (J)V
 */
JNIEXPORT void JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1set_1error
		(JNIEnv *, jobject, jlong error) {
			 sf->set_error(error);
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_error
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1error
		(JNIEnv *env, jobject) {
			return sf->error();
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    sf_strerror
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_sf_1strerror
		(JNIEnv *env, jobject){
			string strerror;
			
			strerror = sf->strError();
			
			return env->NewStringUTF(strerror.c_str());
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_start
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1start
		(JNIEnv *, jobject, jint flow_id){
			Flow_Java *f_as = (Flow_Java *) flows->at(flow_id);
			
			if (f_as->start() == true)
				return JNI_TRUE;
			else
				return JNI_FALSE;

		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_get_FlowType
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1get_1FlowType
		(JNIEnv *env, jobject, jint flow_id){
			string flow_type = flows->at(flow_id)->getFlowType();
			
		return env->NewStringUTF(flow_type.c_str());
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_get_FlowDesc
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1get_1FlowDesc
		(JNIEnv *env, jobject, jint flow_id){
			string flow_desc = flows->at(flow_id)->getFlowDesc();
			
			return env->NewStringUTF(flow_desc.c_str());
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_get_mode
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1get_1mode
		(JNIEnv *, jobject, jint flow_id){
			 return flows->at(flow_id)->getMode();
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_get_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1get_1name
		(JNIEnv *env, jobject, jint flow_id){
			string flow_name = flows->at(flow_id)->getName();
			
			return env->NewStringUTF(flow_name.c_str());

		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_get_type
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1get_1type
		(JNIEnv *env, jobject, jint flow_id){
			string flow_type = flows->at(flow_id)->getType();
			
			return env->NewStringUTF(flow_type.c_str());
		}
/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_get_args
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1get_1args
		(JNIEnv *env, jobject, jint flow_id){
			string flow_args = flows->at(flow_id)->getArgs();
			
			return env->NewStringUTF(flow_args.c_str());
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_get_HistorySize
 * Signature: (I)J
 */
JNIEXPORT jlong JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1get_1HistorySize
		(JNIEnv *, jobject, jint flow_id){
		return flows->at(flow_id)->getHistorySize();
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_getBuffer
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1getBuffer
		(JNIEnv *, jobject, jint flow_id){
			Flow_Java *f_as = (Flow_Java *) flows->at(flow_id);
			
			if ( f_as != NULL) {
				Buffer *tmp_buf = f_as->getBuffer();
				if ( tmp_buf != NULL ) {
					buffers_count++;
					buffers->push_back(tmp_buf);
				}
				else
					std::cout << "[ getBufferFlow_Ant_Simulation ] Buffer is NULL" << std::endl;
			}
			else
				std::cout << "[ getBufferFlow_Ant_Simulation ] Flow not found" << std::endl;
			
			return buffers_count;

		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_releaseBuffer
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1releaseBuffer
		(JNIEnv *, jobject, jint flow_id, jint buffer_id){
			Flow_Java *f_as = (Flow_Java *) flows->at(flow_id);
			Buffer *buffer = buffers->at(buffer_id);
			
			if ( (f_as != NULL) && (buffer != NULL) ){
				if (f_as->releaseBuffer(buffer) == true)
					return JNI_TRUE;
				else
					return JNI_FALSE;
			
			}else {
				std::cout << "[ releaseBufferFlow_Ant_Simulation ] Flow not found or Buffer not found" << std::endl;
				return JNI_FALSE;
			}

		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    f_cancelBuffer
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_f_1cancelBuffer
		(JNIEnv *, jobject, jint flow_id, jint buffer_id){
			Flow_Java *f_as = (Flow_Java *) flows->at(flow_id);
			Buffer *buffer = buffers->at(buffer_id);
			
			if ( (f_as != NULL) && (buffer != NULL) ) {
				if (f_as->cancelBuffer(buffer) == true)
					return JNI_TRUE;
				else
					return JNI_FALSE;
			} else {
				std::cout << "[ cancelBufferFlow_Ant_Simulation ] Flow not found or Buffer not found" << std::endl;
				return JNI_FALSE;
			}

		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    b_init_buf
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_b_1init_1buf
		(JNIEnv *, jobject, jint buffer_id){
			Buffer *tmp_buf = buffers->at(buffer_id);
			
			if ( tmp_buf != NULL ) {
				if (tmp_buf->init_buf() == true)
					return JNI_TRUE;
				else
					return JNI_FALSE;
			
			}else {
				std::cout << "[ init_buf ] Buffer not found" << std::endl;
				return JNI_FALSE;
			}   

		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    b_goto_nextblock
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_b_1goto_1nextblock
		(JNIEnv *, jobject, jint buffer_id) {
			Buffer *tmp_buf = buffers->at(buffer_id);
			
			if ( tmp_buf != NULL ) {
				if ( tmp_buf->gotoNextBlock() == true )
					//return JNI_TRUE;
					;
				else {
					std::cout << "[ goto_nextblock ] NDFS Buffer::goto_nextblock failed" << std::endl;
					//return JNI_FALSE;
				}
			}
			else {
				std::cout << "[ goto_nextblock ] Buffer not found" << std::endl;
				//return JNI_FALSE;
			}
		}			
/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    b_push_long
 * Signature: (IJ)V
 */
JNIEXPORT void JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_b_1push_1long
		(JNIEnv *, jobject, jint buffer_id, jlong value){
			long value_ = value;
			Buffer *tmp_buf = buffers->at(buffer_id);
			
			if ( tmp_buf != NULL ) {
				if ( tmp_buf->push_data(&value_, sizeof(value_)) == true )
					//return JNI_TRUE;
					;
				else {
					std::cout << "[ push_long ] NDFS Buffer::push_data failed" << std::endl;
					//return JNI_FALSE;
				}
			}
			else {
				std::cout << "[ push_long ] Buffer not found" << std::endl;
				//return JNI_FALSE;
			}
		}
		//Code reviewed up to here...????

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    b_push_data
 * Signature: (I[B)V
 */
JNIEXPORT void JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_b_1push_1data
(JNIEnv *env, jobject, jint buffer_id, jbyteArray jarray){
			jboolean isCopy1;
			
			jbyte* srcArrayElems = env->GetByteArrayElements(jarray, &isCopy1);
			
			int array_length = env->GetArrayLength(jarray);
			
			Buffer *tmp_buf = buffers->at(buffer_id);
			
			if ( (tmp_buf != NULL) && (tmp_buf->data() != NULL) ) {
				ACE_OS::memcpy(tmp_buf->data() , srcArrayElems, array_length);
				tmp_buf->set_size(array_length);
			}
			else
				std::cout << "[ push_data ] Buffer not found or NDFS Buffer::data() is NULL" << std::endl;
			
			env->ReleaseByteArrayElements(jarray, srcArrayElems, JNI_ABORT);
		}			

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    b_pop_long
 * Signature: (I)J
 */
JNIEXPORT jlong JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_b_1pop_1long
		(JNIEnv *, jobject, jint buffer_id){
			jlong value = 0;
			
			Buffer *tmp_buf = buffers->at(buffer_id);
			
			if ( tmp_buf != NULL ) {
				if ( tmp_buf->pop_data(&value, sizeof(value)) != true)
					std::cout << "[ pop_long ] NDFS Buffer::pop_data() failed" << std::endl;
			}
			else
				std::cout << "[ pop_long ] Buffer not found" << std::endl;
			
			return value;
		}

/*
 * Class:     org_nist_NDFS_SmartFlowJavaLibrary
 * Method:    b_pop_data
 * Signature: (I)[B
 */
JNIEXPORT jbyteArray JNICALL Java_org_nist_NDFS_SmartFlowJavaLibrary_b_1pop_1data
		(JNIEnv *env, jobject, jint buffer_id){
			Buffer *tmp_buf = buffers->at(buffer_id);
			
			jbyteArray outputByteArray;
			
			if ( tmp_buf != NULL ) {  
				int size_buffer = tmp_buf->get_size();
				
				jbyte *data_array = (jbyte *) malloc(sizeof(jbyte) * size_buffer );	
				
				ACE_OS::memcpy(data_array, tmp_buf->data(), size_buffer);
				
				outputByteArray = env->NewByteArray (size_buffer);
				env->SetByteArrayRegion (outputByteArray, 0, size_buffer, (jbyte *) data_array);
				
				free(data_array);
			}
			else {
				std::cout << "[ pop_data ] Buffer not found" << std::endl;
				outputByteArray = env->NewByteArray (0);
			}
			
			return outputByteArray;
		}

