/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.nist.NDFS.java.demo.provider;

import org.nist.NDFS.Buffer;
import org.nist.NDFS.SmartFlow;
import org.nist.NDFS.Flow;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**
 *
 * @author Imad Hamchi
 */
public class Main {

    public static void main(String[] args) {
        Flow flow = null;

        SmartFlow sf = null;

        sf = new SmartFlow();

        if (sf == null) {
            System.out.println("Error");
            return;
        }

        sf.init(args.length, args);

        if (!sf.ready_to_run()) {
            System.out.println("Error : " + sf.strerror());
            sf.destroy();
            return;
        }

        if (sf.connectToApplicationServer("provider", "demo") == false) {
            System.out.println("Error : " + sf.strerror());
            sf.destroy();
            return;
        }

        flow = (Flow) sf.makeOutputFlow("Flow_Java", "FlowDemoOut", "blocksize=16", "groupDemo");

        if (flow == null) {
            System.out.println(sf.strerror() + "Flow Failed");
            sf.destroy();
            return;
        }

        if (!flow.get_FlowType().equals("Flow_Java")) {
            System.out.println("Flow Cast Failed");
            sf.destroy();
            return;
        }

        System.out.println("Flow Demo Out Starting ...");

        if (flow.start() == false) {
            System.out.println(sf.strerror());
            sf.destroy();
            return;
        }

        System.out.println("Flow Demo Out Start OK");   

        double data = 0.0;
        while (true == true) {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(8);
            DataOutputStream dataStream = new DataOutputStream(byteStream);
            try {
                dataStream.writeDouble(data);
                dataStream.flush();
            } catch (IOException ex) {
                ex.printStackTrace();
            }

            Buffer buffer = flow.getBuffer();
            buffer.init_buf();

            buffer.push_data(byteStream.toByteArray());

            if (flow.releaseBuffer(buffer) == false) {
                System.out.println("Send Error");
            }
            System.out.println(data + " is sent");
            try {
                Thread.sleep(1000);

            } catch (Exception e) {
                e.printStackTrace();
            }
            
            data++;
        }



    }
}

