/*
 * SmartFlow.java
 *
 * Created on June 14, 2007, 1:02 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.nist.NDFS;

//import org.nist.NDFS.flows.*;

/**
 *
 * @author Imad Hamchi
 */
public class SmartFlow {
    
    public static final int INVALID_POLICY = 0;
    public static final int DO_NOT_DROP_BUFFER = 1;
    public static final int DROP_MOST_RECENT_BUFFER = 2;
    public static final int DROP_OLDEST_BUFFER = 3;

    private SmartFlowJavaLibrary sfl;
    
    /** Creates a new instance of SmartFlow */
    public SmartFlow() {
        
        sfl = new SmartFlowJavaLibrary();
                
    }
    
    public void init (int argc, String argv[]) {

	sfl.sf_init(argc, argv);
    
    }

    public boolean ready_to_run() {
	
	return sfl.sf_ready_to_run();

    }

    public boolean connectToApplicationServer() {
	
	return sfl.sf_connect_to_application_server();

    }
    
    public boolean connectToApplicationServer(String clientname) {
        
        return sfl.sf_connect_to_application_server(clientname);
        
    }
    
    public boolean connectToApplicationServer(String clientname, String clientgroup) {
        
        return sfl.sf_connect_to_application_server(clientname, clientgroup);
        
    }

    public Flow makeOutputFlow(String flow_type, String name, String args, String group) {
	
	int flowId = sfl.sf_makeOutputFlow(flow_type, name, args, group);

        if (flowId == -1)
            return null;
        else 
            return (new Flow(sfl,flowId));
	/*if (flow_type == "Flow_BlockTest")
            return (new Flow_BlockTest(sfl, flowId));
	else if (flow_type == "Flow_Audio_Array")
            return (new Flow_Audio_Array(sfl, flowId));
        else if (flow_type == "Flow_Ant_Simulation")
            return (new Flow_Ant_Simulation(sfl, flowId));
	else
            return (new Flow_BlockTest(sfl, flowId));*/
    }
    
    public Flow makeSynchronizedOutputFlow(String flow_type, String name, int numberOfConsumersExpected, String args, String group) {
        
        int flowId = sfl.sf_makeSynchronizedOutputFlow(flow_type, name, numberOfConsumersExpected, args, group);

        if (flowId == -1)
            return null;
        else 
            return (new Flow(sfl,flowId));
        
	/*if (flow_type == "Flow_BlockTest")
            return (new Flow_BlockTest(sfl, flowId));
	else if (flow_type == "Flow_Audio_Array")
            return (new Flow_Audio_Array(sfl, flowId));
        else if (flow_type == "Flow_Ant_Simulation")
            return (new Flow_Ant_Simulation(sfl, flowId));
	else
            return (new Flow_BlockTest(sfl, flowId));*/
    }


    public Flow makeInputFlow(String flow_type, String name, String args, String group) {
	
	int flowId = sfl.sf_makeInputFlow(flow_type, name, args, group);
	
        if (flowId == -1)
            return null;
        else 
            return (new Flow(sfl,flowId));
        /*else if (flow_type == "Flow_BlockTest")
            return (new Flow_BlockTest(sfl, flowId));
	else if (flow_type == "Flow_Audio_Array")
            return (new Flow_Audio_Array(sfl, flowId));
        else if (flow_type == "Flow_Ant_Simulation")
            return (new Flow_Ant_Simulation(sfl, flowId));
	else
            return (new Flow_BlockTest(sfl, flowId));*/

    }
    
    public Flow makeInputFlow(String flow_type, String name, String args, String group, int flowControlPolicy) {
	
	int flowId = sfl.sf_makeInputFlow(flow_type, name, args, group, flowControlPolicy);
	
        if (flowId == -1)
            return null;
        else 
            return (new Flow(sfl,flowId));
       /* else if (flow_type == "Flow_BlockTest")
            return (new Flow_BlockTest(sfl, flowId));
	else if (flow_type == "Flow_Audio_Array")
            return (new Flow_Audio_Array(sfl, flowId));
        else if (flow_type == "Flow_Ant_Simulation")
            return (new Flow_Ant_Simulation(sfl, flowId));
	else
            return (new Flow_BlockTest(sfl, flowId));*/

    }
    
    public boolean startClient(String clientpath, String server) {
        return (sfl.sf_startClient(clientpath, server));
    }
    
    public boolean startClient(String clientpath, String server, String arguments) {
        return (sfl.sf_startClient(clientpath, server, arguments));
    }
    
    public boolean startClient(String clientpath, String server, String arguments, String parameters) {
        return (sfl.sf_startClient(clientpath, server, arguments, parameters));
    }

    public boolean stopClient(String clientname, String clientgroup) {
        return (sfl.sf_stopClient(clientname, clientgroup));
    }

    public String getApplicationDescription() {
        return (sfl.sf_getApplicationDescription());
    }

    public String getServerList() {
        return (sfl.sf_getServerList());
    }

    public String getLastModifications() {
        return (sfl.sf_getLastModifications());
    }

    public String strerror() {

	return sfl.sf_strerror();

    }

    public void destroy() {

	sfl.sf_destroy();

    }

    public void destroyFlow(Flow f) {

	sfl.sf_destroyFlow(f.getId());

    }
    
}
