/*
 * Flow.java
 *
 * Created on June 14, 2007, 1:05 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.nist.NDFS;

/**
 *
 * @author Stephane Degre
 */
public class Flow {

    protected SmartFlowJavaLibrary sfl;
    protected int flowId;
    protected String type;

    public Flow(SmartFlowJavaLibrary sfl, int flowId) {

	this.sfl = sfl;
	this.flowId = flowId;

    }

    public int getId() {

	return flowId;

    }

    public String get_FlowType() {

	//return type;
	return sfl.f_get_FlowType(flowId);

    }

    public boolean start() {

	return sfl.f_start(this.flowId);

    }

    public Buffer getBuffer() {

	 int bufferId = sfl.f_getBuffer(this.flowId);

	 return (new Buffer(sfl, bufferId));

    }

    public boolean releaseBuffer(Buffer buffer) {

	return sfl.f_releaseBuffer(this.flowId, buffer.getId());

    }

    public boolean cancelBuffer(Buffer buffer) {

	return sfl.f_cancelBuffer(this.flowId, buffer.getId());

    }
}
