/*
 * SmartFlowJavaLibrary.java
 *
 * Created on June 14, 2007, 12:32 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.nist.NDFS;

/**
 *
 * @author Stephane Degre
 */
public class SmartFlowJavaLibrary {
    
    static {System.loadLibrary("org_nist_NDFS_SmartFlowJavaLibrary");}
    
    /** Creates a new instance of SmartFlowJavaLibrary */
    public SmartFlowJavaLibrary() {
        this.sf_create();
    }
 
    // SmartFlow Methods

    public native void sf_create();
    public native void sf_destroy();

    public native void sf_init(int argc, String argv[]);
    public native void sf_init(int argc, String argv[], String application);

    //  native Flow makeInputFlow(String type, String name);
    //  native Flow makeInputFlow(String type, String name, String args);
    
    public native int sf_makeInputFlow(String type, String name, String args, String group);
    public native int sf_makeInputFlow(String type, String name, String args, String group, int flowControlPolicy);

    //  native Flow makeOutputFlow(String type, String name);
    //  native Flow makeOutputFlow(String type, String name, String args);
    
    public native int sf_makeOutputFlow(String type, String name, String args, String group);
    public native int sf_makeSynchronizedOutputFlow(String type, String name, int numberOfConsumersExpected, String args, String group);

    public native boolean sf_destroyFlow(int flow_id);
    
    // native int sf_makeMessage(String messagename);
	
    public native boolean sf_ready_to_run();

    public native boolean sf_stop();

    public native String sf_application_name();

    public native boolean sf_connect_to_application_server();
    public native boolean sf_connect_to_application_server(String clientname);
    public native boolean sf_connect_to_application_server(String clientname, String clientgroup);

    public native boolean sf_disconnect_from_application_server();

    public native boolean sf_startClient(String clientpath, String server);
    public native boolean sf_startClient(String clientpath, String server, String arguments);
    public native boolean sf_startClient(String clientpath, String server, String arguments, String parameters);

    public native boolean sf_stopClient(String clientname, String clientgroup);

    public native String sf_getApplicationDescription();

    public native String sf_getServerList();

    public native String sf_getLastModifications();
	
    //public native boolean sf_processCallBacks();

    //public native boolean sf_processCallBacks_One();

    public native void sf_set_error(long error);

    public native long sf_error();

    public native String  sf_strerror();

    // public native PreferenceManager getPreferenceManager();

    // public native FlowManager getFlowManager();
	
    // public native MessageManager getMessageManager();
	
    // public native MemoryManager getMemoryManager();
	
    // public native ConnectionManager getConnectionManager();
	
    // public native ErrorManager getErrorManager();


    // Flow Methods


    // native void f_destroy(int flow_id);

    public native boolean f_start(int flow_id);
    //public native int f_startFlow_BlockTest(int flow_id);
    //public native int f_startFlow_Audio_Array(int flow_id);
    //public native int f_startFlow_Ant_Simulation(int flow_id);
    
    // public native FlowManager get_manager();
 
    public native String f_get_FlowType(int flow_id);
    public native String f_get_FlowDesc(int flow_id);

    public native int f_get_mode(int flow_id);
    public native String f_get_name(int flow_id);
    public native String f_get_type(int flow_id);
    public native String f_get_args(int flow_id);
    public native long f_get_HistorySize(int flow_id);
    //public native int f_set_HistorySize(int flow_id, long size);
    //public native long f_get_MaxBufferSize(int flow_id);
    //public native int f_set_MaxBufferSize(int flow_id, long size);
    public native int f_getBuffer(int flow_id);
    //public native int f_getBufferFlow_BlockTest(int flow_id);
    //public native int f_getBufferFlow_Audio_Array(int flow_id);
    //public native int f_getBufferFlow_Ant_Simulation(int flow_id);

    public native boolean f_releaseBuffer(int flow_id, int buffer_id);
    //public native int f_releaseBufferFlow_BlockTest(int flow_id, int buffer_id);
    //public native int f_releaseBufferFlow_Audio_Array(int flow_id, int buffer_id);
    //public native int f_releaseBufferFlow_Ant_Simulation(int flow_id, int buffer_id);

    public native boolean f_cancelBuffer(int flow_id, int buffer_id);
    //public native int f_cancelBufferFlow_BlockTest(int flow_id, int buffer_id);
    //public native int f_cancelBufferFlow_Audio_Array(int flow_id, int buffer_id);
    //public native int f_cancelBufferFlow_Ant_Simulation(int flow_id, int buffer_id);



    // Buffers Methods

    //create
    //init
    //get_smartflow
    //get_manager
    //get_flow

    //public native byte[] data(int buffer_id); 

    //public native long b_get_maxsize(int buffer_id);
    //public native long b_get_size(int buffer_id);
    //public native int b_set_size(int buffer_id, long new_size);
    //public native int b_clear(int buffer_id);
    public native boolean b_init_buf(int buffer_id);
        
    //public native data_type_t get_next_data_type(int buffer_id);
    //public native buffer_size_t get_next_data_size(int buffer_id);
    //  struct timespec get_next_time_stamp() = 0;
        
    public native void b_goto_nextblock(int buffer_id); 
    
    public native void b_push_long(int buffer_id, long src);

    public native void b_push_data(int buffer_id, byte[] src);

    //public native boolean push_data_ts(void *src,buffer_size_t size, struct timespec *ts = 0) = 0;
	
    //virtual bool push_metadata(void *src,buffer_size_t size, data_type_t type = 0) = 0;

    public native long b_pop_long(int buffer_id);  

    public native byte[] b_pop_data(int buffer_id);

    //virtual bool pop_data(void *src,buffer_size_t size) = 0;
	
    //virtual bool pop_metadata(void *src,buffer_size_t size ) = 0;    
	
    //virtual bool pop_data_ts(void *src,buffer_size_t size, struct timespec *ts )  = 0 ; 
    
}
