import java.io.*;
import java.net.*;
import java.util.*;
import java.lang.*;
import java.text.*;


public class JArrayIIIfile {
    
    static private String ip_array;
    static private String speed;
    static private String file_name;

    static private String msg_received;
    static private DatagramSocket socket;
    static private InetAddress address;
    static private boolean pb_array = false;
    static private DatagramPacket packet;
    static private String ID_array;

    static private boolean running = true;
    
    public static void main(String[] args)  throws IOException {
        int cur_nb = -1;
        
        if (args.length < 4) {
             System.out.println("Usage: java Java_array_client_2 -d <IP Microphone Array (129.6.57.200)> -s < 1(Frequency 22050Hz) or 2 (Frequency 44100Hz) -f < file output name (optionnal)>");
             return;
        }
        for(int i=0; i< args.length; i=i+2)    {
            
            if (args[i].equals("-d") ){
                ip_array = args[i+1];
            } else if (args[i].equals("-s") ) {
                speed = args[i+1];
            } else if (args[i].equals("-f") ) {
                file_name = args[i+1];
            }else{
                System.out.println("Type de coordonne non reconnue");
                System.out.println("Usage: java Java_array_client_2 -d <IP Microphone Array (129.6.57.200)> -s < 1(Frequency 22050Hz) or 2 (Frequency 44100Hz) -f < file output name (optionnal)> ");
                return;
            }
        }
        
        ( new Thread(){
            public void run () {
                int i=0;
                try {
                    while ( i != -1 ) {
                        // Read a character from keyboard       
                        i  = System.in.read();
                        
                        switch (i) {
                        case 113:  //q
                            System.out.println( "Quit.");
                            running = false;
                            return;
                        case 81:  //Q
                            System.out.println( "Quit.");
                            running = false;
                            return;
                        default :
                            break;
                        }
                    }                    
                } catch (IOException ioe) {  
                    System.out.println( "IO error:" + ioe );
                }
            }
        }).start();
        
        address = InetAddress.getByName(ip_array);
        
        socket = new DatagramSocket(32767);
        socket.setSoTimeout(100);
        capture_off();
        //led_on();
        //led_off();
        if (speed.equals("2")){
            frequency_double_on();
        } else {
           frequency_double_off();
        }
	ask_id();
  
        if (file_name == null) {
            Calendar cal = Calendar.getInstance(); 
            SimpleDateFormat sdf = new SimpleDateFormat("HH-mm-ss");
            file_name = ID_array +"_"+ sdf.format(cal.getTime()) + ".ary";
        }
        File outputFile = new File(file_name);
        if (outputFile.isDirectory())
            outputFile = new File(outputFile, file_name + "#2");
        if (outputFile.exists()) {
            if (!outputFile.canWrite()) {
                System.out.println("destination file is unwriteable: " + file_name);
                return;
            }
            // Ask whether to overwrite it
            System.out.print("Overwrite existing file " + outputFile.getName());           
        }
        else {  
           String parent = outputFile.getParent();  // The destination directory
            if (parent == null)     // If none, use the current directory
		parent = System.getProperty("user.dir");
            File dir = new File(parent);          // Convert it to a file.
            if (!dir.exists()){
                System.out.println("destination directory doesn't exist: "+parent);
                 return;
            }
            if (dir.isFile()){
                System.out.println("destination is not a directory: " + parent);
                return;
            }
            if (!dir.canWrite()){
                System.out.println("destination directory is unwriteable: " + parent);
                return;
            }
        }

        FileOutputStream to = null;
        
        System.out.println("Microphone array IP: " + ip_array + " Name: " + ID_array + " Speed: " + speed + " Output file: " + file_name);
        System.out.println("Press q and enter to quit");        
        capture_on();
        pb_array = false; 
        to = new FileOutputStream(outputFile);
        while ( running ){
            byte[] buf = new byte[1024];
            packet = new DatagramPacket(buf, buf.length);           
            try {
                socket.receive(packet);
            } catch (IOException e) {
                System.out.println("Timeout on answer");
                if (pb_array) return;
                pb_array = true;
            }
            // display response
            if (!pb_array) {
                if ( buf[0] == (byte)0x86){
                    short nb = (short) (((buf[1]& 0xff)<<8)|(buf[2]& 0xff));
                    to.write(buf,4,960);
                    //System.out.println("|" + nb + "|" + cur_nb + "|");
                    if ( cur_nb != -1 && nb != cur_nb) {
                        System.out.println("Lost: " + cur_nb + " - " + ((nb-1) & 0x7FF));
                    }
                    cur_nb = (nb +1) & 0x7FF;
                }
            }    
        }
        
        //led_off();
        if (to != null) try { to.close();} catch (IOException e) {;}
        
        capture_off();
        frequency_double_off();
        socket.close();
    }

    public static void ask_id() throws IOException {
        boolean done = false;
        while ( !done ){
            byte[] buf = new byte[10];
            buf[0]=0;
            buf[1]=3;
            buf[2]=0;
            buf[3]=0;
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            // get response
            packet = new DatagramPacket(buf, buf.length);
            pb_array = false; 
            try {
                socket.receive(packet);
            } catch (IOException e) {
                System.out.println("Timeout on answer");
                pb_array = true;
            }
            // display response
            if (!pb_array) {
                msg_received = new String(packet.getData());
                if ( buf[0] == 3){
                    ID_array = Integer.toHexString(msg_received.charAt(3)) + Integer.toHexString(msg_received.charAt(2));
                    //System.out.println("Microphone Array ID: " + ID_array);
                    done = true;
                }
            }    
        }
    }
    
    public static void led_on() throws IOException {
        boolean done = false;
        while ( !done ){
            byte[] buf = new byte[10];
            buf[0]=0;
            buf[1]=1;
            
            buf[2]=(byte)0xff;
            buf[3]=(byte)0xff;
            
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            
            buf[0]=0;
            buf[1]=2;
            buf[2]=0;
            buf[3]=0;
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            // get response
            packet = new DatagramPacket(buf, buf.length);
            //Boolean pb_array0 = new Boolean;
            pb_array=false;
            try {
                socket.receive(packet);
            } catch (IOException e) {
                System.out.println("Timeout on answer");
                pb_array = true;
            }
            // display response
            if (!pb_array) {
                msg_received = new String(packet.getData());
                if ( buf[0] == 2 && buf[2] == 1){
                    done = true;
                }
            }    
        }
    }   

    public static void led_off() throws IOException {
        boolean done = false;
        while ( !done ){
            byte[] buf = new byte[10];
            buf[0]=0;
            buf[1]=1;
            
            buf[2]=0;
            buf[3]=0;
            
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            
            buf[0]=0;
            buf[1]=2;
            buf[2]=0;
            buf[3]=0;
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            // get response
            packet = new DatagramPacket(buf, buf.length);
            //Boolean pb_array0 = new Boolean;
            pb_array=false;
            try {
                socket.receive(packet);
            } catch (IOException e) {
                System.out.println("Timeout on answer");
                pb_array = true;
            }
            // display response
            if (!pb_array) {
                msg_received = new String(packet.getData());
                if ( buf[0] == 2 && buf[2] == 0){
                    done = true;
                }
            }    
        }
    }
    
    public static void capture_on() throws IOException {
        boolean done = false;
        while ( !done ){
            byte[] buf = new byte[10];
            buf[0]=0;
            buf[1]=4;
            
            buf[2]=(byte)0xff;
            buf[3]=(byte)0xff;
            
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            
            buf[0]=0;
            buf[1]=5;
            buf[2]=0;
            buf[3]=0;
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            // get response
            packet = new DatagramPacket(buf, buf.length);
            //Boolean pb_array0 = new Boolean;
            pb_array=false;
            try {
                socket.receive(packet);
            } catch (IOException e) {
                System.out.println("Timeout on answer");
                pb_array = true;
            }
            // display response
            if (!pb_array) {
                msg_received = new String(packet.getData());
                if ( buf[0] == 5 && buf[1] == 0 && buf[2] == 1){
                    done = true;
                }
            }    
        }
    }
    
    public static void capture_off() throws IOException {
        boolean done = false;
        while ( !done ){
            byte[] buf = new byte[10];
            buf[0]=0;
            buf[1]=4;
            
            buf[2]=0;
            buf[3]=0;
            
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            
            buf[0]=0;
            buf[1]=5;
            buf[2]=0;
            buf[3]=0;
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            // get response
            packet = new DatagramPacket(buf, buf.length);
            //Boolean pb_array0 = new Boolean;
            pb_array=false;
            try {
                socket.receive(packet);
            } catch (IOException e) {
                System.out.println("Timeout on answer");
                pb_array = true;
            }
            // display response
            if (!pb_array) {
                msg_received = new String(packet.getData());
                if ( buf[0] == 5 && buf[1] == 0 && buf[2] == 0){
                    done = true;
                }
            }    
        }
    }

    public static void frequency_double_on() throws IOException {
        boolean done = false;
        while ( !done ){
            byte[] buf = new byte[10];
            buf[0]=0;
            buf[1]=7;
            
            buf[2]=(byte)0xff;
            buf[3]=(byte)0xff;
            
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            
            buf[0]=0;
            buf[1]=8;
            buf[2]=0;
            buf[3]=0;
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            // get response
            packet = new DatagramPacket(buf, buf.length);
            //Boolean pb_array0 = new Boolean;
            pb_array=false;
            try {
                socket.receive(packet);
            } catch (IOException e) {
                System.out.println("Timeout on answer");
                pb_array = true;
            }
            // display response
            if (!pb_array) {
                msg_received = new String(packet.getData());
                if ( buf[0] == 7 && buf[1] == 0 && buf[2] == 1){
                    done = true;
                }
            }    
        }
    }

    public static void frequency_double_off() throws IOException {
        boolean done = false;
        while ( !done ){
            byte[] buf = new byte[10];
            buf[0]=0;
            buf[1]=7;
            
            buf[2]=0;
            buf[3]=0;
            
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            
            buf[0]=0;
            buf[1]=8;
            buf[2]=0;
            buf[3]=0;
            packet = new DatagramPacket(buf, buf.length, address, 32767);
            socket.send(packet);
            // get response
            packet = new DatagramPacket(buf, buf.length);
            //Boolean pb_array0 = new Boolean;
            pb_array=false;
            try {
                socket.receive(packet);
            } catch (IOException e) {
                System.out.println("Timeout on answer");
                pb_array = true;
            }
            // display response
            if (!pb_array) {
                msg_received = new String(packet.getData());
                if ( buf[0] == 7 && buf[1] == 0 && buf[2] == 0){
                    done = true;
                }
            }    
        }
    }   
}
