/*
* This software was developed at the National Institute of Standards and
* Technology (NIST) by employees of the Federal Government in the course
* of their official duties. Pursuant to title 17 Section 105 of the
* United States Code, this software is not subject to copyright protection
* and is in the public domain. NIST assumes no responsibility  whatsoever for
* its use by other parties, and makes no guarantees, expressed or implied,
* about its quality, reliability, or any other characteristic.
*/

#include <stdio.h>
#include <stdlib.h>

#define ERR_EXIT(...) \
   do { \
      fprintf(stderr, "ERROR: "); \
      fprintf(stderr, __VA_ARGS__); \
      fprintf(stderr, " (line %d in %s).\n", __LINE__, __FILE__); \
      exit(EXIT_FAILURE); \
   } while (0)


/*
 * Convert rectilinear image to polar format.
 */
void rectilinear_to_polar(const uint8_t *rect_raster, const unsigned int width, const unsigned int height,
                          uint8_t *polar_raster, const unsigned int num_circum_samples,
                          const unsigned int num_radial_samples,
                          const unsigned int polar_center_x, const unsigned int polar_center_y,
                          const unsigned int inner_radius, const unsigned int outer_radius);

/*
 * Convert polar image to rectilinear format.
 */
void polar_to_rectilinear(const uint8_t *polar_raster,
                          const unsigned int num_circum_samples, const unsigned int num_radial_samples,
                          uint8_t *rect_raster,
                          const unsigned int inner_radius, const unsigned int outer_radius);

