/*********************************************************************
	Rhapsody	: 7.1
	Login		: ysong_a
	Component	: DelayReqRespMaster
	Configuration 	: MasterClock
	Model Element	: MessageHeader
//!	Generated Date	: Mon, 28, Jul 2008 
	File Path	: DelayReqRespMaster/MasterClock/PTPMessages/MessageHeader.java
*********************************************************************/

package PTPMessages;

//## auto_generated
import java.util.*;
//## attribute domainNumber 
import PTPEntities.Domain;
//## auto_generated
import PTPDerivedDataTypes.*;
//## attribute messageType 
import PTPEnumTypes.MessageType;
//## auto_generated
import com.ilogix.rhapsody.oxf.*;
//## attribute flagField 
import PTPDerivedDataTypes.OctetArray;
//## attribute reserved1 
import PTPPrimitivityDataTypes.Nibble;
//## attribute sourcePortIdentity 
import PTPDerivedDataTypes.PortIdentity;
//## attribute logMessageInterval 
import PTPPrimitivityDataTypes.Integer8;
//## auto_generated
import com.ilogix.rhapsody.oxf.states.*;
//## attribute controlField 
import PTPPrimitivityDataTypes.UInteger8;
//## attribute versionPTP 
import PTPPrimitivityDataTypes.UInteger4;
//## attribute correctionField 
import PTPPrimitivityDataTypes.Integer64;
//## attribute reserved3 
import PTPPrimitivityDataTypes.UInteger32;
//## attribute messageLength 
import PTPPrimitivityDataTypes.UInteger16;
//## auto_generated
import com.ilogix.rhapsody.oxf.services.*;
//## auto_generated
import com.ilogix.rhapsody.oxf.timeouts.*;

//----------------------------------------------------------------------------
// PTPMessages/MessageHeader.java                                                                  
//----------------------------------------------------------------------------

//## package PTPMessages 


/**
Table 18: Common message header
Bits	Octets	Offset	
7	6	5	4	3	2	1	0			
transportSpecific	messageType	1	0	
reserved	versionPTP	1	1	
messageLength	2	2	
domainNumber	1	4	
reserved	1	5	
flagField	2	6	
correctionField	8	8	
reserved	4	16	
sourcePortIdentity	10	20	
sequenceId	2	30	
controlField	1	32	
logMessageInterval	1	33	
*/
//## class MessageHeader 
public class MessageHeader {
    
    protected UInteger8 controlField;		//## attribute controlField 
    
    protected Integer64 correctionField;		//## attribute correctionField 
    
    protected Domain domainNumber;		//## attribute domainNumber 
    
    /**
    Octet[2]
    */
    protected OctetArray flagField;		//## attribute flagField 
    
    protected Integer8 logMessageInterval;		//## attribute logMessageInterval 
    
    protected OctetArray messageHeaderOctetArray;		//## attribute messageHeaderOctetArray 
    
    protected UInteger16 messageLength;		//## attribute messageLength 
    
    protected MessageType messageType;		//## attribute messageType 
    
    protected Nibble reserved1;		//## attribute reserved1 
    
    protected UInteger8 reserved2;		//## attribute reserved2 
    
    protected UInteger32 reserved3;		//## attribute reserved3 
    
    protected UInteger16 sequenceId;		//## attribute sequenceId 
    
    protected static short sizeOfMsg = 34;		//## attribute sizeOfMsg 
    
    protected PortIdentity sourcePortIdentity;		//## attribute sourcePortIdentity 
    
    protected Nibble transportSpecific;		//## attribute transportSpecific 
    
    protected UInteger4 versionPTP;		//## attribute versionPTP 
    
    
    // Constructors
    
    //## operation MessageHeader() 
    public  MessageHeader() {
        //#[ operation MessageHeader() 
        //#]
    }
    //## operation MessageHeader(OctetArray) 
    public  MessageHeader(final OctetArray messageHeaderOctetArray) {
        //#[ operation MessageHeader(OctetArray) 
        this.messageHeaderOctetArray=messageHeaderOctetArray;
        
        //#]
    }
    
    /**
    Table 18: Common message header
    Bits	Octets	Offset	
    7	6	5	4	3	2	1	0			
    transportSpecific	messageType	1	0	
    reserved	versionPTP	1	1	
    messageLength	2	2	
    domainNumber	1	4	
    reserved	1	5	
    flags	2	6	
    correctionField	8	8	
    reserved	4	16	
    sourcePortIdentity	10	20	
    sequenceId	2	30	
    controlField	1	32	
    logMessageInterval	1	33	
    */
    //## operation GetMessageHeaderOctetArray() 
    public OctetArray GetMessageHeaderOctetArray() {
        //#[ operation GetMessageHeaderOctetArray() 
        
        byte[] messageHeaderByteArray ={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
        
        //this.messageHeaderOctetArray=new OctetArray((short)34); 
              
        
        //transportSpecific, messageType  
        byte byte0a = (byte)(this.getTransportSpecific().getNibbleVal()<<4);
        byte byte0b = (byte) this.getMessageType().GetMessageType()  ; 
        byte byte0= (byte) (byte0a|byte0b);  
        messageHeaderByteArray[0] = byte0; 
        //this.messageHeaderOctetArray.setOctets(0,byte0);
                                  
        // reserved1, versionPTP  
        byte byte1a = (byte) (this.getReserved1().getNibbleVal()<<4);
        byte byte1b = this.getVersionPTP().getUinteger4Val()  ;
        byte byte1 = (byte) (byte1a|byte1b);  
        messageHeaderByteArray[1] = byte1; 
        
        //this.messageHeaderOctetArray.setOctets(1,byte1);  
        
        
        // messageLength
        byte byte2=(byte)(0x00FF & this.getMessageLength().getUinteger16Val() ) ;
        messageHeaderByteArray[2] = byte2; 
        //this.messageHeaderOctetArray.setOctets(2,byte2);
         
        byte byte3=(byte)((this.getMessageLength().getUinteger16Val()& 0xFF00)>>8)  ;
        messageHeaderByteArray[3] = byte3; 
        //this.messageHeaderOctetArray.setOctets(3,byte3);
        
        
        //domainNumber 
        byte byte4= (byte) this.getDomainNumber().getDomain();   
        this.messageHeaderOctetArray.setOctets(4,byte4);
        
         // reserved2
        byte byte5= (byte)this.getReserved2().getUinteger8Val();   
        messageHeaderByteArray[5] = byte5; 
        //this.messageHeaderOctetArray.setOctets(5,byte5);
        
        
         //flags                    
        byte byte6= (byte)this.getFlagField().getOctets(0);   
        messageHeaderByteArray[6] = byte6; 
        //this.messageHeaderOctetArray.setOctets(6,byte6);
        byte byte7= (byte)this.getFlagField().getOctets(1);   
        messageHeaderByteArray[7] = byte7; 
        //this.messageHeaderOctetArray.setOctets(7,byte7);
        
        
        // correctionField
        byte byte8= (byte)(this.getCorrectionField().getInteger64Val()&0x00000000000000FF);   
        messageHeaderByteArray[8] = byte8; 
        //this.messageHeaderOctetArray.setOctets(8,byte8);    
        
        byte byte9= (byte)((this.getCorrectionField().getInteger64Val()>>8)&0x00000000000000FF);   
        messageHeaderByteArray[9] = byte9; 
        //this.messageHeaderOctetArray.setOctets(9,byte9);   
        
        byte byte10= (byte)((this.getCorrectionField().getInteger64Val()>>16)&0x00000000000000FF);     
        messageHeaderByteArray[10] = byte10; 
        //this.messageHeaderOctetArray.setOctets(10,byte10);   
        
        byte byte11= (byte)((this.getCorrectionField().getInteger64Val()>>24)&0x00000000000000FF);      
        messageHeaderByteArray[11] = byte11; 
        //this.messageHeaderOctetArray.setOctets(11,byte11);   
        
        byte byte12= (byte)((this.getCorrectionField().getInteger64Val()>>32)&0x00000000000000FF);     
        messageHeaderByteArray[12] = byte12; 
        //this.messageHeaderOctetArray.setOctets(12,byte12); 
        
        byte byte13= (byte)((this.getCorrectionField().getInteger64Val()>>40)&0x00000000000000FF);     
        messageHeaderByteArray[13] = byte13; 
        //this.messageHeaderOctetArray.setOctets(13,byte13); 
        
        byte byte14= (byte)((this.getCorrectionField().getInteger64Val()>>48)&0x00000000000000FF);     
        messageHeaderByteArray[14] = byte14; 
        //this.messageHeaderOctetArray.setOctets(14,byte14); 
        
        byte byte15= (byte)((this.getCorrectionField().getInteger64Val()>> 56)&0x00000000000000FF);      
        messageHeaderByteArray[15] = byte15; 
        //this.messageHeaderOctetArray.setOctets(15,byte15);
                                
                                
        //reserved3                        
        byte byte16= (byte)(this.getReserved3().getUinteger32Val()&0x000000FF);   
        messageHeaderByteArray[16] = byte16; 
        //this.messageHeaderOctetArray.setOctets(16,byte16);
        
        byte byte17= (byte)((this.getReserved3().getUinteger32Val()>>8)&0x000000FF) ; 
        messageHeaderByteArray[17] = byte17; 
        //this.messageHeaderOctetArray.setOctets(17,byte17);
        
        byte byte18= (byte)((this.getReserved3().getUinteger32Val()>>16)&0x000000FF) ;  
        messageHeaderByteArray[18] = byte18; 
        //this.messageHeaderOctetArray.setOctets(18,byte18);
        
        byte byte19= (byte)((this.getReserved3().getUinteger32Val()>>24)&0x000000FF) ;  
        messageHeaderByteArray[19] = byte19; 
        //this.messageHeaderOctetArray.setOctets(19,byte19);
        
        
        
        //sourcePortIdentity   (20-29)    
        //clockIdentity Octet[8]
        byte byte20= this.getSourcePortIdentity().getClockIdentity().getClockIdentity().getOctets(0);  
        messageHeaderByteArray[20] = byte20; 
        //this.messageHeaderOctetArray.setOctets(20,byte20);
        
        byte byte21= this.getSourcePortIdentity().getClockIdentity().getClockIdentity().getOctets(1);   
        messageHeaderByteArray[21] = byte21; 
        //this.messageHeaderOctetArray.setOctets(21,byte21);
        
        byte byte22= this.getSourcePortIdentity().getClockIdentity().getClockIdentity().getOctets(2);   
        messageHeaderByteArray[22] = byte22; 
        //this.messageHeaderOctetArray.setOctets(22,byte22);
        
        byte byte23= this.getSourcePortIdentity().getClockIdentity().getClockIdentity().getOctets(3);   
        messageHeaderByteArray[23] = byte23; 
        //this.messageHeaderOctetArray.setOctets(23,byte23);
        
        byte byte24= this.getSourcePortIdentity().getClockIdentity().getClockIdentity().getOctets(4);   
        messageHeaderByteArray[24] = byte24; 
        //this.messageHeaderOctetArray.setOctets(24,byte24);
        
        byte byte25= this.getSourcePortIdentity().getClockIdentity().getClockIdentity().getOctets(5);    
        messageHeaderByteArray[25] = byte25; 
        //this.messageHeaderOctetArray.setOctets(25,byte25);
        
        byte byte26= this.getSourcePortIdentity().getClockIdentity().getClockIdentity().getOctets(6);    
        messageHeaderByteArray[26] = byte26; 
        //this.messageHeaderOctetArray.setOctets(26,byte26);
        
        byte byte27= this.getSourcePortIdentity().getClockIdentity().getClockIdentity().getOctets(7);    
        messageHeaderByteArray[27] = byte27; 
        //this.messageHeaderOctetArray.setOctets(27,byte27);
        
        
        //portNumber    
        byte byte28= (byte)(this.getSourcePortIdentity().getPortNumber().getUinteger16Val()&0x00FF)  ;  
        messageHeaderByteArray[28] = byte28; 
        //this.messageHeaderOctetArray.setOctets(28,byte28);
        
        byte byte29= (byte)((this.getSourcePortIdentity().getPortNumber().getUinteger16Val()>>8)&0x00FF);    
        messageHeaderByteArray[29] = byte29; 
        //this.messageHeaderOctetArray.setOctets(29,byte29);
        
        // sequenceId     (30-31)
        byte byte30= (byte)(this.getSequenceId().getUinteger16Val()&0x00FF)  ;    
        messageHeaderByteArray[30] = byte30; 
        //this.messageHeaderOctetArray.setOctets(30,byte30);
        
        byte byte31= (byte)((this.getSequenceId().getUinteger16Val()>>8)&0x00FF) ;    
        messageHeaderByteArray[32] = byte31; 
        //this.messageHeaderOctetArray.setOctets(31,byte31);
        
        //controlField
        byte byte32= (byte)this.getControlField().getUinteger8Val() ;    
        messageHeaderByteArray[32] = byte32; 
        //this.messageHeaderOctetArray.setOctets(32,byte32);
        
        //logMessageInterval
        byte byte33= (byte)this.getLogMessageInterval().getInteger8Val() ;    
        messageHeaderByteArray[33] = byte33; 
        //this.messageHeaderOctetArray.setOctets(33,byte33);
           
        this.messageHeaderOctetArray=new OctetArray(messageHeaderByteArray); 
           
        return this.messageHeaderOctetArray ;
        
        
        
        //#]
    }
    
    //## operation PrintMessageHeader() 
    public void PrintMessageHeader() {
        //#[ operation PrintMessageHeader() 
        
        System.out.println("\nEnter Print message header.");
        System.out.println("transportSpecific:="+transportSpecific.getNibbleVal());
        System.out.println("messageType:="+messageType.getMessageType());
        //System.out.println("reserved1:="+reserved1);
        System.out.println("versionPTP:="+versionPTP.getUinteger4Val());
        System.out.println("messageLength:="+messageLength.getUinteger16Val());
        System.out.println("domainNumber:="+domainNumber.getDomain());
        //System.out.println("reserved2:="+reserved2);   
        
        
        System.out.println("flagField[0]:="+flagField.getOctets(0));  
        System.out.println("flagField[1]:="+flagField.getOctets(1));  
        
        
        System.out.println("correctionField:="+correctionField.getInteger64Val());
        
        //System.out.println("reserved3:="+reserved3);
        System.out.println("sourcePortIdentity[0]:="+sourcePortIdentity.getClockIdentity().getClockIdentity().getOctets(0)); 
        System.out.println("sourcePortIdentity[1]:="+sourcePortIdentity.getClockIdentity().getClockIdentity().getOctets(1)); 
        System.out.println("sourcePortIdentity[2]:="+sourcePortIdentity.getClockIdentity().getClockIdentity().getOctets(2)); 
        System.out.println("sourcePortIdentity[3]:="+sourcePortIdentity.getClockIdentity().getClockIdentity().getOctets(3)); 
        System.out.println("sourcePortIdentity[4]:="+sourcePortIdentity.getClockIdentity().getClockIdentity().getOctets(4)); 
        System.out.println("sourcePortIdentity[5]:="+sourcePortIdentity.getClockIdentity().getClockIdentity().getOctets(5)); 
        System.out.println("sourcePortIdentity[6]:="+sourcePortIdentity.getClockIdentity().getClockIdentity().getOctets(6)); 
        System.out.println("sourcePortIdentity[7]:="+sourcePortIdentity.getClockIdentity().getClockIdentity().getOctets(7)); 
        
        System.out.println("sourcePortIdentity:="+sourcePortIdentity.getPortNumber().getUinteger16Val()); 
        
        System.out.println("sequenceId:="+sequenceId.getUinteger16Val());
        System.out.println("controlField:="+controlField.getUinteger8Val());
        System.out.println("logMessageInterval:="+logMessageInterval.getInteger8Val());
        System.out.println("End Print message header.\n");
        //#]
    }
    
    //## operation SetMessageHeaderItems(OctetArray) 
    public void SetMessageHeaderItems(final OctetArray messageHeaderOctetArray) {
        //#[ operation SetMessageHeaderItems(OctetArray) 
        //this.messageHeader=new OctetArray((short)34); 
         this.messageHeaderOctetArray = messageHeaderOctetArray;
         
        //transportSpecific,  
        
        //this.messageHeader.octets[0]= (byte)((byte)(this.transportSpecific.nibbleVal<<4)|this.messageType.messageType)  ; 
        //messageType 
        byte messageTypeByte =(byte)(0x0F&this.messageHeaderOctetArray.getOctets(0));    
        MessageType messageType = new MessageType(messageTypeByte);
        this.setMessageType(messageType);                    
        
        byte transportSpecificByte=(byte)(0x0FL&(this.messageHeaderOctetArray.octets[0]>>4));     
        Nibble transportSpecific= new Nibble((byte)transportSpecificByte);
        this.setTransportSpecific(transportSpecific);  
        
                    
        
        // reserved1, versionPTP              
        //this.messageHeader.octets[1]=(byte)((byte)(this.reserved1.nibbleVal<<4)|this.versionPTP.uinteger4Val)  ;  
        byte versionPTPByte= (byte)(0x0F&(this.messageHeaderOctetArray.octets[1]));  
        UInteger4 versionPTP   = new UInteger4((byte)versionPTPByte);
        this.setVersionPTP(versionPTP); 
        
        byte reserved1Byte =(byte)(0x0F&(this.messageHeaderOctetArray.octets[1]>>4));
        Nibble reserved1 = new Nibble((byte)reserved1Byte);
        this.setReserved1(reserved1); 
        
        
        
        // messageLength
        //this.messageHeader.octets[2]= (byte)this.messageLength.uinteger16Val ;  
        //this.messageHeader.octets[3]= (byte)((byte)this.messageLength.uinteger16Val>>8) ; 
        short messageLengthByte1 = (short) (0x00FF&(this.messageHeaderOctetArray.octets[2]));
        short messageLengthByte2 = (short) (0xFF00&(this.messageHeaderOctetArray.octets[3]<<8));   
        short messageLengthBytes= (short)(messageLengthByte1|messageLengthByte2);  
        UInteger16 messageLength = new UInteger16((short)messageLengthBytes);
        this.setMessageLength(messageLength);  
         
        //domainNumber 
        //this.messageHeader.octets[4]= this.domainNumber.domain ; 
        byte domainNumberByte = (byte)(0x0F&this.messageHeaderOctetArray.octets[4])   ;
        Domain domainNumber = new Domain((byte)domainNumberByte) ;
        this.setDomainNumber(domainNumber);   
        
         // reserved2
        //this.messageHeader.octets[5]= (byte)this.reserved2.uinteger8Val  ; 
        byte reserved2Byte= (byte)this.messageHeaderOctetArray.octets[5]  ;
        UInteger8  reserved2 = new UInteger8(reserved2Byte);
        this.setReserved2(reserved2);
                            
         //flags                    
        //this.messageHeader.octets[6]= this.flags.octets[0] ;   
        //this.messageHeader.octets[7]=this.flags.octets[1]  ;    
        OctetArray flagField = new OctetArray((short)2);    
        
        flagField.octets[0]=this.messageHeaderOctetArray.octets[6];
        flagField.octets[1]=this.messageHeaderOctetArray.octets[7];
        this.setFlagField(flagField);
        
        
        // correctionField
        //this.messageHeader.octets[8]= (byte)(this.correctionField.integer64Val&0x00000000000000FF) ;     
        //this.messageHeader.octets[9]= (byte)((this.correctionField.integer64Val>>8)&0x00000000000000FF) ;     
        //this.messageHeader.octets[10]=(byte)((this.correctionField.integer64Val>>8)&0x00000000000000FF)  ;     
        //this.messageHeader.octets[11]=(byte)((this.correctionField.integer64Val>>8)&0x00000000000000FF)  ;     
        //this.messageHeader.octets[12]=(byte)((this.correctionField.integer64Val>>8)&0x00000000000000FF)  ;     
        //this.messageHeader.octets[13]=(byte)((this.correctionField.integer64Val>>8)&0x00000000000000FF)  ;     
        //this.messageHeader.octets[14]=(byte)((this.correctionField.integer64Val>>8)&0x00000000000000FF)  ;     
        //this.messageHeader.octets[15]=(byte)((this.correctionField.integer64Val>>8)&0x00000000000000FF)  ;  
        long fieldByte0 = (long)(0x00000000000000FFL&this.messageHeaderOctetArray.octets[8]);
        long fieldByte1 = (long)(0x000000000000FF00L&this.messageHeaderOctetArray.octets[9]<<8);    
        long filedByte2 = (long)(0x0000000000FF0000L&this.messageHeaderOctetArray.octets[10]<<16); 
        long filedByte3 = (long)(0x00000000FF000000L&this.messageHeaderOctetArray.octets[11]<<24); 
        long filedByte4 = (long)(0x000000FF00000000L&this.messageHeaderOctetArray.octets[12]<<32); 
        long filedByte5 = (long)(0x0000FF0000000000L&this.messageHeaderOctetArray.octets[13]<<40); 
        long filedByte6 = (long)(0x00FF000000000000L&this.messageHeaderOctetArray.octets[14]<<48); 
        long filedByte7 = (long)(0xFF00000000000000L&this.messageHeaderOctetArray.octets[15]<<56);   
        long correctionFieldBytes=(long)(fieldByte0|fieldByte1|filedByte2|filedByte3|filedByte4|filedByte5|filedByte6|filedByte7) ;  
        Integer64 correctionField = new Integer64((long)correctionFieldBytes);
        this.setCorrectionField(correctionField);  
                           
                                
        //reserved3                        
        //this.messageHeader.octets[16]=(byte)(this.reserved3.uinteger32Val&0x000000FF)  ;
        //this.messageHeader.octets[17]=(byte)((this.reserved3.uinteger32Val>>8)&0x000000FF)  ;
        //this.messageHeader.octets[18]=(byte)((this.reserved3.uinteger32Val>>8)&0x000000FF)  ;
        //this.messageHeader.octets[19]=(byte)((this.reserved3.uinteger32Val>>8)&0x000000FF)  ;
        
        int reserved3Byte0=  (int)(0x000000FF&this.messageHeaderOctetArray.octets[16]);
        int reserved3Byte1=  (int)(0x0000FF00&this.messageHeaderOctetArray.octets[17]<<8);
        int reserved3Byte2=  (int)(0x00FF0000&this.messageHeaderOctetArray.octets[18]<<16);
        int reserved3Byte3=  (int)(0xFF000000&this.messageHeaderOctetArray.octets[19]<<24);  
        int reserved3Bytes=  (int)(reserved3Byte0|reserved3Byte1|reserved3Byte2|reserved3Byte3)   ;  
        UInteger32 reserved3 = new UInteger32((int)reserved3Bytes);
        this.setReserved3(reserved3);  
        
        
        //sourcePortIdentity   (20-29)    
        //clockIdentity Octet[8]
        //this.messageHeader.octets[20]=this.sourcePortIdentity.clockIdentity.clockIdentity.octets[0]  ;      
        //this.messageHeader.octets[21]=this.sourcePortIdentity.clockIdentity.clockIdentity.octets[1]  ;      
        //this.messageHeader.octets[22]=this.sourcePortIdentity.clockIdentity.clockIdentity.octets[2]  ;      
        //this.messageHeader.octets[23]=this.sourcePortIdentity.clockIdentity.clockIdentity.octets[3]  ;      
        //this.messageHeader.octets[24]=this.sourcePortIdentity.clockIdentity.clockIdentity.octets[4]  ;      
        //this.messageHeader.octets[25]=this.sourcePortIdentity.clockIdentity.clockIdentity.octets[5]  ;      
        //this.messageHeader.octets[26]=this.sourcePortIdentity.clockIdentity.clockIdentity.octets[6]  ;      
        //this.messageHeader.octets[27]=this.sourcePortIdentity.clockIdentity.clockIdentity.octets[7]  ;  
         
        OctetArray oa = new OctetArray((short)8); 
        oa.octets[0]=this.messageHeaderOctetArray.octets[20];
        oa.octets[1]=this.messageHeaderOctetArray.octets[21];
        oa.octets[2]=this.messageHeaderOctetArray.octets[22];
        oa.octets[3]=this.messageHeaderOctetArray.octets[23];
        oa.octets[4]=this.messageHeaderOctetArray.octets[24];
        oa.octets[5]=this.messageHeaderOctetArray.octets[25];
        oa.octets[6]=this.messageHeaderOctetArray.octets[26];
        oa.octets[7]=this.messageHeaderOctetArray.octets[27];   
        
        ClockIdentity clockIdentity = new ClockIdentity(oa);
         
        //portNumber    
        //this.messageHeader.octets[28]=(byte)(this.sourcePortIdentity.portNumber.uinteger16Val&0x00FF)  ;      
        //this.messageHeader.octets[29]=(byte)((this.sourcePortIdentity.portNumber.uinteger16Val>>8)&0x00FF)  ; 
        
        short portNoByte1 = (short) (0x00FF|this.messageHeaderOctetArray.octets[28]);
        short portNoByte2 = (short) (0xFF00|(this.messageHeaderOctetArray.octets[29]<<8));  
        short portNo= (short)(portNoByte2|portNoByte1);   
        UInteger16 portNumber =new UInteger16((short)portNo);   
        
        PortIdentity portIdentity = new PortIdentity(clockIdentity,portNumber);
        
        this.setSourcePortIdentity(portIdentity)  ;
                               
                                
        // sequenceId     (30-31)
        //this.messageHeader.octets[30]=(byte)(this.sequenceId.uinteger16Val&0x00FF)   ;   
        //this.messageHeader.octets[31]=(byte)((this.sequenceId.uinteger16Val>>8)&0x00FF)   ;   
        
        short sequencIdByte1= (short)(0x00FF|this.messageHeaderOctetArray.octets[30]);
        short sequencIdByte2= (short)(0xFF00|(this.messageHeaderOctetArray.octets[31]<<8));
        short sequenceIdBytes= (short)(sequencIdByte1|sequencIdByte2);
        UInteger16 sequenceId= new UInteger16((short)sequenceIdBytes);
        this.setSequenceId(sequenceId); 
                                          
        
        //controlField
        //this.messageHeader.octets[32]=(byte)this.controlField.uinteger8Val  ;    
        byte controlFieldByte = (byte)this.messageHeaderOctetArray.octets[32] ;
        UInteger8  controlField = new UInteger8((byte)controlFieldByte);
        this.setControlField(controlField); 
        
        //logMessageInterval
        //this.messageHeader.octets[33]=(byte)this.logMessageInterval.integer8Val  ;   
        byte logMessageIntervalByte=(byte)this.messageHeaderOctetArray.octets[33] ;   
        Integer8 logMessageInterval =new Integer8(logMessageIntervalByte);
        this.setLogMessageInterval(logMessageInterval); 
        
        //#]
    }
    
    //## auto_generated 
    public UInteger8 getControlField() {
        return controlField;
    }
    
    //## auto_generated 
    public void setControlField(UInteger8 p_controlField) {
        controlField = p_controlField;
    }
    
    //## auto_generated 
    public Integer64 getCorrectionField() {
        return correctionField;
    }
    
    //## auto_generated 
    public void setCorrectionField(Integer64 p_correctionField) {
        correctionField = p_correctionField;
    }
    
    //## auto_generated 
    public Domain getDomainNumber() {
        return domainNumber;
    }
    
    //## auto_generated 
    public void setDomainNumber(Domain p_domainNumber) {
        domainNumber = p_domainNumber;
    }
    
    /**
    Octet[2]
    */
    //## auto_generated 
    public OctetArray getFlagField() {
        return flagField;
    }
    
    //## auto_generated 
    public void setFlagField(OctetArray p_flagField) {
        flagField = p_flagField;
    }
    
    //## auto_generated 
    public Integer8 getLogMessageInterval() {
        return logMessageInterval;
    }
    
    //## auto_generated 
    public void setLogMessageInterval(Integer8 p_logMessageInterval) {
        logMessageInterval = p_logMessageInterval;
    }
    
    //## auto_generated 
    public OctetArray getMessageHeaderOctetArray() {
        return messageHeaderOctetArray;
    }
    
    //## auto_generated 
    public void setMessageHeaderOctetArray(OctetArray p_messageHeaderOctetArray) {
        messageHeaderOctetArray = p_messageHeaderOctetArray;
    }
    
    //## auto_generated 
    public UInteger16 getMessageLength() {
        return messageLength;
    }
    
    //## auto_generated 
    public void setMessageLength(UInteger16 p_messageLength) {
        messageLength = p_messageLength;
    }
    
    //## auto_generated 
    public MessageType getMessageType() {
        return messageType;
    }
    
    //## auto_generated 
    public void setMessageType(MessageType p_messageType) {
        messageType = p_messageType;
    }
    
    //## auto_generated 
    public Nibble getReserved1() {
        return reserved1;
    }
    
    //## auto_generated 
    public void setReserved1(Nibble p_reserved1) {
        reserved1 = p_reserved1;
    }
    
    //## auto_generated 
    public UInteger8 getReserved2() {
        return reserved2;
    }
    
    //## auto_generated 
    public void setReserved2(UInteger8 p_reserved2) {
        reserved2 = p_reserved2;
    }
    
    //## auto_generated 
    public UInteger32 getReserved3() {
        return reserved3;
    }
    
    //## auto_generated 
    public void setReserved3(UInteger32 p_reserved3) {
        reserved3 = p_reserved3;
    }
    
    //## auto_generated 
    public UInteger16 getSequenceId() {
        return sequenceId;
    }
    
    //## auto_generated 
    public void setSequenceId(UInteger16 p_sequenceId) {
        sequenceId = p_sequenceId;
    }
    
    //## auto_generated 
    public static short getSizeOfMsg() {
        return sizeOfMsg;
    }
    
    //## auto_generated 
    public static void setSizeOfMsg(short p_sizeOfMsg) {
        sizeOfMsg = p_sizeOfMsg;
    }
    
    //## auto_generated 
    public PortIdentity getSourcePortIdentity() {
        return sourcePortIdentity;
    }
    
    //## auto_generated 
    public void setSourcePortIdentity(PortIdentity p_sourcePortIdentity) {
        sourcePortIdentity = p_sourcePortIdentity;
    }
    
    //## auto_generated 
    public Nibble getTransportSpecific() {
        return transportSpecific;
    }
    
    //## auto_generated 
    public void setTransportSpecific(Nibble p_transportSpecific) {
        transportSpecific = p_transportSpecific;
    }
    
    //## auto_generated 
    public UInteger4 getVersionPTP() {
        return versionPTP;
    }
    
    //## auto_generated 
    public void setVersionPTP(UInteger4 p_versionPTP) {
        versionPTP = p_versionPTP;
    }
    
}
/*********************************************************************
	File Path	: DelayReqRespMaster/MasterClock/PTPMessages/MessageHeader.java
*********************************************************************/

