package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.BITS16;
import gov.nist.div897.Asn1Lib.INTEGER;

public class MetricAccess extends BITS16 {
	static final private String m_String_NameAsn1Type="MetricAccess";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTEGER("","0"),"avail-intermittent"),
		new Identifier(new INTEGER("","1"),"upd-periodic"),
		new Identifier(new INTEGER("","2"),"upd-episodic"),
		new Identifier(new INTEGER("","3"),"msmt-noncontinuous"),
		new Identifier(new INTEGER("","4"),"acc-evrep"),
		new Identifier(new INTEGER("","5"),"acc-get"),
		new Identifier(new INTEGER("","6"),"acc-scan"),
		new Identifier(new INTEGER("","8"),"gen-opt-sync"),
		new Identifier(new INTEGER("","10"),"sc-opt-normal"),
		new Identifier(new INTEGER("","11"),"sc-opt-extensive"),
		new Identifier(new INTEGER("","12"),"sc-opt-long-pd-avail"),
		new Identifier(new INTEGER("","13"),"sc-opt-confirm"),
		new Identifier(new INTEGER("","14"),"sc-opt-refresh"),
	};
	public MetricAccess(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));	
}
	public MetricAccess(String a_name){
		 this();
		 setNameInstance(a_name);
	}
	public MetricAccess(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public MetricAccess(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public MetricAccess(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
