package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.BITS16;
import gov.nist.div897.Asn1Lib.INTEGER;

public class BatteryStatus extends BITS16 {
	static final private String m_String_NameAsn1Type="BatteryStatus";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTEGER("","0"),"batt-discharged"),
		new Identifier(new INTEGER("","1"),"batt-full"),
		new Identifier(new INTEGER("","2"),"batt-discharging"),
		new Identifier(new INTEGER("","8"),"batt-chargingFull"),
		new Identifier(new INTEGER("","9"),"batt-chargingTrickle"),
		new Identifier(new INTEGER("","12"),"batt-malfunction"),
		new Identifier(new INTEGER("","13"),"batt-needs-conditioning"),
	};
	public BatteryStatus(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));	
}
	public BatteryStatus(String a_name){
		 this();
		 setNameInstance(a_name);
	}
	public BatteryStatus(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public BatteryStatus(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public BatteryStatus(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
