package dataTypeInterface;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

import com.sun.java.swing.plaf.windows.WindowsTreeUI.CollapsedIcon;

public class CollapsablePanel extends JPanel implements ActionListener{
	private JPanel headerPan = null;
	private JPanel collapsablePan = null;
	private JButton btnCollapse;
	private JPanel bottomPnl;
	static Icon imIconPlus = CollapsedIcon.createCollapsedIcon();
	static Icon imIconMinus = CollapsedIcon.createExpandedIcon();
	private boolean isExpanded = true;
	
	public CollapsablePanel(){
		super();
		initializeComponents();
	}
	
	private void initializeComponents(){
		
		setLayout(new BorderLayout());
		headerPan = new JPanel();
		headerPan.setLayout(new BorderLayout());
		
		bottomPnl = new JPanel();
		bottomPnl.setLayout(new BorderLayout());
				
		JPanel panelTemp = new JPanel();
		JPanel panelTemp2 = new JPanel();
		panelTemp2.setLayout(new BoxLayout(panelTemp2, BoxLayout.LINE_AXIS));
		panelTemp2.add(Box.createRigidArea(new Dimension(10,0)));
		panelTemp2.add(panelTemp);
		panelTemp.setBorder(BorderFactory.createMatteBorder(0,1,1,0, Color.GRAY));
		bottomPnl.add(panelTemp2, BorderLayout.WEST);
		
		
		btnCollapse = new JButton();
		btnCollapse.addActionListener(this);
		btnCollapse.setIcon(imIconMinus);
		btnCollapse.setPreferredSize(new Dimension(10,10));	
		
		JPanel p = new JPanel();
		p.add(btnCollapse);
		headerPan.add(p, BorderLayout.WEST);
		//headerPan.add(Box.createRigidArea(new Dimension(10,10)));
		add(headerPan, BorderLayout.PAGE_START);
		add(bottomPnl, BorderLayout.CENTER);
	}
	public JPanel getCollapsablePan() {
		return collapsablePan;
	}

	public void setCollapsablePan(JPanel collapsablePan) {
		if(collapsablePan != null){
			bottomPnl.remove(collapsablePan);
		}
		this.collapsablePan = collapsablePan;
		
		bottomPnl.add(collapsablePan, BorderLayout.CENTER);
	}

	public JPanel getHeaderPan() {
		return headerPan;
	}

	public void setHeaderPan(JPanel headerPanIn) {
		if(headerPan != null && headerPanIn != null)
			headerPan.remove(headerPanIn);
		headerPan.add(headerPanIn, BorderLayout.CENTER);
	}
	
	protected static ImageIcon createImageIcon(String path) {
	    java.net.URL imgURL = Button.class.getResource(path);
	    return new ImageIcon(imgURL);
	}
	
	public void collapse(){
		if(isExpanded){
			btnCollapse.setIcon(imIconPlus);
			bottomPnl.remove(collapsablePan);
			isExpanded = false;
			updateUI();
		}
	}
	public void expand(){
		if(!isExpanded){
			btnCollapse.setIcon(imIconMinus);
			bottomPnl.add(collapsablePan, BorderLayout.CENTER);
			isExpanded = true;
			updateUI();
		}
	}

	public void actionPerformed(ActionEvent arg0) {
		if(arg0.getSource() == btnCollapse){
			if(isExpanded){
				collapse();
			}
			else{
				expand();
			}
			
		}
		
	}
	
}
