package addingsToAsnLib;

import java.util.Random;
import java.util.Set;

import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1ILib.Choices;
import gov.nist.div897.Asn1Lib.ANY;
import gov.nist.div897.Asn1Lib.BITSTRING;
import gov.nist.div897.Asn1Lib.CHOICE;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Asn1Lib.OCTETSTRING;
import gov.nist.div897.Asn1Lib.SEQUENCE;
import gov.nist.div897.Asn1Lib.SEQUENCEOF;


public class RandomValuesServer {
	static Random random;
	
	static public void setRandom(){
		random = new Random();
	}

	static public void setRandomValue(Asn1Object asnObj){
		if (asnObj instanceof SEQUENCE) {
			SEQUENCE sequence = (SEQUENCE) asnObj;
			setRandomValue(sequence);
		}
		if (asnObj instanceof SEQUENCEOF) {
			SEQUENCEOF sequenceof = (SEQUENCEOF) asnObj;
			setRandomValue(sequenceof);
		}
		if (asnObj instanceof INTEGER) {
			INTEGER integer = (INTEGER) asnObj;
			setRandomValue(integer);
		}
		if (asnObj instanceof BITSTRING) {
			BITSTRING bitString = (BITSTRING) asnObj;
			setRandomValue(bitString);
		}
		if (asnObj instanceof OCTETSTRING) {
			OCTETSTRING octetString = (OCTETSTRING) asnObj;
			setRandomValue(octetString);
		}
		if (asnObj instanceof CHOICE) {
			CHOICE choice = (CHOICE) asnObj;
			setRandomValue(choice);
		}
		if (asnObj instanceof ANY) {
			ANY any = (ANY) asnObj;
			setRandomValue(any);
			
		}
	}

	private static void setRandomValue(ANY any) {
		if(any.getANYArguments() != null){
			Set<Asn1Object> keySet = any.getANYArguments().keySet();
			if(keySet.size() != 0){
				int index = random.nextInt(keySet.size());
				any.setANYOption(((Asn1Object)keySet.toArray()[index]));
				Asn1Object asnObj = any.getANYAsn1Object();
				setRandomValue(asnObj);
			}
		}
	}

	private static void setRandomValue(CHOICE choice) {
		Choices choices = choice.getChoices();
		if(choices != null){
			Set<Asn1Object> keySet = choices.keySet();
			if(keySet.size() != 0){
				int index = random.nextInt(keySet.size());
				Asn1Object asnObj = choice.MakeChoice(((Asn1Object)keySet.toArray()[index]).getData());
				setRandomValue(asnObj);
			}
		}
	}

	private static void setRandomValue(OCTETSTRING octetString) {
		byte[] bytes = new byte[2];
		random.nextBytes(bytes);
		octetString.setData(bytes);
		
	}

	private static void setRandomValue(BITSTRING bitString) {
		byte[] bytes = new byte[bitString.getFixedDataSize()];
		random.nextBytes(bytes);
		bitString.setData(bytes);
		
	}

	private static void setRandomValue(INTEGER integer) {
		byte[] bytes = new byte[integer.getFixedDataSize()];
		random.nextBytes(bytes);
		integer.setData(bytes);
		
	}

	private static void setRandomValue(SEQUENCEOF sequenceof) {
		int nbSequenceOf = random.nextInt(10);
		for(int i = 0; i < nbSequenceOf; i++){
			Asn1Object asnObj = sequenceof.instantiateNextSequenceOfAsn1Object();
			setRandomValue(asnObj);
		}
		
	}

	private static void setRandomValue(SEQUENCE sequence) {
		for( int i = 0; i < sequence.getSequenceCount(); i++){
			Asn1Object asnObj = sequence.getSequenceObject(i);
			setRandomValue(asnObj);
		}	
		
	}
}
