package pdfReport;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * This class represents the dialog for selecting the ICS tables to include in the PDF report 
 * @author MC
 *
 */
public class ReportPropertiesSelectionDialog extends JDialog implements ActionListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	JCheckBox generalIcsBtn;
	JCheckBox serviceIcsBtn;
	JCheckBox umlDiagramBtn;
	JCheckBox dimMocIcsBtn;
	JCheckBox attrMocIcsBtn;
	JCheckBox notiMocIcsBtn;
	JCheckBox behavMocIcsBtn;
	JCheckBox transportIcsBtn;
	
	JButton okBtn;
	JButton cancelBtn;
	boolean isOKPressed = false;
	
	boolean[] isSelected = new boolean[8];
	
	public ReportPropertiesSelectionDialog(JFrame frame, boolean[] isDisable){
		super(frame, "Export PDF Report Options", true);
		initializeComponents();
		setDisableButtons(isDisable);
	}

	private void initializeComponents(){
		setLayout(new BorderLayout());
		setResizable(false);
		
		JPanel p1 = new JPanel();
		GridLayout layout = new GridLayout(0,1);
		p1.setLayout(layout);
		p1.setBorder(BorderFactory.createTitledBorder(""));
		
		
		umlDiagramBtn = new JCheckBox("Include the UML Diagram in the report.");
		generalIcsBtn = new JCheckBox("Include the General ICS table in the report.");
		serviceIcsBtn = new JCheckBox("Include Service ICS table in the report.");
		dimMocIcsBtn = new JCheckBox("Include DIM MOC ICS table in the report.");
		attrMocIcsBtn = new JCheckBox("Include MOC Attributes ICS table in the report.");
		notiMocIcsBtn = new JCheckBox("Include MOC Notifications ICS table in the report.");
		behavMocIcsBtn = new JCheckBox("Include MOC Behaviors ICS table in the report.");
		transportIcsBtn = new JCheckBox("Include Transport ICS tables in the report.");
		
		umlDiagramBtn.setMargin(new Insets(2,20,0,0));
		generalIcsBtn.setMargin(new Insets(2,20,0,0));
		serviceIcsBtn.setMargin(new Insets(2,20,0,0));
		dimMocIcsBtn.setMargin(new Insets(2,20,0,0));
		attrMocIcsBtn.setMargin(new Insets(2,20,0,0));
		notiMocIcsBtn.setMargin(new Insets(2,20,0,0));
		behavMocIcsBtn.setMargin(new Insets(2,20,0,0));
		transportIcsBtn.setMargin(new Insets(2,20,0,0));
		
		umlDiagramBtn.addActionListener(this);
		generalIcsBtn.addActionListener(this);
		serviceIcsBtn.addActionListener(this);
		dimMocIcsBtn.addActionListener(this);
		attrMocIcsBtn.addActionListener(this);
		notiMocIcsBtn.addActionListener(this);
		behavMocIcsBtn.addActionListener(this);
		transportIcsBtn.addActionListener(this);
		
		p1.add(umlDiagramBtn);
		p1.add(generalIcsBtn);
		p1.add(serviceIcsBtn);
		p1.add(dimMocIcsBtn);
		p1.add(attrMocIcsBtn);
		p1.add(attrMocIcsBtn);
		p1.add(behavMocIcsBtn);
		p1.add(notiMocIcsBtn);
		p1.add(transportIcsBtn);
		
		JPanel p2 = new JPanel();
		p2.setLayout(new BorderLayout());
		
		okBtn = new JButton("OK");
		okBtn.addActionListener(this);
		cancelBtn = new JButton("Cancel");
		cancelBtn.addActionListener(this);
		
		
		p2.setBorder(BorderFactory.createEmptyBorder(20,20,20,20));
		p2.add(okBtn, BorderLayout.WEST);
		p2.add(cancelBtn, BorderLayout.EAST);
		
		add(p1, BorderLayout.CENTER);
		add(p2, BorderLayout.SOUTH);
	}

	public void actionPerformed(ActionEvent e) {
		int sel = -1;
		boolean val = false;
		if(e.getSource() == umlDiagramBtn){
			sel = 0;
			if(umlDiagramBtn.isSelected())
				val = true;
			else
				val = false;
		}
		else if(e.getSource() == generalIcsBtn){
			sel = 1;
			if(generalIcsBtn.isSelected())
				val = true;
			else
				val = false;
		}
		else if(e.getSource() == serviceIcsBtn){
			sel = 2;
			if(serviceIcsBtn.isSelected())
				val = true;
			else
				val = false;			
		}
		else if(e.getSource() == dimMocIcsBtn){
			sel = 3;
			if(dimMocIcsBtn.isSelected())
				val = true;
			else
				val = false;
		}
		else if(e.getSource() == attrMocIcsBtn){
			sel = 4;
			if(attrMocIcsBtn.isSelected())
				val = true;
			else
				val = false;
		}
		else if(e.getSource() == notiMocIcsBtn){
			sel = 5;
			if(notiMocIcsBtn.isSelected())
				val = true;
			else
				val = false;
		}
		else if(e.getSource() == behavMocIcsBtn){
			sel = 6;
			if(behavMocIcsBtn.isSelected())
				val = true;
			else
				val = false;
		}
		else if(e.getSource() == transportIcsBtn){
			sel = 7;
			if(transportIcsBtn.isSelected())
				val = true;
			else
				val = false;
		}
		if(sel != -1){
			isSelected[sel] = val;
		}
		else if(e.getSource() == okBtn){
			isOKPressed = true;
			setVisible(false);
		}
		else if(e.getSource() == cancelBtn){
			setVisible(false);
		}
	}
	public void setDisableButtons(boolean[] isDisable){
		if(isDisable != null && isDisable.length == 5){
			if(!isDisable[0])
				umlDiagramBtn.setEnabled(false);
			if(!isDisable[1])
				generalIcsBtn.setEnabled(false);
			if(!isDisable[2])
				serviceIcsBtn.setEnabled(false);
			if(!isDisable[3]){
				dimMocIcsBtn.setEnabled(false);
				attrMocIcsBtn.setEnabled(false);
				behavMocIcsBtn.setEnabled(false);
				notiMocIcsBtn.setEnabled(false);
			}
			if(!isDisable[4])
				transportIcsBtn.setEnabled(false);			
		}
		for(int i = 0; i < isSelected.length; i++)
			isSelected[i] = false;
	}
	public void init(){
		umlDiagramBtn.setSelected(false);
		generalIcsBtn.setSelected(false);
		serviceIcsBtn.setSelected(false);
		dimMocIcsBtn.setSelected(false);
		attrMocIcsBtn.setSelected(false);
		behavMocIcsBtn.setSelected(false);
		notiMocIcsBtn.setSelected(false);
		transportIcsBtn.setSelected(false);
		isOKPressed = false;
		
		umlDiagramBtn.setEnabled(true);
		generalIcsBtn.setEnabled(true);
		serviceIcsBtn.setEnabled(true);
		dimMocIcsBtn.setEnabled(true);
		attrMocIcsBtn.setEnabled(true);
		behavMocIcsBtn.setEnabled(true);
		transportIcsBtn.setEnabled(true);
		notiMocIcsBtn.setEnabled(true);
	}
	public boolean isOkBtnPressed(){
		return isOKPressed;
	}
	public boolean[] getSelection(){
		return isSelected;
	}
}
