
package icsTables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

/**
 * ErrorDialog
 * It's the dialog that presents the errors ina JTable components to the user
 * @author MC
 */
public class ErrorDialog extends JDialog{
    private static final long serialVersionUID = 1L;
	private JTable jTable;
    private javax.swing.JScrollPane jScrollPane1;
    private JPanel jPanel;
    private JButton jBtnOK;
    private JComponent parent;
	
    
	public ErrorDialog(JComponent parentIn, String Message, Vector Error)
	{
		super(new JFrame(), "Problems", true);
		parent = parentIn;
		jTable = new JTable(new myDataModel(Error, Message));
		jTable.setDefaultRenderer(String.class, new myCellRenderer());
		initComponents();
		JOptionPane joptionPane = new JOptionPane();
		joptionPane.setMessageType(JOptionPane.ERROR_MESSAGE);
		jTable.getColumnModel().getColumn(1).setPreferredWidth(getTableWidth(Error));
		jTable.getColumnModel().getColumn(0).setPreferredWidth(20);
		jTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		((DefaultTableCellRenderer)jTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(SwingConstants.LEFT);
		setLocationRelativeTo(parent);
		
		
	}
	/**
	 * calculate the width of the Jtable
	 * @param vect	 contains the rows
	 * @return int
	 */
	private int getTableWidth(Vector vect)
	{
		int width = 560;
		FontMetrics metrics = getFontMetrics(new Font(null));
	    int widthStr;
		for(int i = 0; i < vect.size(); i++)
			if((widthStr = metrics.stringWidth(vect.get(i).toString())) > width)
				width = widthStr;
		return width;
		
	}
	/**
	 * initialize the dialog components
	 *
	 */
	private void initComponents() 
	{
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel = new JPanel();
        jScrollPane1 = new javax.swing.JScrollPane(jTable);
        jBtnOK = new JButton("OK");
        jBtnOK.addActionListener(new ActionListener(){

			public void actionPerformed(ActionEvent arg0) {
				dispose();				
			}});
        
        jBtnOK.setBackground(new Color(204, 204, 255));
        getContentPane().setLayout(new java.awt.GridBagLayout());

        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jScrollPane1, gridBagConstraints);


        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        getContentPane().add(jPanel, gridBagConstraints);
        
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        gridBagConstraints.insets = new Insets(5,5,5,5);
        jPanel.add(jBtnOK, gridBagConstraints);

        setSize(new Dimension(600, 300));
    }
	 
    
    /**
     * this class describes the dataModel that will be used bu tje JTable
     * @author maria
     *
     */
    private class myDataModel extends AbstractTableModel
    {
        private static final long serialVersionUID = 1L;
    	Vector data;
    	String title;
    	public myDataModel(Vector dataIn, String titleIn)
    	{
    		title = titleIn;
    		data = dataIn;
    	}
		public int getColumnCount() {
			return 2;
		}
		public String getColumnName(int col)
		{
			if(col == 1)
				return title;
			else
				return "";
		}
		public int getRowCount() {
			return data.size();
		}

		public Object getValueAt(int arg0, int arg1) {
			if(arg1 == 1)
				return data.get(arg0);
			else
				return "";
		}
		public Class<?> getColumnClass(int c) {
	        return getValueAt(0, c).getClass();
	    }
    	
    }
    /**
     * this class describes the Cellrenderer user for the JTable
     * @author maria
     *
     */
    private class myCellRenderer extends DefaultTableCellRenderer implements TableCellRenderer{
        private static final long serialVersionUID = 1L;
        public myCellRenderer()
        {
            super();
            setVerticalAlignment(JLabel.NORTH);
        }
        /**
         * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
         */
        public Component getTableCellRendererComponent(JTable table,Object value,boolean isSelected,boolean hasFocus,int row,int col){
            Component c = super.getTableCellRendererComponent( table, value,isSelected,hasFocus,row,col);
             //on grise une ligne sur 2 par soucis de visibilit
            if(col == 0)
            {
            	JButton btn = new JButton();
            	btn.setIcon(new javax.swing.ImageIcon("C:\\Documents and Settings\\maria\\My Documents\\My Pictures\\error_obj.gif"));
            	btn.setBackground(Color.WHITE);
            	btn.setBorder(BorderFactory.createEmptyBorder());
            	c = btn; 
            }
            return c; 
        }
    }

}
