package icsDyn;

import gov.nist.div897.Asn1ILib.Asn1Object;
import icsTables.ErrorDialog;

import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.SAXParseException;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

import addingsToAsnLib.ParseXmlDataType;


import java.io.File;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.FileReader;

import java.util.Observable;

import java.util.Vector;
import java.util.Enumeration;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/**
 * This class allows creating a device containment tree from the device XML file
 * @author Rick Rivello
 *
 */
public class ICSModel extends Observable { 
	  
	   private DefaultMutableTreeNode defaultVecTree, curVecTree, vecTreeNode;
	    
	   public Vector<MOCNode> vMOC;
           public Vector<MOCNode> curvMOC;
           public Document doc, doc1, defaultDocument;

	   private AttributeNode curAttribute;
	   private BehaviourNode curBehaviour;
	   private NotificationNode curNotification;

	   private MOCNode curMOC, curMOC1;
	  
       public static MOCNode selectedMOCNode;

	   private int curIndex=0;
           private int mocIdNumber=1;

	   String mdsType;
           String icsToLoad;
           String loadmode;
       
         boolean setEnable;
	   
	   /**
	    * Fire an event
	    * @param arg An MVCArg object
	    */
	   public void fireEvent(MVCArg arg) {

		setChanged();
		notifyObservers(arg);
	}

	public void setGenerateEnable(boolean isEnable) {
		setEnable = isEnable;
		setChanged();
		notifyObservers(new MVCArg("isEnable", setEnable));
	}

	public void setMDS(String mds) {
		mdsType = mds;
		setChanged();
		notifyObservers(new MVCArg("mdsType", mdsType));
	}

	public void setICS(String ics) {

		icsToLoad = ics;

		setChanged();
		notifyObservers(new MVCArg("icsToLoad", icsToLoad));
	}

	/**
	 * Get the structure
	 * 
	 * @return The structure
	 */
	public String getMDS() {
		return mdsType;
	}

	public String getICS() {
		return icsToLoad;
	}

	public void setMode(String mode) {
		loadmode = mode;
		setChanged();
		notifyObservers(new MVCArg("loadmode", loadmode));
	}

	public String getMode() {

		return loadmode;
	}

	public void setMOCNode(MOCNode mn) {
		selectedMOCNode = mn;
		setChanged();
		notifyObservers(new MVCArg("selectedMOCNode", selectedMOCNode));
	}

	public DefaultMutableTreeNode getMainTree(String MDSType)
			throws SAXException, IOException, ParserConfigurationException {

		DefaultMutableTreeNode treeNode = null;
		Element mdsNode, mdsNode1;
		vMOC = new Vector<MOCNode>(); 
        curvMOC = new Vector<MOCNode>();

		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setValidating(true);
		factory.setNamespaceAware(true);

		factory.setAttribute(
				"http://java.sun.com/xml/jaxp/properties/schemaLanguage",
				"http://www.w3.org/2001/XMLSchema");
		factory
				.setAttribute(
						"http://java.sun.com/xml/jaxp/properties/schemaSource",

						new File("../xsd/dimNew.xsd").getCanonicalPath());

		DocumentBuilder builder = factory.newDocumentBuilder();
		Validator handler = new Validator();
		builder.setErrorHandler(handler);
		Vector<String> schemaErrVector = new Vector<String>();
		schemaErrVector = handler.Error;
		doc = builder.parse(new File(getICS()));

		if (defaultVecTree == null && !(new File(getICS())).getCanonicalPath().equals(
				new File("../xml/ICS-Tool.xml").getCanonicalPath())) {
			Transformer transformer = null;
			StreamSource source = null;
			StreamResult result = null;
			TransformerFactory tFactory = TransformerFactory.newInstance();

			try {
				transformer = tFactory.newTransformer(new StreamSource(
						new File("../XSLT/validate_DIMSCHTRN.xsl")));
				source = new StreamSource(new File(getICS()));
				result = new StreamResult(new File("../src/err.dat"));
				transformer.transform(source, result);
			} catch (TransformerConfigurationException e) {
				e.printStackTrace();
			} catch (TransformerException e) {
				e.printStackTrace();
			}
			BufferedReader bufferederrfile = new BufferedReader(new FileReader(
					"../src/err.dat"));

			String line;
			while ((line = bufferederrfile.readLine()) != null) {
				schemaErrVector.add(line);
			}
			bufferederrfile.close();
		}
		if (schemaErrVector.size() > 0) {
			ErrorDialog schemaerror = new ErrorDialog(null, "MDS",
					schemaErrVector);
			schemaerror.setVisible(true);
		}

		Element dimRoot = doc.getDocumentElement();

		mdsNode1 = processDefaultDocument(MDSType, doc);

		mdsNode = dimRoot;

		MOCNode rootMoc = new MOCNode();
		rootMoc.setObjectName(dimRoot.getNodeName());
		mocIdNumber = mocIdNumber + 1;

		vMOC.add(rootMoc);

		treeNode = processXML(mdsNode, false);

		if (getMode().equals("New")) {
			defaultVecTree = createVecTree(treeNode, vMOC);
			mocIdNumber = 1;
			DefaultMutableTreeNode cTree = createDynamicXML(dimRoot, mdsNode1);
			curIndex = 0;
			curVecTree = createVecTree(cTree, curvMOC);
			defaultDocument = doc;
		} else {
			Vector<MOCNode> OvMOC = new Vector<MOCNode>(vMOC);
			curvMOC = OvMOC;
			curVecTree = createVecTree(treeNode, curvMOC);
			doc1 = builder.parse(new File("../xml/ICS-Tool.xml"));
			mdsNode = processDefaultDocument(MDSType, doc1);
			vMOC.clear();
			vMOC.add(rootMoc);
			int tempmocIdNumber = mocIdNumber;
			dimRoot = doc1.getDocumentElement();
			treeNode = processXML(dimRoot, false);
			mocIdNumber = tempmocIdNumber;
			curIndex = 0;
			defaultVecTree = createVecTree(treeNode, vMOC);
			defaultDocument = doc1;
		}
		return curVecTree;
	}

	 public class Validator extends DefaultHandler {
         public boolean validationError = false;
         public Vector<String> Error;
         public SAXParseException saxParseException = null; 
         public Validator()
         {
       	  Error = new Vector<String>();
         }
         public void error(SAXParseException exception) throws SAXException {
            validationError = true;
            saxParseException = exception;
            Error.add(exception.getMessage());
            System.out.println(exception);
         }     
         public void fatalError(SAXParseException exception) throws SAXException {
            validationError = true;	    
            saxParseException=exception;	
            Error.add(exception.getMessage());
            System.out.println(exception);     
         }		    
         public void warning(SAXParseException exception)throws SAXException {
            System.out.println(exception); 
         }	
      }

	private Element processDefaultDocument(String MDSType, Document document) {
		Element mdsNode = null;
		Node TopMDSNode = null;

		Element dimroot = document.getDocumentElement();

		NodeList dimChildren = dimroot.getChildNodes();

		for (int x = 0; x < dimChildren.getLength(); x++) {
			TopMDSNode = dimChildren.item(x);
			if (TopMDSNode.getNodeType() == Node.ELEMENT_NODE) {
				if (dimChildren.item(x).getNodeName().equals(
						"Composite_Single_Bed_MDS")
						|| dimChildren.item(x).getNodeName().equals(
								"Simple_MDS")
						|| dimChildren.item(x).getNodeName()
								.equals("Hydra_MDS")) {
					mdsNode = (Element) TopMDSNode;
					break;
				}
			}
		}
		if (MDSType.equals("Hydra")) {
			mdsNode = document.createElement("Hydra_MDS");
			while (TopMDSNode.hasChildNodes()) {
				mdsNode.appendChild(TopMDSNode.getFirstChild());
			}
			TopMDSNode.getParentNode().replaceChild(mdsNode, TopMDSNode);
			NodeList mdsChildren = mdsNode.getChildNodes();
			for (int x = 0; x < mdsChildren.getLength(); x++) {
				if (mdsChildren.item(x).getNodeName().equals("OBJECT_NAME")) {
					Text objname = (Text) mdsChildren.item(x).getFirstChild();
					objname.setData("Hydra_MDS");
				} else if (mdsChildren.item(x).getNodeName()
						.equals("OBJECT_ID")) {
					Text objid = (Text) mdsChildren.item(x).getFirstChild();
					objid.setData("MDC_MOC_VMS_MDS_HYD");
				} else if (mdsChildren.item(x).getNodeName()
						.equals("TERM_CODE")) {
					Text termcode = (Text) mdsChildren.item(x).getFirstChild();
					termcode.setData("36");
				} else if (mdsChildren.item(x).getNodeName()
						.equals("Reference")) {
					Text ref = (Text) mdsChildren.item(x).getFirstChild();
					ref.setData("clause 7.5.4");
				}
			}
		} else if (MDSType.equals("Simple")) {
			mdsNode = document.createElement("Simple_MDS");
			while (TopMDSNode.hasChildNodes()) {
				mdsNode.appendChild(TopMDSNode.getFirstChild());
			}
			TopMDSNode.getParentNode().replaceChild(mdsNode, TopMDSNode);
			NodeList mdsChildren = mdsNode.getChildNodes();
			for (int x = 0; x < mdsChildren.getLength(); x++) {
				if (mdsChildren.item(x).getNodeName().equals("OBJECT_NAME")) {
					Text objname = (Text) mdsChildren.item(x).getFirstChild();
					objname.setData("Simple_MDS");
				} else if (mdsChildren.item(x).getNodeName()
						.equals("OBJECT_ID")) {
					Text objid = (Text) mdsChildren.item(x).getFirstChild();
					objid.setData("MDC_MOC_VMS_MDS_SIMP");
				} else if (mdsChildren.item(x).getNodeName()
						.equals("TERM_CODE")) {
					Text termcode = (Text) mdsChildren.item(x).getFirstChild();
					termcode.setData("37");
				} else if (mdsChildren.item(x).getNodeName()
						.equals("Reference")) {
					Text ref = (Text) mdsChildren.item(x).getFirstChild();
					ref.setData("clause 7.5.3");
				}
			}
		}
		return mdsNode;
	}

	 public DefaultMutableTreeNode createVecTree (DefaultMutableTreeNode treeNd, Vector VECVmoc) {

	      Enumeration treeEnum = treeNd.preorderEnumeration();
	      DefaultMutableTreeNode tNode = (DefaultMutableTreeNode) treeEnum.nextElement();                         
	      vecTreeNode = createVecTreeRelationship(tNode,VECVmoc); 
	      return vecTreeNode;
     }

	private DefaultMutableTreeNode createVecTreeRelationship(
			DefaultMutableTreeNode rNode, Vector VECVmoc) {

		DefaultMutableTreeNode vecTreeNode1 = null;

		MOCNode tmpMoc = new MOCNode();
		tmpMoc.setObjectName(rNode.toString());
		int index = VECVmoc.indexOf(tmpMoc, curIndex);
		curIndex = index + 1;
		MOCNode mocNode = (MOCNode) VECVmoc.get(index);
		vecTreeNode1 = new DefaultMutableTreeNode(new MOCNode(mocNode));

		if (!rNode.isLeaf()) {
			Enumeration chldrn = rNode.children();
			while (chldrn.hasMoreElements()) {
				DefaultMutableTreeNode tnd = (DefaultMutableTreeNode) chldrn
						.nextElement();
				vecTreeNode1.add(createVecTreeRelationship(tnd, VECVmoc));
			}
		}
		return vecTreeNode1;
	}

	private DefaultMutableTreeNode addToVecTreeRelationship(
			DefaultMutableTreeNode rNode) {

		MOCNode curMOC1;
		DefaultMutableTreeNode vecTreeNode = null;

		MOCNode tmpMoc = new MOCNode();
		tmpMoc.setObjectName(rNode.toString());
		int index = vMOC.indexOf(tmpMoc, curIndex);
		curIndex = index + 1;

		curMOC1 = new MOCNode();
		MOCNode mocNode = (MOCNode) vMOC.get(index);

		curMOC1.setObjectName(mocNode.getObjectName());
		curMOC1.setObjectNameLabel("");
		curMOC1.setMocIdNumber(mocIdNumber);
		mocIdNumber = mocIdNumber + 1;
		curMOC1.setObjectId(mocNode.getObjectId());
		curMOC1.setMocTermCode(mocNode.getMocTermCode());
		curMOC1.setReference(mocNode.getReference());
		curMOC1.setMocRestrictions(null);
		curMOC1.setMocApplicationGuidance(null);
		curMOC1.setMocServicesSupported(null);
		curMOC1.setMocComment(null);

		Vector attributes = mocNode.getAttribute();

		for (int attrcnt = 0; attrcnt < attributes.size(); attrcnt++) {
			String qual = ((DIMMOC) attributes.get(attrcnt)).getAttributeQual();
			if (qual.equals("M") || qual.equals("n/a")) {
				AttributeNode newAttr = new AttributeNode();
				newAttr.setAttributeName(((DIMMOC) attributes.get(attrcnt))
						.getAttributeName());
				newAttr
						.setAttributeKeyNumber(((DIMMOC) attributes
								.get(attrcnt)).getAttributeKeyNumber());
				newAttr
						.setAttributeGroupName(((DIMMOC) attributes
								.get(attrcnt)).getAttributeGroupName());
				newAttr.setAttributeGroupId(((DIMMOC) attributes.get(attrcnt))
						.getAttributeGroupId());
				newAttr.setAttributeGroupTermCode(((DIMMOC) attributes
						.get(attrcnt)).getAttributeGroupTermCode());
				newAttr.setAttributeDerivedFrom(((DIMMOC) attributes
						.get(attrcnt)).getAttributeDerivedFrom());
				newAttr.setAttributeId(((DIMMOC) attributes.get(attrcnt))
						.getAttributeId());
				newAttr.setAttributeType(((DIMMOC) attributes.get(attrcnt))
						.getAttributeType());
				newAttr.setAttributeTermCode(((DIMMOC) attributes.get(attrcnt))
						.getAttributeTermCode());
				newAttr
						.setAttributeReference(((DIMMOC) attributes
								.get(attrcnt)).getAttributeReference());
				newAttr.setAttributeQual(qual);
				newAttr.setAttributeStatus("");
				newAttr.setAttributeAccess("");
				newAttr.setAttributeValueRange("");
				newAttr.setAttributeApplicationGuidance("");
				newAttr.setAttributeRestrictions("");
				newAttr.setAttributeComment("");
		
//				newAttr.setAttributeSampleValue(Asn1ModuleServer.cloneAsn1Object((((AttributeNode) attributes.get(attrcnt))
//						.getAttributeSampleValue())));
				curMOC1.addAttribute(newAttr);
			}
		}

		Vector behaviors = mocNode.getBehaviour();

		for (int behavcnt = 0; behavcnt < behaviors.size(); behavcnt++) {
			
			BehaviourNode newBehav = new BehaviourNode();
			newBehav.setMethodName(((DIMMOC) behaviors.get(behavcnt))
					.getMethodName());
			newBehav.setMethodId(((DIMMOC) behaviors.get(behavcnt))
					.getMethodId());
			newBehav.setBehaviourKeyNumber(((DIMMOC) behaviors.get(behavcnt))
					.getBehaviourKeyNumber());
			newBehav.setBehaviourActionParameter(((DIMMOC) behaviors
					.get(behavcnt)).getBehaviourActionParameter());
			newBehav
					.setBehaviourActionResult(((DIMMOC) behaviors.get(behavcnt))
							.getBehaviourActionResult());
			newBehav.setBehaviourTermCode(((DIMMOC) behaviors.get(behavcnt))
					.getBehaviourTermCode());
			newBehav.setBehaviourReference(((DIMMOC) behaviors.get(behavcnt))
					.getBehaviourReference());
			newBehav.setBehaviourQual(((DIMMOC) behaviors.get(behavcnt))
					.getBehaviourQual());
			newBehav.setBehaviourRestrictions("");
			newBehav.setBehaviourComment("");
			curMOC1.addBehaviour(newBehav);
		}

		Vector notifications = mocNode.getNotification();

		for (int noticnt = 0; noticnt < notifications.size(); noticnt++) {
			
			NotificationNode newNoti = new NotificationNode();
			newNoti.setNotificationName(((DIMMOC) notifications.get(noticnt))
					.getNotificationName());
			newNoti.setNotificationId(((DIMMOC) notifications.get(noticnt))
					.getNotificationId());
			newNoti.setNotificationKeyNumber(((DIMMOC) notifications
					.get(noticnt)).getNotificationKeyNumber());
			newNoti.setNotificationTermCode(((DIMMOC) notifications
					.get(noticnt)).getNotificationTermCode());
			newNoti.setNotificationReference(((DIMMOC) notifications
					.get(noticnt)).getNotificationReference());
			newNoti.setNotificationQual(((DIMMOC) notifications.get(noticnt))
					.getNotificationQual());
			newNoti.setNotificationEventParameter(((DIMMOC) notifications
					.get(noticnt)).getNotificationEventParameter());
			newNoti.setNotificationRestrictions("");
			newNoti.setNotificationComment("");
			curMOC1.addNotification(newNoti);
		}

		curvMOC.add(curMOC1);
		vecTreeNode = new DefaultMutableTreeNode(new MOCNode(curMOC1));

		/*
		 * if (!rNode.isLeaf()) { Enumeration chldrn = rNode.children(); while (
		 * chldrn.hasMoreElements()) { DefaultMutableTreeNode tnd =
		 * (DefaultMutableTreeNode) chldrn.nextElement();
		 * vecTreeNode.add(addToVecTreeRelationship(tnd)); } }
		 */
		return vecTreeNode;
	}

	private DefaultMutableTreeNode processXML(Node root, boolean isMocPrivateIn) {

		DefaultMutableTreeNode treeNode = null;

		String name, value;

		name = root.getNodeName();
		value = root.getNodeValue();
		boolean isMOCPrivate = isMocPrivateIn;

		treeNode = new DefaultMutableTreeNode(
				root.getNodeType() == Node.TEXT_NODE ? value : name);

		if (root.hasChildNodes()) {

			NodeList children;

			int numChildren;
			Node node;
			
			children = root.getChildNodes();
			if (children != null) {
				numChildren = children.getLength();
				curMOC = new MOCNode();
				for (int j = 0; j < numChildren; j++) {
					node = children.item(j);
					if (node != null) {
						if (node.getNodeType() == Node.ELEMENT_NODE) {
							if (node.getNodeName().equals("Private-MOC")) {
								isMOCPrivate = true;
								treeNode.add(processXML(node, isMOCPrivate));
							} else if (node.getNodeName().equals("OBJECT_NAME")) {
								curMOC.setObjectName(node.getFirstChild()
										.getNodeValue());
								curMOC.setMocIdNumber(mocIdNumber);
								mocIdNumber = mocIdNumber + 1;
								Element elnode = (Element) node;
								curMOC.setObjectNameLabel(elnode
										.getAttribute("Label"));
								curMOC.isPrivate = isMOCPrivate;
								if (isMOCPrivate)
									treeNode.setUserObject(curMOC.object_name);
								isMOCPrivate = false;
							} else if (node.getNodeName().equals("OBJECT_ID")) {
								curMOC.setObjectId(node.getFirstChild()
										.getNodeValue());
							} else if (node.getNodeName().equals("MOC_TYPE_ID")) {
								if (node.getFirstChild() == null) {
									curMOC.setTypeID("");
								} else
									curMOC.setTypeID(node.getFirstChild()
											.getNodeValue());
							} else if (node.getNodeName().equals(
									"MOC_TYPE_TERM_CODE")) {
								if (node.getFirstChild() == null) {
									curMOC.setTypeIDTermCode("");
								} else
									curMOC.setTypeIDTermCode(node
											.getFirstChild().getNodeValue());
							} else if (node.getNodeName().equals("TERM_CODE")) {
								curMOC.setMocTermCode(node.getFirstChild()
										.getNodeValue());
							} else if (node.getNodeName().equals("Reference")) {
								if (node.getFirstChild() == null
										|| node.getFirstChild().getNodeValue() == "") {
									curMOC.setReference("");
									curMOC.isPrivate = true;
								} else {
									curMOC.setReference(node.getFirstChild()
											.getNodeValue());
									curMOC.isPrivate = false;
								}
							} else if (node.getNodeName().equals(
									"MOC_RESTRICTIONS")) {
								if (node.getFirstChild() == null) {
									curMOC.setMocRestrictions("");
								} else {
									curMOC.setMocRestrictions(node
											.getFirstChild().getNodeValue());
								}
							} else if (node.getNodeName().equals(
									"MOC_APPLICATION_GUIDANCE")) {
								if (node.getFirstChild() == null) {
									curMOC.setMocApplicationGuidance("");
								} else {
									curMOC.setMocApplicationGuidance(node
											.getFirstChild().getNodeValue());
								}
							} else if (node.getNodeName().equals(
									"MOC_SERVICES_SUPPORTED")) {
								if (node.getFirstChild() == null) {
									curMOC.setMocServicesSupported(null);
								} else {
									curMOC.setMocServicesSupported(node
											.getFirstChild().getNodeValue());
								}
							} else if (node.getNodeName().equals("MOC_COMMENT")) {
								if (node.getFirstChild() == null) {
									curMOC.setMocComment("");
								} else {
									curMOC.setMocComment(node.getFirstChild()
											.getNodeValue());
								}
								vMOC.add(curMOC);
							} else if (node.getNodeName().equals(
									"Attribute_Info")) {
								NodeList attrAChildren = node.getChildNodes();
								int attrKeyNumber = 0;
								for (int a = 0; a < attrAChildren.getLength(); a++) {

									NodeList attrChildren = attrAChildren.item(
											a).getChildNodes();
									if (attrAChildren.item(a) != null) {
										if (attrAChildren.item(a).getNodeType() == Node.ELEMENT_NODE
												&& attrAChildren
														.item(a)
														.getNodeName()
														.equals(
																"Private-Attributes")) {
											NodeList attrPrivChildren = attrAChildren
													.item(a).getChildNodes();
											for (int ap = 0; ap < attrPrivChildren
													.getLength(); ap++) {
												if (attrPrivChildren.item(ap)
														.getNodeType() == Node.ELEMENT_NODE) {
													curAttribute = new AttributeNode();
													// Element attrElement =
													// (Element)
													// attrPrivChildren.item(ap);
													// curAttribute.setAttributeGroupName(attrElement.getAttribute("attrGrpName"));
													// curAttribute.setAttributeGroupId(attrElement.getAttribute("attrGrpId"));
													// curAttribute.setAttributeGroupTermCode(attrElement.getAttribute("attrGrpTermCode"));
													// curAttribute.setAttributeDerivedFrom(attrElement.getAttribute("derivedFrom"));
													// curAttribute.setAttributeKeyNumber(attrKeyNumber);
													// attrKeyNumber =
													// attrKeyNumber + 1;
													NodeList attrPChildren = attrPrivChildren
															.item(ap)
															.getChildNodes();
													for (int k = 0; k < attrPChildren
															.getLength(); k++) {
														if (attrPChildren
																.item(k)
																.getFirstChild() != null) {
															if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"ATTRIBUTE_NAME")) {
																System.out
																		.println(attrPChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
																curAttribute
																		.setAttributeName(attrPChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"ATTRIBUTE_ID")) {
																curAttribute
																		.setAttributeId(attrPChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"ATTRIBUTE_TYPE")) {
																if (attrPChildren
																		.item(k)
																		.getFirstChild() != null)
																	curAttribute
																			.setAttributeType(attrPChildren
																					.item(
																							k)
																					.getFirstChild()
																					.getNodeValue());
//																if(curAttribute.getAttributeType() != "")
//																	curAttribute
//																	.createAsnObj();
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"TERM_CODE")) {
																curAttribute
																		.setAttributeTermCode(attrPChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"Reference")) {
																if (attrPChildren
																		.item(k)
																		.getFirstChild() != null)
																	curAttribute
																			.setAttributeReference(attrPChildren
																					.item(
																							k)
																					.getFirstChild()
																					.getNodeValue());
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"Qual")) {
																curAttribute
																		.setAttributeQual(attrPChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"ATTRIBUTE_ACCESS")) {
																if (attrPChildren
																		.item(k)
																		.getFirstChild() == null) {
																	curAttribute
																			.setAttributeAccess("");
																} else {
																	curAttribute
																			.setAttributeAccess(attrPChildren
																					.item(
																							k)
																					.getFirstChild()
																					.getNodeValue());
																}

															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"ATTRIBUTE_VALUE_RANGE")) {
																if (attrPChildren
																		.item(k)
																		.getFirstChild() == null) {
																	curAttribute
																			.setAttributeValueRange("");
																}

																else {
																	curAttribute
																			.setAttributeValueRange(attrChildren
																					.item(
																							k)
																					.getFirstChild()
																					.getNodeValue());
																}
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"ATTRIBUTE_RESTRICTIONS")) {
																if (attrPChildren
																		.item(k)
																		.getFirstChild() == null) {
																	curAttribute
																			.setAttributeRestrictions("");
																} else {
																	curAttribute
																			.setAttributeRestrictions(attrChildren
																					.item(
																							k)
																					.getFirstChild()
																					.getNodeValue());
																}
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"ATTRIBUTE_APPLICATION_GUIDANCE")) {
																if (attrPChildren
																		.item(k)
																		.getFirstChild() == null) {
																	curAttribute
																			.setAttributeApplicationGuidance("");
																} else {
																	curAttribute
																			.setAttributeApplicationGuidance(attrChildren
																					.item(
																							k)
																					.getFirstChild()
																					.getNodeValue());
																}
															} else if (attrPChildren
																	.item(k)
																	.getNodeName()
																	.equals(
																			"ATTRIBUTE_COMMENT")) {
																if (attrPChildren
																		.item(k)
																		.getFirstChild() == null) {
																	curAttribute
																			.setAttributeComment("");
																} else {
																	curAttribute
																			.setAttributeComment(attrChildren
																					.item(
																							k)
																					.getFirstChild()
																					.getNodeValue());
																}
															}
														}
													}
													curAttribute.isPrivate = true;
													curMOC
															.addAttribute(curAttribute);

												}
											}
										}

										else if (attrAChildren.item(a)
												.getNodeType() == Node.ELEMENT_NODE
												&& !attrAChildren
														.item(a)
														.getNodeName()
														.equals(
																"Private-Attributes")) {
											curAttribute = new AttributeNode();
											Element attrElement = (Element) attrAChildren
													.item(a);
											curAttribute
													.setAttributeGroupName(attrElement
															.getAttribute("attrGrpName"));
											curAttribute
													.setAttributeGroupId(attrElement
															.getAttribute("attrGrpId"));
											curAttribute
													.setAttributeGroupTermCode(attrElement
															.getAttribute("attrGrpTermCode"));
											curAttribute
													.setAttributeDerivedFrom(attrElement
															.getAttribute("derivedFrom"));
											curAttribute
													.setAttributeKeyNumber(attrKeyNumber);
											attrKeyNumber = attrKeyNumber + 1;
											for (int k = 0; k < attrChildren
													.getLength(); k++) {
												if (attrChildren.item(k)
														.getFirstChild() != null) {
													if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_NAME")) {
														curAttribute
																.setAttributeName(attrChildren
																		.item(k)
																		.getFirstChild()
																		.getNodeValue());
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_ID")) {
														curAttribute
																.setAttributeId(attrChildren
																		.item(k)
																		.getFirstChild()
																		.getNodeValue());
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_TYPE")) {
														if (attrChildren
																.item(k)
																.getFirstChild() != null)
															curAttribute
																	.setAttributeType(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
//														if(curAttribute.getAttributeType() != "")
//															curAttribute
//															.createAsnObj();
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals("TERM_CODE")) {
														curAttribute
																.setAttributeTermCode(attrChildren
																		.item(k)
																		.getFirstChild()
																		.getNodeValue());
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals("Reference")) {
														if (attrChildren
																.item(k)
																.getFirstChild() != null)
															curAttribute
																	.setAttributeReference(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals("Qual")) {
														curAttribute
																.setAttributeQual(attrChildren
																		.item(k)
																		.getFirstChild()
																		.getNodeValue());
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_ACCESS")) {
														if (attrChildren
																.item(k)
																.getFirstChild() == null) {
															curAttribute
																	.setAttributeAccess("");
														} else {
															curAttribute
																	.setAttributeAccess(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														}
														
													}else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_VALUE_RANGE")) {
															if (attrChildren
																	.item(k)
																	.getFirstChild() == null) {
																curAttribute
																		.setAttributeValueRange("");
															}

															else {
																curAttribute
																		.setAttributeValueRange(attrChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															}
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_SAMPLE_VALUE")) {
														
														if (!curAttribute.attribute_type
																.equals("")) {

															
															// Asn1Object asnObj
															// =
															// Asn1ModuleServer.instantiateAsn1Object(curAttribute.attribute_type);
															if(attrChildren
																		.item(k).hasChildNodes()){
																
																Asn1Object asnObj =  curAttribute.createAsnObj();
																NodeList list = attrChildren
																		.item(k)
																		.getChildNodes();
																for (int i = 0; i < list
																		.getLength(); i++) {
																	Node node1 = list
																			.item(i);
																	if (node1
																			.getNodeType() == Node.ELEMENT_NODE)
																		ParseXmlDataType
																				.parseASN1Object(
																						node1,
																						asnObj);

																}

															}
														}
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_RESTRICTIONS")) {
														if (attrChildren
																.item(k)
																.getFirstChild() == null) {
															curAttribute
																	.setAttributeRestrictions("");
														} else {
															curAttribute
																	.setAttributeRestrictions(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_APPLICATION_GUIDANCE")) {
														if (attrChildren
																.item(k)
																.getFirstChild() == null) {
															curAttribute
																	.setAttributeApplicationGuidance("");
														} else {
															curAttribute
																	.setAttributeApplicationGuidance(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_COMMENT")) {
														if (attrChildren
																.item(k)
																.getFirstChild() == null) {
															curAttribute
																	.setAttributeComment("");
														} else {
															curAttribute
																	.setAttributeComment(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														}
													}
												}
											}
											curMOC.addAttribute(curAttribute);
										}

									}
								}
							} else if (node.getNodeName().equals(
									"Behaviour_Info")) {
								NodeList behavBChildren = node.getChildNodes();
								int behavKeyNumber = 0;
								for (int b = 0; b < behavBChildren.getLength(); b++) {
									NodeList behavChildren = behavBChildren
											.item(b).getChildNodes();
									if (behavBChildren.item(b) != null) {
										if (behavBChildren.item(b)
												.getNodeType() == Node.ELEMENT_NODE
												&& behavBChildren.item(b)
														.getNodeName() == "Private-Behaviour") {
											NodeList behavPrivateChildren = behavBChildren
													.item(b).getChildNodes();
											for (int i = 0; i < behavPrivateChildren
													.getLength(); i++) {
												if (behavPrivateChildren
														.item(i) != null
														&& behavPrivateChildren
																.item(i)
																.getNodeType() == Node.ELEMENT_NODE) {
													curBehaviour = new BehaviourNode();
													curBehaviour
															.setBehaviourKeyNumber(behavKeyNumber);
													behavKeyNumber = behavKeyNumber + 1;
													behavChildren = behavPrivateChildren
															.item(i)
															.getChildNodes();
													for (int l = 0; l < behavChildren
															.getLength(); l++) {
														if (behavChildren
																.item(l) != null
																&& behavChildren
																		.item(l)
																		.getFirstChild() != null) {
															if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"METHOD_NAME")) {
																curBehaviour
																		.setMethodName(behavChildren
																				.item(
																						l)
																				.getFirstChild()
																				.getNodeValue());
															} else if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"METHOD_ID")) {
																curBehaviour
																		.setMethodId(behavChildren
																				.item(
																						l)
																				.getFirstChild()
																				.getNodeValue());
															} else if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"BEHAVIOUR_ACTION_PARAMETER")) {
																if (behavChildren
																		.item(l)
																		.getFirstChild() == null) {
																	curBehaviour
																			.setBehaviourActionParameter("");
																} else {
																	curBehaviour
																			.setBehaviourActionParameter(behavChildren
																					.item(
																							l)
																					.getFirstChild()
																					.getNodeValue());
																}
															} else if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"BEHAVIOUR_ACTION_RESULT")) {
																if (behavChildren
																		.item(l)
																		.getFirstChild() == null) {
																	curBehaviour
																			.setBehaviourActionResult("");
																} else {
																	curBehaviour
																			.setBehaviourActionResult(behavChildren
																					.item(
																							l)
																					.getFirstChild()
																					.getNodeValue());
																}
															} else if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"TERM_CODE")) {
																curBehaviour
																		.setBehaviourTermCode(behavChildren
																				.item(
																						l)
																				.getFirstChild()
																				.getNodeValue());
															} else if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"Reference")) {
																curBehaviour
																		.setBehaviourReference(behavChildren
																				.item(
																						l)
																				.getFirstChild()
																				.getNodeValue());
															} else if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"Qual")) {
																curBehaviour
																		.setBehaviourQual(behavChildren
																				.item(
																						l)
																				.getFirstChild()
																				.getNodeValue());
															} else if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"BEHAVIOUR_RESTRICTIONS")) {
																if (behavChildren
																		.item(l)
																		.getFirstChild() == null) {
																	curBehaviour
																			.setBehaviourRestrictions("");
																} else {
																	curBehaviour
																			.setBehaviourRestrictions(behavChildren
																					.item(
																							l)
																					.getFirstChild()
																					.getNodeValue());
																}
															} else if (behavChildren
																	.item(l)
																	.getNodeName()
																	.equals(
																			"BEHAVIOUR_COMMENT")) {
																if (behavChildren
																		.item(l)
																		.getFirstChild() == null) {
																	curBehaviour
																			.setBehaviourComment("");
																} else {
																	curBehaviour
																			.setBehaviourComment(behavChildren
																					.item(
																							l)
																					.getFirstChild()
																					.getNodeValue());
																}
															}
														}
													}
													curBehaviour.isPrivate = true;
													curMOC
															.addBehaviour(curBehaviour);

												}
											}
										} else if (behavBChildren.item(b)
												.getNodeType() == Node.ELEMENT_NODE
												&& behavBChildren.item(b)
														.getNodeName() != "Private-Behaviour") {
											curBehaviour = new BehaviourNode();
											curBehaviour
													.setBehaviourKeyNumber(behavKeyNumber);
											behavKeyNumber = behavKeyNumber + 1;
											for (int l = 0; l < behavChildren
													.getLength(); l++) {
												if (behavChildren.item(l)
														.getNodeName().equals(
																"METHOD_NAME")) {
													curBehaviour
															.setMethodName(behavChildren
																	.item(l)
																	.getFirstChild()
																	.getNodeValue());
												} else if (behavChildren
														.item(l).getNodeName()
														.equals("METHOD_ID")) {
													curBehaviour
															.setMethodId(behavChildren
																	.item(l)
																	.getFirstChild()
																	.getNodeValue());
												} else if (behavChildren
														.item(l)
														.getNodeName()
														.equals(
																"BEHAVIOUR_ACTION_PARAMETER")) {
													if (behavChildren.item(l)
															.getFirstChild() == null) {
														curBehaviour
																.setBehaviourActionParameter("");
													} else {
														curBehaviour
																.setBehaviourActionParameter(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													}
												} else if (behavChildren
														.item(l)
														.getNodeName()
														.equals(
																"BEHAVIOUR_ACTION_RESULT")) {
													if (behavChildren.item(l)
															.getFirstChild() == null) {
														curBehaviour
																.setBehaviourActionResult("");
													} else {
														curBehaviour
																.setBehaviourActionResult(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													}
												} else if (behavChildren
														.item(l).getNodeName()
														.equals("TERM_CODE")) {
													curBehaviour
															.setBehaviourTermCode(behavChildren
																	.item(l)
																	.getFirstChild()
																	.getNodeValue());
												} else if (behavChildren
														.item(l).getNodeName()
														.equals("Reference")) {
													curBehaviour
															.setBehaviourReference(behavChildren
																	.item(l)
																	.getFirstChild()
																	.getNodeValue());
												} else if (behavChildren
														.item(l).getNodeName()
														.equals("Qual")) {
													curBehaviour
															.setBehaviourQual(behavChildren
																	.item(l)
																	.getFirstChild()
																	.getNodeValue());
												} else if (behavChildren
														.item(l)
														.getNodeName()
														.equals(
																"BEHAVIOUR_RESTRICTIONS")) {
													if (behavChildren.item(l)
															.getFirstChild() == null) {
														curBehaviour
																.setBehaviourRestrictions("");
													} else {
														curBehaviour
																.setBehaviourRestrictions(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													}
												} else if (behavChildren
														.item(l)
														.getNodeName()
														.equals(
																"BEHAVIOUR_COMMENT")) {
													if (behavChildren.item(l)
															.getFirstChild() == null) {
														curBehaviour
																.setBehaviourComment("");
													} else {
														curBehaviour
																.setBehaviourComment(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													}
												}
											}
											curMOC.addBehaviour(curBehaviour);
										}
									}
								}
							} else if (node.getNodeName().equals(
									"Notification_Info")) {
								NodeList notiBChildren = node.getChildNodes();
								int notiKeyNumber = 0;
								for (int c = 0; c < notiBChildren.getLength(); c++) {
									NodeList notiChildren = notiBChildren.item(
											c).getChildNodes();
									if (notiBChildren.item(c) != null) {
										if (notiBChildren.item(c).getNodeType() == Node.ELEMENT_NODE
												&& notiBChildren.item(c)
														.getNodeName() == "Private-Notification") {
											NodeList notiPrivateChildren = notiBChildren
													.item(c).getChildNodes();
											for (int i = 0; i < notiPrivateChildren
													.getLength(); i++) {
												if (notiPrivateChildren.item(i) != null
														&& notiPrivateChildren
																.item(i)
																.getNodeType() == Node.ELEMENT_NODE) {
													curNotification = new NotificationNode();
													curNotification
															.setNotificationKeyNumber(notiKeyNumber);
													notiKeyNumber = notiKeyNumber + 1;
													notiChildren = notiPrivateChildren
															.item(i)
															.getChildNodes();
													for (int m = 0; m < notiChildren
															.getLength(); m++) {
														if (notiChildren
																.item(m)
																.getFirstChild() != null) {
															if (notiChildren
																	.item(m)
																	.getNodeName()
																	.equals(
																			"NOTIFICATION_NAME")) {
																curNotification
																		.setNotificationName(notiChildren
																				.item(
																						m)
																				.getFirstChild()
																				.getNodeValue());
															} else if (notiChildren
																	.item(m)
																	.getNodeName()
																	.equals(
																			"NOTIFICATION_ID")) {
																curNotification
																		.setNotificationId(notiChildren
																				.item(
																						m)
																				.getFirstChild()
																				.getNodeValue());
															} else if (notiChildren
																	.item(m)
																	.getNodeName()
																	.equals(
																			"NOTIFICATION_EVENT_PARAMETER")) {
																if (notiChildren
																		.item(m)
																		.getFirstChild() == null) {
																	curNotification
																			.setNotificationEventParameter("");
																} else {
																	curNotification
																			.setNotificationEventParameter(notiChildren
																					.item(
																							m)
																					.getFirstChild()
																					.getNodeValue());
																}
															} else if (notiChildren
																	.item(m)
																	.getNodeName()
																	.equals(
																			"TERM_CODE")) {
																curNotification
																		.setNotificationTermCode(notiChildren
																				.item(
																						m)
																				.getFirstChild()
																				.getNodeValue());
															} else if (notiChildren
																	.item(m)
																	.getNodeName()
																	.equals(
																			"Reference")) {
																curNotification
																		.setNotificationReference(notiChildren
																				.item(
																						m)
																				.getFirstChild()
																				.getNodeValue());
															} else if (notiChildren
																	.item(m)
																	.getNodeName()
																	.equals(
																			"Qual")) {
																curNotification
																		.setNotificationQual(notiChildren
																				.item(
																						m)
																				.getFirstChild()
																				.getNodeValue());
															} else if (notiChildren
																	.item(m)
																	.getNodeName()
																	.equals(
																			"NOTIFICATION_RESTRICTIONS")) {
																if (notiChildren
																		.item(m)
																		.getFirstChild() == null) {
																	curNotification
																			.setNotificationRestrictions("");
																} else {
																	curNotification
																			.setNotificationRestrictions(notiChildren
																					.item(
																							m)
																					.getFirstChild()
																					.getNodeValue());
																}
															} else if (notiChildren
																	.item(m)
																	.getNodeName()
																	.equals(
																			"NOTIFICATION_COMMENT")) {
																if (notiChildren
																		.item(m)
																		.getFirstChild() == null) {
																	curNotification
																			.setNotificationComment("");
																} else {
																	curNotification
																			.setNotificationComment(notiChildren
																					.item(
																							m)
																					.getFirstChild()
																					.getNodeValue());
																}
															}
														}
													}

													curNotification.isPrivate = true;
													curMOC
															.addNotification(curNotification);

												}
											}
										}

										else if (notiBChildren.item(c)
												.getNodeType() == Node.ELEMENT_NODE
												&& notiBChildren.item(c)
														.getNodeName() != "Private-Notification") {
											curNotification = new NotificationNode();
											curNotification
													.setNotificationKeyNumber(notiKeyNumber);
											notiKeyNumber = notiKeyNumber + 1;
											for (int m = 0; m < notiChildren
													.getLength(); m++) {
												if (notiChildren.item(m)
														.getFirstChild() != null) {
													if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_NAME")) {
														curNotification
																.setNotificationName(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_ID")) {
														curNotification
																.setNotificationId(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_EVENT_PARAMETER")) {
														if (notiChildren
																.item(m)
																.getFirstChild() == null) {
															curNotification
																	.setNotificationEventParameter("");
														} else {
															curNotification
																	.setNotificationEventParameter(notiChildren
																			.item(
																					m)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals("TERM_CODE")) {
														curNotification
																.setNotificationTermCode(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals("Reference")) {
														curNotification
																.setNotificationReference(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals("Qual")) {
														curNotification
																.setNotificationQual(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_RESTRICTIONS")) {
														if (notiChildren
																.item(m)
																.getFirstChild() == null) {
															curNotification
																	.setNotificationRestrictions("");
														} else {
															curNotification
																	.setNotificationRestrictions(notiChildren
																			.item(
																					m)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_COMMENT")) {
														if (notiChildren
																.item(m)
																.getFirstChild() == null) {
															curNotification
																	.setNotificationComment("");
														} else {
															curNotification
																	.setNotificationComment(notiChildren
																			.item(
																					m)
																			.getFirstChild()
																			.getNodeValue());
														}
													}
												}

											}
											curMOC
													.addNotification(curNotification);
										}
									}
								}
							}

							else {
								treeNode.add(processXML(node, isMOCPrivate));
							}
						}
					}
				}
			}
		}
		return treeNode;
	}

	private DefaultMutableTreeNode createDynamicXML(Node dimroot, Node root) {

		DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(dimroot
				.getNodeName());
		treeNode.add(new DefaultMutableTreeNode(root.getNodeName()));

		MOCNode rootMoc = new MOCNode();
		rootMoc.setObjectName(dimroot.getNodeName());
		curvMOC.add(rootMoc);

		MOCNode mdsMoc = new MOCNode();
		mdsMoc.setObjectName(root.getNodeName());

		mocIdNumber = mocIdNumber + 1;

		if (root.hasChildNodes()) {

			NodeList children;

			int numChildren;
			Node node;

			children = root.getChildNodes();
			if (children != null) {
				numChildren = children.getLength();
				curMOC1 = new MOCNode();
				for (int j = 0; j < numChildren; j++) {
					node = children.item(j);
					if (node != null) {
						if (node.getNodeType() == Node.ELEMENT_NODE) {
							if (node.getNodeName().equals("OBJECT_NAME")) {
								curMOC1.setObjectName(node.getFirstChild()
										.getNodeValue());
								curMOC1.setMocIdNumber(mocIdNumber);
								mocIdNumber = mocIdNumber + 1;
								Element elnode = (Element) node;
								curMOC1.setObjectNameLabel(elnode
										.getAttribute("Label"));
							} else if (node.getNodeName().equals("OBJECT_ID")) {
								curMOC1.setObjectId(node.getFirstChild()
										.getNodeValue());
							} else if (node.getNodeName().equals("TERM_CODE")) {
								curMOC1.setMocTermCode(node.getFirstChild()
										.getNodeValue());
							} else if (node.getNodeName().equals("Reference")) {
								curMOC1.setReference(node.getFirstChild()
										.getNodeValue());
							} else if (node.getNodeName().equals(
									"MOC_RESTRICTIONS")) {
								if (node.getFirstChild() == null) {
									curMOC1.setMocRestrictions("");
								} else {
									curMOC1.setMocRestrictions(node
											.getFirstChild().getNodeValue());
								}
							} else if (node.getNodeName().equals(
									"MOC_APPLICATION_GUIDANCE")) {
								if (node.getFirstChild() == null) {
									curMOC1.setMocApplicationGuidance("");
								} else {
									curMOC1.setMocApplicationGuidance(node
											.getFirstChild().getNodeValue());
								}
							} else if (node.getNodeName().equals(
									"MOC_SERVICES_SUPPORTED")) {
								if (node.getFirstChild() == null) {
									curMOC1.setMocServicesSupported(null);
								} else {
									curMOC1.setMocServicesSupported(node
											.getFirstChild().getNodeValue());
								}
							} else if (node.getNodeName().equals("MOC_COMMENT")) {
								if (node.getFirstChild() == null) {
									curMOC1.setMocComment("");
								} else {
									curMOC1.setMocComment(node.getFirstChild()
											.getNodeValue());
								}
								curvMOC.add(curMOC1);
							} else if (node.getNodeName().equals(
									"Attribute_Info")) {
								NodeList attrAChildren = node.getChildNodes();
								for (int a = 0; a < attrAChildren.getLength(); a++) {
									NodeList attrChildren = attrAChildren.item(
											a).getChildNodes();
									if (attrAChildren.item(a) != null) {
										if (attrAChildren.item(a).getNodeType() == Node.ELEMENT_NODE) {
											Element qualNode = (Element) attrAChildren
													.item(a);
											NodeList qualList = qualNode
													.getElementsByTagName("Qual");
											for (int q = 0; q < qualList
													.getLength(); q++) {
												if (qualList.item(q)
														.getFirstChild()
														.getNodeValue().equals(
																"M")
														|| qualList
																.item(q)
																.getFirstChild()
																.getNodeValue()
																.equals("n/a")) {
													curAttribute = new AttributeNode();
													Element attrElement = (Element) attrAChildren
															.item(a);
													curAttribute
															.setAttributeGroupName(attrElement
																	.getAttribute("attrGrpName"));
													curAttribute
															.setAttributeGroupId(attrElement
																	.getAttribute("attrGrpId"));
													curAttribute
															.setAttributeGroupTermCode(attrElement
																	.getAttribute("attrGrpTermCode"));
													curAttribute
															.setAttributeDerivedFrom(attrElement
																	.getAttribute("derivedFrom"));

													int index = getVMoc()
															.indexOf(mdsMoc);
													MOCNode rMoc = (MOCNode) getVMoc()
															.get(index);
													Vector vAttr = rMoc
															.getAttribute();

													for (int x = 0; x < vAttr
															.size(); x++) {
														if (((DIMMOC) vAttr
																.get(x))
																.getAttributeName()
																.equals(
																		attrAChildren
																				.item(
																						a)
																				.getNodeName())) {
															curAttribute
																	.setAttributeKeyNumber(((DIMMOC) vAttr
																			.get(x))
																			.getAttributeKeyNumber());
															break;
														}
													}
													for (int k = 0; k < attrChildren
															.getLength(); k++) {
														if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_NAME")) {
															curAttribute
																	.setAttributeName(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_ID")) {
															curAttribute
																	.setAttributeId(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_TYPE")) {
															curAttribute
																	.setAttributeType(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
//															if(curAttribute.getAttributeType() != "")
//																curAttribute.createAsnObj();
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"TERM_CODE")) {
															curAttribute
																	.setAttributeTermCode(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"Reference")) {
															curAttribute
																	.setAttributeReference(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals("Qual")) {
															curAttribute
																	.setAttributeQual(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_ACCESS")) {
															if (attrChildren
																	.item(k)
																	.getFirstChild() == null) {
																curAttribute
																		.setAttributeAccess("");
															} else {
																curAttribute
																		.setAttributeAccess(attrChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															}
														}
														else if (attrChildren
															.item(k)
															.getNodeName()
															.equals(
																	"ATTRIBUTE_VALUE_RANGE")) {
														if (attrChildren
																.item(k)
																.getFirstChild() == null) {
															curAttribute
																	.setAttributeValueRange("");
														}

														else {
															curAttribute
																	.setAttributeValueRange(attrChildren
																			.item(
																					k)
																			.getFirstChild()
																			.getNodeValue());
														}
														}
														else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_SAMPLE_VALUE")) {
															if (!curAttribute.attribute_type
																	.equals("")) {
																
																if(attrChildren
																		.item(
																				k).hasChildNodes()) {
																	Asn1Object asnObj =  curAttribute.createAsnObj();
																	NodeList list = attrChildren
																			.item(
																					k)
																			.getChildNodes();
																	for (int i = 0; i < list
																			.getLength(); i++) {
																		Node node1 = list
																				.item(i);
																		if (node1
																				.getNodeType() == Node.ELEMENT_NODE) {
																			ParseXmlDataType
																					.parseASN1Object(
																							node1,
																							asnObj);
																			curAttribute
																					.setAttributeSampleValue(asnObj);
																		}
																	}
																}
															}
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_RESTRICTIONS")) {
															if (attrChildren
																	.item(k)
																	.getFirstChild() == null) {
																curAttribute
																		.setAttributeRestrictions("");
															} else {
																curAttribute
																		.setAttributeRestrictions(attrChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															}
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_APPLICATION_GUIDANCE")) {
															if (attrChildren
																	.item(k)
																	.getFirstChild() == null) {
																curAttribute
																		.setAttributeApplicationGuidance("");
															} else {
																curAttribute
																		.setAttributeApplicationGuidance(attrChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															}
														} else if (attrChildren
																.item(k)
																.getNodeName()
																.equals(
																		"ATTRIBUTE_COMMENT")) {
															if (attrChildren
																	.item(k)
																	.getFirstChild() == null) {
																curAttribute
																		.setAttributeComment("");
															} else {
																curAttribute
																		.setAttributeComment(attrChildren
																				.item(
																						k)
																				.getFirstChild()
																				.getNodeValue());
															}
														}
													}
													curMOC1
															.addAttribute(curAttribute);
												}
											}
										}
									}
								}
							} else if (node.getNodeName().equals(
									"Behaviour_Info")) {
								NodeList behavBChildren = node.getChildNodes();
								for (int b = 0; b < behavBChildren.getLength(); b++) {
									NodeList behavChildren = behavBChildren
											.item(b).getChildNodes();
									if (behavBChildren.item(b) != null) {
										if (behavBChildren.item(b)
												.getNodeType() == Node.ELEMENT_NODE) {
											Element behavNodeName = (Element) behavBChildren
													.item(b);
											NodeList behavNameList = behavNodeName
													.getElementsByTagName("METHOD_NAME");
											for (int x = 0; x < behavNameList
													.getLength(); x++) {
												curBehaviour = new BehaviourNode();
												
												int index = getVMoc().indexOf(
														mdsMoc);
												MOCNode rMoc = (MOCNode) getVMoc()
														.get(index);
												Vector vBehav = rMoc
														.getBehaviour();
												for (int y = 0; y < vBehav
														.size(); y++) {
													if (((DIMMOC) vBehav.get(y))
															.getMethodName()
															.equals(
																	behavBChildren
																			.item(
																					b)
																			.getNodeName())) {
														curBehaviour
																.setBehaviourKeyNumber(((DIMMOC) vBehav
																		.get(y))
																		.getBehaviourKeyNumber());
														break;
													}
												}
												for (int l = 0; l < behavChildren
														.getLength(); l++) {
													if (behavChildren
															.item(l)
															.getNodeName()
															.equals(
																	"METHOD_NAME")) {
														curBehaviour
																.setMethodName(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													} else if (behavChildren
															.item(l)
															.getNodeName()
															.equals("METHOD_ID")) {
														curBehaviour
																.setMethodId(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													} else if (behavChildren
															.item(l)
															.getNodeName()
															.equals(
																	"BEHAVIOUR_ACTION_PARAMETER")) {
														if (behavChildren
																.item(l)
																.getFirstChild() == null) {
															curBehaviour
																	.setBehaviourActionParameter("");
														} else {
															curBehaviour
																	.setBehaviourActionParameter(behavChildren
																			.item(
																					l)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (behavChildren
															.item(l)
															.getNodeName()
															.equals(
																	"BEHAVIOUR_ACTION_RESULT")) {
														if (behavChildren
																.item(l)
																.getFirstChild() == null) {
															curBehaviour
																	.setBehaviourActionResult("");
														} else {
															curBehaviour
																	.setBehaviourActionResult(behavChildren
																			.item(
																					l)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (behavChildren
															.item(l)
															.getNodeName()
															.equals("TERM_CODE")) {
														curBehaviour
																.setBehaviourTermCode(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													} else if (behavChildren
															.item(l)
															.getNodeName()
															.equals("Reference")) {
														curBehaviour
																.setBehaviourReference(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													} else if (behavChildren
															.item(l)
															.getNodeName()
															.equals("Qual")) {
														curBehaviour
																.setBehaviourQual(behavChildren
																		.item(l)
																		.getFirstChild()
																		.getNodeValue());
													} else if (behavChildren
															.item(l)
															.getNodeName()
															.equals(
																	"BEHAVIOUR_RESTRICTIONS")) {
														if (behavChildren
																.item(l)
																.getFirstChild() == null) {
															curBehaviour
																	.setBehaviourRestrictions("");
														} else {
															curBehaviour
																	.setBehaviourRestrictions(behavChildren
																			.item(
																					l)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (behavChildren
															.item(l)
															.getNodeName()
															.equals(
																	"BEHAVIOUR_COMMENT")) {
														if (behavChildren
																.item(l)
																.getFirstChild() == null) {
															curBehaviour
																	.setBehaviourComment("");
														} else {
															curBehaviour
																	.setBehaviourComment(behavChildren
																			.item(
																					l)
																			.getFirstChild()
																			.getNodeValue());
														}
													}
												}
											}
											curMOC1.addBehaviour(curBehaviour);
										}
									}
								}
							} else if (node.getNodeName().equals(
									"Notification_Info")) {
								NodeList notiBChildren = node.getChildNodes();
								for (int c = 0; c < notiBChildren.getLength(); c++) {
									NodeList notiChildren = notiBChildren.item(
											c).getChildNodes();
									if (notiBChildren.item(c) != null) {
										if (notiBChildren.item(c).getNodeType() == Node.ELEMENT_NODE) {
											Element notiNameNode = (Element) notiBChildren
													.item(c);
											NodeList notiNameList = notiNameNode
													.getElementsByTagName("NOTIFICATION_NAME");
											for (int x = 0; x < notiNameList
													.getLength(); x++) {
												curNotification = new NotificationNode();
												
												int index = getVMoc().indexOf(
														mdsMoc);
												MOCNode rMoc = (MOCNode) getVMoc()
														.get(index);
												Vector vNoti = rMoc
														.getNotification();
												for (int y = 0; y < vNoti
														.size(); y++) {
													if (((DIMMOC) vNoti.get(y))
															.getNotificationName()
															.equals(
																	notiBChildren
																			.item(
																					c)
																			.getNodeName())) {
														curNotification
																.setNotificationKeyNumber(((DIMMOC) vNoti
																		.get(y))
																		.getNotificationKeyNumber());
														break;
													}
												}
												for (int m = 0; m < notiChildren
														.getLength(); m++) {
													if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_NAME")) {
														curNotification
																.setNotificationName(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_ID")) {
														curNotification
																.setNotificationId(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_EVENT_PARAMETER")) {
														if (notiChildren
																.item(m)
																.getFirstChild() == null) {
															curNotification
																	.setNotificationEventParameter("");
														} else {
															curNotification
																	.setNotificationEventParameter(notiChildren
																			.item(
																					m)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals("TERM_CODE")) {
														curNotification
																.setNotificationTermCode(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals("Reference")) {
														curNotification
																.setNotificationReference(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals("Qual")) {
														curNotification
																.setNotificationQual(notiChildren
																		.item(m)
																		.getFirstChild()
																		.getNodeValue());
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_RESTRICTIONS")) {
														if (notiChildren
																.item(m)
																.getFirstChild() == null) {
															curNotification
																	.setNotificationRestrictions("");
														} else {
															curNotification
																	.setNotificationRestrictions(notiChildren
																			.item(
																					m)
																			.getFirstChild()
																			.getNodeValue());
														}
													} else if (notiChildren
															.item(m)
															.getNodeName()
															.equals(
																	"NOTIFICATION_COMMENT")) {
														if (notiChildren
																.item(m)
																.getFirstChild() == null) {
															curNotification
																	.setNotificationComment("");
														} else {
															curNotification
																	.setNotificationComment(notiChildren
																			.item(
																					m)
																			.getFirstChild()
																			.getNodeValue());
														}
													}
												}
												curMOC1
														.addNotification(curNotification);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return treeNode;
	}

	public void removeMOC(DefaultMutableTreeNode mocNode) {
		mocNode.removeFromParent();
	}
	 public MOCNode getMOCNode() {
         return selectedMOCNode;
    }
	/**
	 * Get the tree representation of the batch
	 * 
	 * @return The tree representation of the batch
	 */
	public DefaultMutableTreeNode getTree() {
		return curVecTree;
	}

	public Document getDOMDocument() {
		return defaultDocument;
	}

	public DefaultMutableTreeNode getDefaultTree() {
		return defaultVecTree;
	}

	public Vector getVMoc() {
		return vMOC;
	}


	public Vector<MOCNode> getcurVMoc() {

		return curvMOC;
	}

	public void addToVMoc(MOCNode moc) {
		if (moc != null) {
			// vMOC.add(moc);
			curvMOC.add(moc);
		}
	}

	public void renameMOC(DefaultMutableTreeNode mocToRename, String mocNewname) {
		addMOC(mocNewname, (DefaultMutableTreeNode) mocToRename.getParent());
	}

	/*
	 * public void addMOC(String mocToAdd, DefaultMutableTreeNode
	 * mocHighlighted) { if (!mocToAdd.equals("No children")){
	 * mocHighlighted.add(getNode(mocToAdd,mocHighlighted)); } }
	 * 
	 */

	public void addMOC(String mocToAdd, DefaultMutableTreeNode mocHighlighted) {
		if (!mocToAdd.equals("No children")) {
			mocHighlighted.add(getNode(mocToAdd, mocHighlighted));
		}
	}

	public void addPrivateMOC(MOCNode moc, DefaultMutableTreeNode mocHighlighted) {
		curvMOC.add(moc);
		mocHighlighted.add(new DefaultMutableTreeNode(moc));

	}

	private DefaultMutableTreeNode getNode(String mocType,
			DefaultMutableTreeNode mocHighlighted) {
		DefaultMutableTreeNode mocToAdd = null;
		curIndex = 0;

		// Enumeration enumTreeNode = mocHighlighted.children();
		// int flag =0;
		// while (flag == 0) {
		//	      	
		// DefaultMutableTreeNode moc2Add = (DefaultMutableTreeNode)
		// enumTreeNode.nextElement();
		// if (moc2Add.toString().equals(mocType)) {
		DefaultMutableTreeNode moc2Add = new DefaultMutableTreeNode(mocType);
		mocToAdd = addToVecTreeRelationship(moc2Add);
		// flag = 1;
		// }
		// }
		return mocToAdd;
	}
}
