package icsDyn;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1Lib.CHOICE;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Asn1Lib.SEQUENCEOF;

/**
 * This class models an attribute
 * @author Rick Rivello
 *
 */
public class AttributeNode extends DIMMOC {

   public AttributeNode() {}
	  
      public AttributeNode(AttributeNode an) {

         this();

         attribute_name            = an.getAttributeName();
         attr_grpname              = an.getAttributeGroupName();
         attr_grpid                = an.getAttributeGroupId();
         attr_grptermcode          = an.getAttributeGroupTermCode();
         attr_derivedfrom          = an.getAttributeDerivedFrom();
         attr_keynum               = an.getAttributeKeyNumber();
         attribute_id              = an.getAttributeId();
         attribute_type            = an.getAttributeType();
         attr_termcode             = an.getAttributeTermCode();
		 attr_ref                  = an.getAttributeReference();
		 attr_qual                 = an.getAttributeQual();
		 attr_status               = an.getAttributeStatus();
         attr_access               = an.getAttributeAccess();
         attr_value_range          = an.getAttributeValueRange();
         attr_restrictions         = an.getAttributeRestrictions();
         attr_application_guidance = an.getAttributeApplicationGuidance(); 
         attr_comment              = an.getAttributeComment();        
         
      }

      protected Asn1Object attr_sample_value = null;
      public void setAttributeSampleValue(Asn1Object asnObjIn){
    	  attr_sample_value = asnObjIn;
      }
      public Asn1Object getAttributeSampleValue(){
    	  return attr_sample_value;
      }
      public String toString() {
         return attribute_name;
      }

	public Asn1Object createAsnObj() {
		if(attribute_type.contains(","))
		{
			String[] vectTypes = attribute_type.split(",");
			Identifier[] m_IdentifierArray = new Identifier[vectTypes.length];
		
			CHOICE choice = new CHOICE("Choice");
			for(int i = 0; i < vectTypes.length; i++){
				m_IdentifierArray[i] = new Identifier(new INTEGER(vectTypes[i],""+i),vectTypes[i]);					
			}
			choice.setChoices(new gov.nist.div897.Asn1ILib.Choices(m_IdentifierArray));
			
			attr_sample_value = choice;
		}
		else if(attribute_type.contains("SEQUENCE OF")){
			String type = attribute_type.replace("SEQUENCE OF","").trim();
			SEQUENCEOF sequenceof = new SEQUENCEOF();
			sequenceof.setSequenceOfClassNameASN1Name(type);
			
			attr_sample_value = sequenceof;
		}
		else
			attr_sample_value = Asn1ModuleServer.instantiateAsn1Object(attribute_type);
		return attr_sample_value;
	}
}
