<?xml version="1.0" encoding="UTF-8"?>
<?altova_samplexml C:\ICS\xml\ICS-Tool.xml?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes"/>
	<xsl:template match="/">
		<Table>
			<xsl:for-each select="//OBJECT_NAME">
				<xsl:sort select="../OBJECT_NAME"/> 
				<xsl:comment>call row template developed further</xsl:comment>
				<xsl:call-template name="row">
					<xsl:with-param name="pos" select="position()"/>
				</xsl:call-template>
			</xsl:for-each>
		</Table>
	</xsl:template>
	<xsl:template name="row">
		<xsl:param name="pos"/>
		<xsl:for-each select="../*/*[ATTRIBUTE_NAME] | ../*/*/Attributes">
		<xsl:sort select="ATTRIBUTE_NAME"/> 
			<tr>
				<xsl:if test= "string(name(..))='Private-Attributes'">
					<Private>true</Private>
				</xsl:if>
				<td>ATTR-<xsl:value-of select="$pos"/>-<xsl:value-of select="position()"/>
				</td>
				<td>
					<b>
						<xsl:value-of select="ATTRIBUTE_NAME"/>
					</b>
					<br>
						<xsl:value-of select="ATTRIBUTE_ID"/>
					</br>
				</td>
				<td>
					<xsl:value-of select="substring-after(Reference, 'clause')"/>
				</td>
				<td>
					<xsl:value-of select="Qual"/>
				</td>
				<td>
					<xsl:if test="ATTRIBUTE_ACCESS!=''">
						<b>
							<i>Access: </i>
						</b>
						<xsl:value-of select="ATTRIBUTE_ACCESS"/>
					</xsl:if>
					<xsl:if test="ATTRIBUTE_VALUE_RANGE!=''">
						<br>
							<b>
								<i>Value_Ranges: </i>
							</b>
							<xsl:value-of select="ATTRIBUTE_VALUE_RANGE"/>
						</br>
					</xsl:if>
					<xsl:if test="ATTRIBUTE_Restrictions!=''">
						<br>
							<b>
								<i>Restrictions: </i>
							</b>
							<xsl:value-of select="ATTRIBUTE_Restrictions"/>
						</br>
					</xsl:if>
				</td>
				<td>
					<xsl:value-of select="ATTRIBUTE_COMMENT"/>
				</td>
			</tr>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
