/*
 * Asn1Object.java
 *
 * Created on October 30, 2006, 1:41 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1ILib;
import gov.nist.div897.Services.*;
import java.io.*;
import java.nio.*;
import java.util.*;
import java.math.*;
import java.lang.*;
import org.w3c.dom.*;

/**
 *
 * @author rtheimer
 */
public class Asn1Object implements IAsn1Object, Cloneable{
    //static ANYDefinedBys;
    static final private String m_String_NameAsn1Type = "Asn1Object";
    static final private Tag m_Tag = new Tag(TagClass.UNDEFINED,new byte[]{0x00});
    //protected Range m_Range;
    protected String m_String_NameInstance;
    //protected Identifiers m_Identifiers;
    protected Attributes m_Attributes;
    //protected Integer m_Integer_FixedDataSize;
    //protected Integer m_Integer_MinimumDataSize;
    //protected Integer m_Integer_MaximumDataSize;
    protected byte[] m_byteArray_Data;
    /** Creates a new instance of Asn1Object */
    
    
    static public Boolean IsINTEGER(){
        return false;
    }
    static public Boolean IsCHOICE(){
        return false;
    }
    static public Boolean IsSEQUENCE(){
        return false;
    }
    static public Boolean IsSEQUENCEOF(){
        return false;
    }
    static public Boolean IsANYDEFINEDBY(){
        return false;
    }
    static public Boolean IsOCTETSTRING(){
        return false;
    }
    static public Boolean IsBITSTRING(){
        return false;
    }
    static public String getNameASN1Type(){
        return m_String_NameAsn1Type;
    }
    static public Tag getTag(){
        return m_Tag;
    }
    static public Boolean addArgumentNodeList(NodeList a_NodeList){
        return false;
    }
    public Asn1Object() {
        m_String_NameInstance = "";
        //m_Identifiers = null;
        m_Attributes = null;
        //m_Range = null;
        //m_Integer_FixedDataSize = null;
        //m_Integer_MinimumDataSize = null;
        //m_Integer_MaximumDataSize = null;
        m_byteArray_Data = null;
    }
    public Asn1Object(Asn1Object a_Asn1Object){
        this();
        m_Attributes = new Attributes(a_Asn1Object.m_Attributes);
        m_byteArray_Data = a_Asn1Object.m_byteArray_Data.clone();
    }
    public Asn1Object(String a_String){
        this();
        setNameInstance(a_String);
    }
    public Asn1Object(String a_String_NameInstance, String a_String_Data){
        this();
        setNameInstance(a_String_NameInstance);
        setData(a_String_Data);
    }
    public Asn1Object(String a_String, byte[] a_byteArray){
        this();
        setNameInstance(a_String);
        setData(a_byteArray);
    }
    public Asn1Object(byte[] a_byteArray){
        this();
        setData(a_byteArray);
    }
    public boolean equals(Object a_Object){
        if(this == a_Object) return true;
        if (!(a_Object instanceof Asn1Object)) return false;
        Asn1Object l_Asn1Object = (Asn1Object)a_Object;
        if(!Arrays.equals(m_byteArray_Data,l_Asn1Object.getData())) return false;
        return true;
    }
    public int hashCode() {
        byte[] l_byteArray = m_byteArray_Data;
        if(l_byteArray != null && l_byteArray.length>4){
            l_byteArray = new byte[4];
            for(int l_int = 0; l_int<4; l_int++) l_byteArray[l_int]=m_byteArray_Data[l_int];
        }
        if(l_byteArray != null)
        return Services.GetInteger(l_byteArray);
        else
        	return -1;
    }
    public boolean setIdentifiers(Identifiers a_Identifiers){
        return false;
        //m_Identifiers = (Identifiers)a_Identifiers.clone();
    }
    public Identifiers getIdentifiers(){
        return null;
//        Identifiers l_Identifiers_Return = null;
//        if(m_Identifiers != null) l_Identifiers_Return = (Identifiers)m_Identifiers.clone();
//        return l_Identifiers_Return;
    }
    public void setNameInstance(String a_String){
        m_String_NameInstance = a_String;
    }
    public String getNameInstance(){
        return m_String_NameInstance;
    }
//    public void setTagNumber(long a_long){
//        ByteBuffer l_ByteBuffer = ByteBuffer.allocate(8);
//        l_ByteBuffer.putLong(a_long);
//        l_ByteBuffer.rewind();
//        m_Tag.m_byteArray_TagNumber = l_ByteBuffer.array().clone();
//    }
//    public void setTagNumber(int a_int){
//        ByteBuffer l_ByteBuffer = ByteBuffer.allocate(4);
//        l_ByteBuffer.putInt(a_int);
//        l_ByteBuffer.rewind();
//        m_Tag.m_byteArray_TagNumber = l_ByteBuffer.array().clone();
//    }
//    public void setTagNumber(byte a_byte){
//        ByteBuffer l_ByteBuffer = ByteBuffer.allocate(1);
//        m_Tag.m_byteArray_TagNumber = new byte[1];
//        m_Tag.m_byteArray_TagNumber[0] = a_byte;
//    }
//    public byte[] getTagNumber(){
//        return m_Tag.m_byteArray_TagNumber;
//    }
//    public Integer getTagNumberInteger(){
//        return Services.GetInteger(m_Tag.m_byteArray_TagNumber);
//    }
//    public Long getTagNumberLong(){
//        return Services.GetLong(m_Tag.m_byteArray_TagNumber);
//    }
//    public Tag getTag(){
//        return m_Tag;
//    }
    public byte[] getData(){
        return m_byteArray_Data;
    }
    public BigInteger getDataAsBigInteger(){
        return new BigInteger(getData());
    }
    public RangeArrayList getRangeArrayList(){
        return null;
    }
    public boolean setRangeArrayList(RangeArrayList a_RangeArrayList){
        return false;
    }
    public SizeRangeArrayList getSizeRangeArrayList(){
        return null;
    }
    public boolean setSizeRangeArrayList(SizeRangeArrayList a_SizeRangeArrayList){
        return false;
    }
//    public BigInteger getIntegerRangeLowerBoundBigInteger(){
//        BigInteger l_BigInteger_Return = null;
//        if(getRange() != null)
//            if(getRange().getLowerBound() != null)
//                l_BigInteger_Return = getRange().getLowerBound().getBigInteger();
//        return l_BigInteger_Return;
//    }
//    public BigInteger getIntegerRangeUpperBoundBigInteger(){
//        BigInteger l_BigInteger_Return = null;
//        if(getRange() != null)
//            if(getRange().getUpperBound() != null)
//                l_BigInteger_Return = getRange().getUpperBound().getBigInteger();
//        return l_BigInteger_Return;
//    }
    public void setData(byte[] a_byteArray){
        if(a_byteArray != null) m_byteArray_Data = a_byteArray.clone();
    }
    public void setData(String a_String){
        Integer l_Integer_Size = getFixedDataSize();
        if(l_Integer_Size != null) setData(l_Integer_Size, a_String);
        else{
            byte[] l_byteArray = new BigInteger(a_String).toByteArray();
            setData(l_byteArray);
        }
    }
    public void setData(int a_int, String a_String){
        byte[] l_byteArray = Services.toByteArray(a_int,"decimal",a_String);
        setData(l_byteArray);
    }
    public boolean printIdentifiersXML(PrintStream a_PrintStream){
        return false;
    }
    public boolean printRangeXML(PrintStream a_PrintStream){
        return false;
    }
//    public void printIdentifiersXML(PrintStream a_PrintStream){
//        if(getName() != "") a_PrintStream.println("<"+getName()+">");
//        a_PrintStream.println("<Identifiers>");
//        if(m_Identifiers != null) m_Identifiers.printXML(a_PrintStream);
//        a_PrintStream.println("</Identifiers>");
//        if(getName() != "") a_PrintStream.println("</"+getName()+">");
//    }
//    public void printRangeXML(PrintStream a_PrintStream){
//        if(getName() != "") a_PrintStream.println("<"+getName()+">");
//        a_PrintStream.println("<Range>");
//        if(m_Range != null) m_Range.printXML(a_PrintStream);
//        a_PrintStream.println("</Range>");
//        if(getName() != "") a_PrintStream.println("</"+getName()+">");
//    }
    protected void printXMLOpen(PrintStream a_PrintStream){
        String l_String_Line = String.format("<%1$s Asn1Type=\"%2$s\" Instance=\"%3$s\"",
                Asn1ModuleServer.getNameXMLElement(this.getClass()),Asn1ModuleServer.getNameASN1Type(this.getClass()),getNameInstance());
        if(m_Attributes != null){
            Map.Entry[] l_MapEntryArray = m_Attributes.entrySet().toArray(new Map.Entry[m_Attributes.size()]);
            for(Map.Entry l_MapEntry : l_MapEntryArray){
                l_String_Line = String.format("%1$s %2$s=\"%3$s\"",l_String_Line,l_MapEntry.getKey(),l_MapEntry.getValue());
            }
        }
        l_String_Line += ">";
        a_PrintStream.println(l_String_Line);
    }
//    protected void printXMLOpen(PrintStream a_PrintStream){
//        if(getName() != ""){
//            String l_String_Line = String.format("<%1$s Asn1Type=\"%2$s\"",getName(),Asn1ModuleServer.getASN1Name(this.getClass()));
//            if(m_Attributes != null){
//                Map.Entry[] l_MapEntryArray = m_Attributes.entrySet().toArray(new Map.Entry[m_Attributes.size()]);
//                for(Map.Entry l_MapEntry : l_MapEntryArray){
//                    l_String_Line = String.format("%1$s %2$s=\"%3$s\"",l_String_Line,l_MapEntry.getKey(),l_MapEntry.getValue());
//                }
//            }
//            l_String_Line += ">";
//            a_PrintStream.println(l_String_Line);
//        }
//    }
    protected void printXMLOpen(PrintStream a_PrintStream, Attributes a_Attributes){
        String l_String_Line = String.format("<%1$s Asn1Type=\"%2$s\" Instance=\"%3$s\"",
                Asn1ModuleServer.getNameXMLElement(this.getClass()),Asn1ModuleServer.getNameASN1Type(this.getClass()),getNameInstance());
        if(m_Attributes != null){
            Map.Entry[] l_MapEntryArray = m_Attributes.entrySet().toArray(new Map.Entry[m_Attributes.size()]);
            for(Map.Entry l_MapEntry : l_MapEntryArray){
                l_String_Line = String.format("%1$s %2$s=\"%3$s\"",l_String_Line,l_MapEntry.getKey(),l_MapEntry.getValue());
            }
        }
        if(a_Attributes != null){
            Map.Entry[] l_MapEntryArray = a_Attributes.entrySet().toArray(new Map.Entry[a_Attributes.size()]);
            for(Map.Entry l_MapEntry : l_MapEntryArray){
                l_String_Line = String.format("%1$s %2$s=\"%3$s\"",l_String_Line,l_MapEntry.getKey(),l_MapEntry.getValue());
            }
        }
        l_String_Line += ">";
        a_PrintStream.println(l_String_Line);
    }
//    protected void printXMLOpen(PrintStream a_PrintStream, Attributes a_Attributes){
//        if(getName() != ""){
//            String l_String_Line = String.format("<%1$s Asn1Type=\"%2$s\"",getName(),Asn1ModuleServer.getASN1Name(this.getClass()));
//            if(m_Attributes != null){
//                Map.Entry[] l_MapEntryArray = m_Attributes.entrySet().toArray(new Map.Entry[m_Attributes.size()]);
//                for(Map.Entry l_MapEntry : l_MapEntryArray){
//                    l_String_Line = String.format("%1$s %2$s=\"%3$s\"",l_String_Line,l_MapEntry.getKey(),l_MapEntry.getValue());
//                }
//            }
//            if(a_Attributes != null){
//                Map.Entry[] l_MapEntryArray = a_Attributes.entrySet().toArray(new Map.Entry[a_Attributes.size()]);
//                for(Map.Entry l_MapEntry : l_MapEntryArray){
//                    l_String_Line = String.format("%1$s %2$s=\"%3$s\"",l_String_Line,l_MapEntry.getKey(),l_MapEntry.getValue());
//                }
//            }
//            l_String_Line += ">";
//            a_PrintStream.println(l_String_Line);
//        }
//    }
    protected void printXMLClose(PrintStream a_PrintStream){
        a_PrintStream.println("</"+Asn1ModuleServer.getNameXMLElement(this.getClass())+">");
    }
    public void printXML(PrintStream a_PrintStream){
        printXMLOpen(a_PrintStream);
        if(m_byteArray_Data != null){
            String l_String_Line = Services.Bytes(m_byteArray_Data);
            //may need to add code to split the line into several shorter lines.
            a_PrintStream.println(l_String_Line);
        }
        printXMLClose(a_PrintStream);
    }
    public void printXML(PrintStream a_PrintStream, Attributes a_Attributes){
        printXMLOpen(a_PrintStream, a_Attributes);
        if(m_byteArray_Data != null){
            String l_String_Line = Services.Bytes(m_byteArray_Data);
            //may need to add code to split the line into several shorter lines.
            a_PrintStream.println(l_String_Line);
        }
        printXMLClose(a_PrintStream);
    }
    public Asn1Object MakeChoice(byte[] a_byteArray_Tag){
        return null;
    }
    public Integer getSequenceCount(){
        return null;
    }
    public Asn1Object getSequenceObject(Integer a_Integer){
        return null;
    }
    public Asn1Object getSequenceObject(String a_String){
        return null;
    }
    public Integer getSequenceOfCount(){
        return null;
    }
    public Asn1Object getSequenceOfObject(Integer a_Integer){
        return null;
    }
//    public void setANYDEFINEDBY(boolean a_boolean){
//        m_boolean_ANY = a_boolean;
//    }
//    public boolean isANYDEFINEDBY(){
//        return m_boolean_ANY;
//    }
//    public Integer getSizeFromIntegerRange(){
//        Integer l_Integer_Return = null;
//        if(IsInteger()){
//            BigInteger l_BigInteger_LowerBound = getIntegerRangeLowerBoundBigInteger();
//            BigInteger l_BigInteger_UpperBound = getIntegerRangeUpperBoundBigInteger();
//            if((l_BigInteger_LowerBound != null) && (l_BigInteger_LowerBound != null))
//                if((l_BigInteger_UpperBound.compareTo(new BigInteger("255")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("0")) == 0)) l_Integer_Return = 1;
//                else if((l_BigInteger_UpperBound.compareTo(new BigInteger("127")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("-128")) == 0)) l_Integer_Return = 1;
//                else if((l_BigInteger_UpperBound.compareTo(new BigInteger("65535")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("0")) == 0)) l_Integer_Return = 2;
//                else if((l_BigInteger_UpperBound.compareTo(new BigInteger("32767")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("-32768")) == 0)) l_Integer_Return = 2;
//                else if((l_BigInteger_UpperBound.compareTo(new BigInteger("4294967295")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("0")) == 0)) l_Integer_Return = 4;
//                else if((l_BigInteger_UpperBound.compareTo(new BigInteger("2147483647")) == 0) && (l_BigInteger_LowerBound.compareTo(new BigInteger("-2147483648")) == 0)) l_Integer_Return = 4;
//        }
//        return l_Integer_Return;
//    }
    public String getIdentifierValue(String a_String){
        return "";
    }
    public Asn1Object[] getIdentifierKeys(String a_String){
        return null;
    }
    public boolean setANYOption(Asn1Object a_Asn1Object){
        return false;
    }
    public boolean setANYArguments(ANYArguments a_ANYArguments){
        return false;
    }
    public Asn1Object getANYAsn1Object(){
        return new Asn1Object();
    }
//    static public Boolean addArgument(Node a_Node){
//        return false;
//    }
    public Asn1Object instantiateNextSequenceOfAsn1Object(){
        return null;
    }
    public Integer getFixedDataSize(){
        return null;
    }
//    public boolean setFixedDataSize(Integer a_Integer){
//        //m_Integer_FixedDataSize = a_Integer;
//        return false;
//    }
//    public Integer getSizeFromBitStringFixedDataSize(){
//        return null;
//    }
//    public Integer getSizeFromBitStringFixedDataSize(){
//        Integer l_Integer_Return = null;
//        if(m_Integer_FixedDataSize != null){
//            l_Integer_Return = m_Integer_FixedDataSize / 8;
//            if((m_Integer_FixedDataSize % 8) > 0) l_Integer_Return++;
//        }
//        return l_Integer_Return;
//    }
    public Attributes getAttributes(){
        return m_Attributes;
    }
    public void setAttributes(Attributes a_Attributes){
        m_Attributes = a_Attributes;
    }
    public String getSequenceOfClassNameASN1Name(){
        return "";
    }
    public boolean setSequenceOfClassNameASN1Name(String a_String){
        return false;
    }
    public Choices getChoices(){
        return null;
    }
    public boolean setChoices(Choices a_Choices){
        return false;
    }
    public byte[] getChoiceTag(){
        return null;
    }
    public Asn1Object getChoice(){
        return null;
    }
    public ANYArguments getANYArguments(){
        return null;
    }
    public Asn1Object getANYOption(){
        return null;
    }
//    protected Object clone() throws CloneNotSupportedException {
//        Asn1Object l_Asn1Object_Return = (Asn1Object)super.clone();
//        return l_Asn1Object_Return;
//    }
//    public Asn1Object(Asn1Object a_Asn1Object){
//        m_String_NameInstance = a_Asn1Object.m_String_NameInstance;
//        m_Attributes = null;
//        if(a_Asn1Object.m_Attributes != null) m_Attributes = (Attributes)a_Asn1Object.m_Attributes.clone();
//        m_byteArray_Data = null;
//        if(a_Asn1Object.m_byteArray_Data != null) m_byteArray_Data = a_Asn1Object.m_byteArray_Data.clone();
//    }
}
