package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1Lib.*;
import gov.nist.div897.MderLib.*;

import gov.nist.div897.Asn1ILib.*;

public class ProdSpecEntry extends SEQUENCE {
	static final private String m_String_NameAsn1Type="ProdSpecEntry";
	public ProdSpecEntry(){
		super();
		INTU16 spectype = new INTU16();
		spectype.setNameInstance("spec-type");
		Identifier[] m_IdentifierArray = {
			new Identifier(new INTU16("","0"),"unspecified"),
			new Identifier(new INTU16("","1"),"serial-number"),
			new Identifier(new INTU16("","2"),"part-number"),
			new Identifier(new INTU16("","3"),"hw-revision"),
			new Identifier(new INTU16("","4"),"sw-revision"),
			new Identifier(new INTU16("","5"),"fw-revision"),
			new Identifier(new INTU16("","6"),"protocol-revision"),
			new Identifier(new INTU16("","7"),"prod-spec-gmdn"),
		};
		spectype.setIdentifiers(new Identifiers(m_IdentifierArray));
		m_ArrayListAsn1Object.add(spectype);
		PrivateOid componentid = new PrivateOid();
		componentid.setNameInstance("component-id");
		m_ArrayListAsn1Object.add(componentid);
		OCTETSTRING prodspec = new OCTETSTRING();
		prodspec.setNameInstance("prod-spec");
		m_ArrayListAsn1Object.add(prodspec);

	}
	public ProdSpecEntry(String a_name){
		this();
		setNameInstance(a_name);
	}
	public ProdSpecEntry(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public ProdSpecEntry(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public ProdSpecEntry(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
