package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.INTU16;

public class AlertType extends INTU16 {
	static final private String m_String_NameAsn1Type="AlertType";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTU16("","255"),"signed-samples"),
		new Identifier(new INTU16("","0"),"other"),
		new Identifier(new INTU16("","1"),"low-pass"),
		new Identifier(new INTU16("","2"),"high-pass"),
		new Identifier(new INTU16("","3"),"notch"),
		new Identifier(new INTU16("","0"),"no-alert"),
		new Identifier(new INTU16("","1"),"low-pri-t-al"),
		new Identifier(new INTU16("","2"),"med-pri-t-al"),
		new Identifier(new INTU16("","4"),"hi-pri-t-al"),
		new Identifier(new INTU16("","256"),"low-pri-p-al"),
		new Identifier(new INTU16("","512"),"med-pri-p-al"),
		new Identifier(new INTU16("","1024"),"hi-pri-p-al"),
	};
	public AlertType(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));
	}
	public AlertType(String a_name){
		this();
		setNameInstance(a_name);
	}
	public AlertType(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public AlertType(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public AlertType(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
