package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.BITS16;
import gov.nist.div897.Asn1Lib.INTEGER;

public class AlertFlags extends BITS16 {
	static final private String m_String_NameAsn1Type="AlertFlags";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTEGER("","1"),"local-audible"),
		new Identifier(new INTEGER("","2"),"remote-audible"),
		new Identifier(new INTEGER("","3"),"visual-latching"),
		new Identifier(new INTEGER("","4"),"audible-latching"),
		new Identifier(new INTEGER("","6"),"derived"),
		new Identifier(new INTEGER("","8"),"record-inhibit"),
	};
	public AlertFlags(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));	
}
	public AlertFlags(String a_name){
		 this();
		 setNameInstance(a_name);
	}
	public AlertFlags(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public AlertFlags(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public AlertFlags(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
