package dataTypeInterface;

import java.math.BigDecimal;
import java.math.BigInteger;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1Lib.ANY;
import gov.nist.div897.Asn1Lib.BITSTRING;
import gov.nist.div897.Asn1Lib.CHOICE;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Asn1Lib.OCTETSTRING;
import gov.nist.div897.Asn1Lib.SEQUENCE;
import gov.nist.div897.Asn1Lib.SEQUENCEOF;
import gov.nist.div897.DimLib.FLOATType;
import gov.nist.div897.Services.Services;

import org.w3c.dom.Document;
import org.w3c.dom.Node;


public class NodeXmlDataType {
	static Document doc = null;
	
	static private Node getNode(Asn1Object asnObj){
		String nodeName;
		if(asnObj.getNameInstance().equals(""))
			nodeName = Asn1ModuleServer.getNameXMLElement(asnObj.getClass());
		else
			nodeName = asnObj.getNameInstance();
		return doc.createElement(nodeName);
	}
	
	static private Node NodeFromSequence(SEQUENCE sequence){
		Node node = getNode(sequence);
		for( int i = 0; i < sequence.getSequenceCount(); i++){
			Asn1Object asnObj = sequence.getSequenceObject(i);
			Node nodeSeq = NodeFromASN1Object(asnObj, null, false);
			if(nodeSeq != null)node.appendChild(nodeSeq);
		}		
		return node;
	}
	static private Node NodeFromSequenceOf(SEQUENCEOF sequenceOf){
		Node node = null;
		if(sequenceOf != null && sequenceOf.getSequenceOfCount()!= null){
			node = getNode(sequenceOf);
			for( int i = 0; i < sequenceOf.getSequenceOfCount(); i++){
				Asn1Object asnObj = sequenceOf.getSequenceOfObject(i);
				Node nodeSeq = NodeFromASN1Object(asnObj, null, false);
				if(nodeSeq != null)node.appendChild(nodeSeq);
			}
		}
		return node;
	}
	static private Node NodeFromInteger(INTEGER integer){
		Node node = getNode(integer);
		if(integer.getData() != null)
			node.setTextContent(fromINTEGERToString(integer));
		return node;
	}
	static private Node NodeFromBitString(BITSTRING bitString){
		Node node = getNode(bitString);
		if(bitString.getData() != null)
			node.setTextContent(Services.BinString(bitString.getData()));
		return node;
	}
	static private Node NodeFromOctetString(OCTETSTRING octetstring){
		Node node = getNode(octetstring);
		if(octetstring.getData() != null)
			node.setTextContent(Services.HexString(octetstring.getData()));
		return node;
	}
	static private Node NodeFromChoice(CHOICE choice){
		Node node = getNode(choice);
		if(choice.getChosenASN1Object() != null){
			Node node2 = NodeFromASN1Object(choice.getChosenASN1Object(), null, false);
			if(node2 != null)
				node.appendChild(node2);
		}
		return node;
	}
	static private Node NodeFromAny(ANY any){
		Node node = getNode(any);
		if(any.getData() != null)
			node.setTextContent(new String(any.getData()));
		return node;
	}
	static public Node NodeFromASN1Object(Asn1Object asnObj, Document docIn, boolean isRoot){
		if(docIn != null)
			doc = docIn;
		Node node = null;
		
		if (asnObj instanceof SEQUENCE) {
			SEQUENCE sequence = (SEQUENCE) asnObj;
			node = NodeFromSequence(sequence);
		}
		else if (asnObj instanceof SEQUENCEOF) {
			SEQUENCEOF sequenceof = (SEQUENCEOF) asnObj;
			node = NodeFromSequenceOf(sequenceof);
		}
		else if (asnObj instanceof INTEGER) {
			INTEGER integer = (INTEGER) asnObj;
			node = NodeFromInteger(integer);
		}
		else if (asnObj instanceof BITSTRING) {
			BITSTRING bitString = (BITSTRING) asnObj;
			node = NodeFromBitString(bitString);
		}
		else if (asnObj instanceof OCTETSTRING) {
			OCTETSTRING octetString = (OCTETSTRING) asnObj;
			node = NodeFromOctetString(octetString);
		}
		else if (asnObj instanceof CHOICE) {
			CHOICE choice = (CHOICE) asnObj;
			node = NodeFromChoice(choice);
		}
		else if (asnObj instanceof ANY) {
			ANY any = (ANY) asnObj;
			node = NodeFromAny(any);			
		}
		else{
			System.err.println("Error asn Object not recognized!");
		}
		if(isRoot && node != null && node.getNodeName()!= null){
		Node node2 = doc.createElement("dtp:"+node.getNodeName());
		for(int i = 0; i < node.getChildNodes().getLength(); i++)
			node2.appendChild(doc.importNode(node.getChildNodes().item(i), true));
		
		return node2;
		}
		else 
			return node;
	}
	
	static public String fromINTEGERToString(INTEGER integer){
		String ret = "";
		if (integer instanceof FLOATType) {
			ret = fromFLOATToString(integer);
			
		}
		else
		{
			byte[] byteVal = integer.getData().clone();
			if(byteVal != null && byteVal.length != 0){
				if((byteVal[byteVal.length - 1] & (byte)0x80) == (byte)0x80){
					//negative value
					for(int i=0; i<byteVal.length; i++){
						byteVal[i] ^= (byte)0xFF; 
					}
					BigInteger bigInt = new BigInteger(byteVal);
					bigInt = bigInt.add(BigInteger.ONE);
					bigInt = bigInt.negate();
					ret = bigInt.toString();
				}
				else
					ret = integer.getDataAsBigInteger().toString();
			}
		}
		return ret;
	}
	static public String fromFLOATToString(INTEGER integer){
		String ret = "";
		byte[] byteVal = integer.getData().clone();
		int exponent;
		BigInteger magnitude;
		if(byteVal != null && byteVal.length == 4){
			exponent = byteVal[0];
			byte[] byteTemp = new byte[3];
			for(int i = 0; i < 3; i++)
				byteTemp[i] = byteVal[i+1];
			magnitude = new BigInteger(byteTemp);
			
			BigDecimal bigDecObj = new BigDecimal(magnitude, exponent);
			
			ret = bigDecObj.toString();
		}	
		return ret;
	}
	static public byte[] fromFLOATToBytes(String strFloat){
		byte[] ret = new byte[4];
		BigDecimal bigDecObj = new BigDecimal(strFloat);
		int exponent = bigDecObj.scale();
		BigInteger magnitude = bigDecObj.unscaledValue();
		ret[0] = (byte)exponent;
		byte[] byteTemp = Services.toByteArray(3, "decimal", magnitude.toString());
		for(int i = 0; i < 3; i++){
			ret[i+1] = byteTemp[i];
		}
		return ret;		
	}
	
}
