package dataTypeInterface;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Asn1Lib.SEQUENCE;
import gov.nist.div897.Asn1Lib.SEQUENCEOF;
import gov.nist.div897.DimLib.CCOid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import addingsToAsnLib.ValidateAsnObject;


public class ComponentAsnSequenceOf implements IComponentAsn, ActionListener{

	SEQUENCEOF sequenceOf;
	JPanel panel;
	JPanel p1;
	Vector<IComponentAsn> vectComponents;
	JButton btnAdd;
	JButton btnRemove;
	CollapsablePanel colPanel;
	JLabel label;
	
	private void initComponents(){
		String toolTipText = Asn1ModuleServer.getNameASN1Type(sequenceOf.getClass());
		
		panel = new JPanel();
		colPanel = new CollapsablePanel();
		colPanel.setCollapsablePan(panel);
		
		panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
		//panel.setBorder(BorderFactory.createTitledBorder(sequenceOf.getNameInstance()));
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.LINE_AXIS));		
		
		label = new JLabel(sequenceOf.getNameInstance()+"::SEQ OF "+ sequenceOf.getSequenceOfCount()+" entries");
		label.setPreferredSize(new Dimension(90,0));
		label.setToolTipText(toolTipText);
		p.add(label);
		
		colPanel.setHeaderPan(p);
		
		JPanel p2 = new JPanel();
		JPanel p22 = new JPanel(new BorderLayout());
		p2.setLayout(new BoxLayout(p2, BoxLayout.LINE_AXIS));
		//p2.add(Box.createRigidArea(new Dimension(20,0)));
		
		btnAdd = new JButton("Add");
		btnAdd.addActionListener(this);
		btnAdd.setPreferredSize(new Dimension(90,16));
		btnRemove = new JButton("Remove");
		btnRemove.addActionListener(this);
		btnRemove.setPreferredSize(new Dimension(90,16));
		
		p2.add(btnAdd);
		p2.add(Box.createRigidArea(new Dimension(20,0)));
		p2.add(btnRemove);
		p2.add(Box.createRigidArea(new Dimension(20,0)));
		
		p22.add(p2, BorderLayout.WEST);
		panel.add(p22);
		panel.add(Box.createRigidArea(new Dimension(0,10)));
		
		p1 = new JPanel();
		
		p1.setBorder(BorderFactory.createEmptyBorder());
		
		p1.setLayout(new BoxLayout(p1, BoxLayout.PAGE_AXIS));
		
		for(int i = 0; i < sequenceOf.getSequenceOfCount(); i++){
			Asn1Object objAsn = sequenceOf.getSequenceOfObject(i);
			IComponentAsn comp = null;
			
			comp = ComponentAsnServer.instantiateAsnComponent(this, objAsn);
						
			if(comp != null){
				p1.add(comp.getComponent());
				//p1.add(Box.createRigidArea(new Dimension(20,0)));
				
				vectComponents.add(comp);
			}
		}
		panel.add(p1);
		panel.add(Box.createRigidArea(new Dimension(0,10)));
		
	}
	
	public ComponentAsnSequenceOf(SEQUENCEOF asnObj){
		sequenceOf = asnObj;
		vectComponents = new Vector<IComponentAsn>();
		initComponents();
	}
	
	public boolean saveData() {
		boolean ret = true;
		String error = "";
		for(int i = 0; i < vectComponents.size(); i++){
			IComponentAsn compAsn = (IComponentAsn)vectComponents.get(i);
			compAsn.getAsn1Object().setNameInstance("");
			if(!compAsn.saveData()){
				ret = false;
				error = error.concat(ValidateAsnObject.getErrorMessage());
			}
		}
		ValidateAsnObject.setErrorMessage(error);
		return ret;
	}

	public void updateDataComp() {
		for(int i = 0; i < vectComponents.size(); i++){
			IComponentAsn compAsn = (IComponentAsn)vectComponents.get(i);
			compAsn.updateDataComp();
		}
		
	}

	public Component getComponent() {
		return colPanel;
	}

	public void actionPerformed(ActionEvent arg0) {
		if(arg0.getSource() == btnAdd){
			sequenceOf.instantiateNextSequenceOfAsn1Object();
			Asn1Object objAsn = sequenceOf.getSequenceOfObject(sequenceOf.getSequenceOfCount() - 1);
			objAsn.setNameInstance("#"+sequenceOf.getSequenceOfCount());
			IComponentAsn comp = null;
			
			comp = ComponentAsnServer.instantiateAsnComponent(this, objAsn);
			
			if(comp != null){
				p1.add(comp.getComponent());
				p1.add(Box.createRigidArea(new Dimension(20,0)));
				
				vectComponents.add(comp);
				label.setText(sequenceOf.getNameInstance()+"::SEQ OF "+ sequenceOf.getSequenceOfCount()+ " entries");
				
				panel.updateUI();
			}
			
		}
		else if(arg0.getSource() == btnRemove){
			if(sequenceOf.getSequenceOfCount() > 0){
				sequenceOf.removeLastSequenceOfAsn1Object();
				IComponentAsn asnComp = (IComponentAsn) vectComponents.get(vectComponents.size() - 1);
				p1.remove(asnComp.getComponent());
				vectComponents.remove(asnComp);
				label.setText(sequenceOf.getNameInstance()+"::SEQ OF "+ sequenceOf.getSequenceOfCount()+ " entries");
				panel.updateUI();
			}
		}		
	}

	public Asn1Object getAsn1Object() {
		return sequenceOf;
	}
	

}
