package dataTypeInterface;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1Lib.OCTETSTRING;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import addingsToAsnLib.ValidateAsnObject;

public class ComponentAsnOctetString implements IComponentAsn{

	OCTETSTRING octetString;
	JTextField txtFd = null;
	JPanel panel = null;
	
	public ComponentAsnOctetString(OCTETSTRING asnObj){
		octetString = asnObj;
		initComponent();
	}
	public void initComponent(){
		panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
		panel.setBorder(BorderFactory.createEmptyBorder(2,10,2,10));
		//panel.add(Box.createRigidArea(new Dimension(10,0)));
		String toolTipText = Asn1ModuleServer.getNameASN1Type(octetString.getClass());
		String labelText = octetString.getNameInstance();
		if(labelText.equals(""))
			labelText = toolTipText;
		JLabel label = new JLabel(labelText);
		label.setToolTipText(toolTipText);
		label.setPreferredSize(new Dimension(100,0));
		panel.add(label);
		panel.add(Box.createRigidArea(new Dimension(10,0)));
		txtFd = new JTextField();
		txtFd.setToolTipText(toolTipText);
		panel.add(txtFd);
		//panel.add(Box.createRigidArea(new Dimension(10,0)));
	}
	public boolean saveData() {
		boolean ret = true;
		if(!ValidateAsnObject.isValid(octetString,txtFd.getText())){
			ret = false;
		}
		else
			octetString.setData(txtFd.getText());
		return ret;
	}

	public void updateDataComp() {
		byte[]data = octetString.getData();
		if(data != null)
			txtFd.setText(new String(data));
		
	}

	public Component getComponent() {
		return panel;
	}
	
	public Asn1Object getAsn1Object() {
		return octetString;
	}

}
