package dataTypeInterface;

import java.awt.Component;
import java.awt.Dimension;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.DimLib.FLOATType;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import addingsToAsnLib.NodeXmlDataType;
import addingsToAsnLib.ValidateAsnObject;

public class ComponentAsnInteger implements IComponentAsn{
	JTextField txtFd = null;
	JComboBox cbBox = null;
	JPanel panel = null;
	
	INTEGER integer = null;
	
	public ComponentAsnInteger(INTEGER a_integer){
		integer = a_integer;
		initComponents();
	}

	private void initComponents(){
		Identifiers identifiers = integer.getIdentifiers();
		
		panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
		//panel.add(Box.createRigidArea(new Dimension(10,0)));
		panel.setBorder(BorderFactory.createEmptyBorder(2,10,2,10));
		
		String toolTipText = Asn1ModuleServer.getNameASN1Type(integer.getClass());
		
		String labelText = integer.getNameInstance();
		if(labelText.equals(""))
			labelText = toolTipText;
		
		JLabel label = new JLabel(labelText);
		label.setPreferredSize(new Dimension(100,0));
		label.setToolTipText(toolTipText);
		
		panel.add(label);
		panel.add(Box.createRigidArea(new Dimension(10,0)));
		// no identifiers
		if(identifiers == null || identifiers.isEmpty()){
			txtFd = new JTextField();
			txtFd.setToolTipText(toolTipText);
			panel.add(txtFd);
		}
		// identifiers exist
		else{
			Vector<String> vect = new Vector<String>();
			for (Iterator iter = identifiers.keySet().iterator(); iter.hasNext();) {
				INTEGER element = (INTEGER) iter.next();
				BigInteger key = element.getDataAsBigInteger();
				String value = identifiers.get(element);
				value += "("+key.toString()+")";
				vect.add(value);
			}
			Collections.sort(vect);
			cbBox = new JComboBox(vect);
			panel.add(cbBox);
		}
		//panel.add(Box.createRigidArea(new Dimension(10,0)));
	}
	public boolean saveData() {
		boolean ret = true;
		if(txtFd != null){
			if(!ValidateAsnObject.isValid(integer,txtFd.getText())){
				ret = false;
			}
			else if (integer instanceof FLOATType) {
				integer.setData(NodeXmlDataType.fromFLOATToBytes(txtFd.getText()));
			}
			else{
				integer.setData(txtFd.getText());					
			}
		}
		else{
			String val = null;
			if(cbBox.getSelectedIndex() != -1){
				val = cbBox.getSelectedItem().toString();
				val = val.substring(0, val.indexOf("("));
				integer.setData(getIdentifierKey(val));
			}
			else{
				ret = ValidateAsnObject.isValid(integer,val);
			}
		}
		return ret;
	}

	public void updateDataComp() {
		String value = "";
		try{
			value = NodeXmlDataType.fromINTEGERToString(integer);
		}
		catch(Exception e){}
		if(txtFd != null){
			txtFd.setText(value);
		}
		else if(cbBox != null){
			if(value != ""){
				String text = getIdentifierValue(value);
				cbBox.setSelectedItem(text + "("+value+")");
			}
			else
				cbBox.setSelectedIndex(-1);
		}
		
		
	}

	public Component getComponent() {
		return panel;
	}
	
	private String getIdentifierValue(String key){
		String value = "";
		Identifiers identifiers = integer.getIdentifiers();
		
		for (Iterator iter = identifiers.keySet().iterator(); iter.hasNext();) {
			INTEGER element = (INTEGER) iter.next();
			if(element.getDataAsBigInteger().equals(new BigInteger(key)))
				value = identifiers.get(element);
		}
			
		return value;
	}
	
	private String getIdentifierKey(String val){
		String key = "-1";
		Identifiers identifiers = integer.getIdentifiers();
		for (Iterator iter = identifiers.keySet().iterator(); iter.hasNext();) {
			INTEGER element = (INTEGER) iter.next();
			if(identifiers.get(element).equals(val))
				key = element.getDataAsBigInteger().toString();
		}
		return key;
	}
	
	public Asn1Object getAsn1Object() {
		return integer;
	}

}
