package dataTypeInterface;
import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.Asn1Lib.BITSTRING;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Services.Services;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import addingsToAsnLib.ValidateAsnObject;

public class ComponentAsnBitString implements IComponentAsn, ActionListener{
	JPanel panel;
	Vector<JCheckBox> vectChkBoxes;
	JTextField txtFd;
	BITSTRING bitString = null;
	CollapsablePanel colPanel;
	public ComponentAsnBitString(BITSTRING asnObj){
		bitString = asnObj;
		colPanel = new CollapsablePanel();
		initComponents();
		colPanel.setCollapsablePan(panel);
	}
	
	private void initComponents(){
		Identifiers identifiers = bitString.getIdentifiers();
		
		panel = new JPanel();
		String toolTipText = Asn1ModuleServer.getNameASN1Type(bitString.getClass());
		String labelName = bitString.getNameInstance();
		if(labelName.equals(""))
			labelName = toolTipText;
		
		// no identifiers
		if(identifiers == null || identifiers.isEmpty()){
			panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));
			//panel.add(Box.createRigidArea(new Dimension(10,0)));
			
			JLabel label = new JLabel(labelName);
			label.setPreferredSize(new Dimension(100,0));
			label.setToolTipText(toolTipText);
			panel.add(label);
			panel.add(Box.createRigidArea(new Dimension(10,0)));
			txtFd = new JTextField();
			txtFd.setToolTipText(toolTipText);
			panel.add(txtFd);
		}
		// identifiers exist
		else{
			vectChkBoxes = new Vector<JCheckBox>();
			//panel.setBorder(BorderFactory.createTitledBorder(bitString.getNameInstance()));
			panel.setLayout(new BoxLayout(panel, BoxLayout.PAGE_AXIS));
			
			JPanel p = new JPanel();
			//p.add(Box.createRigidArea(new Dimension(20,0)));
			p.setLayout(new BoxLayout(p, BoxLayout.LINE_AXIS));		
			//p.add(Box.createRigidArea(new Dimension(10,0)));
			
			JLabel label = new JLabel(labelName);
			label.setPreferredSize(new Dimension(90,0));
			label.setToolTipText(toolTipText);
			p.add(label);
			p.add(Box.createRigidArea(new Dimension(10,0)));
			txtFd = new JTextField();
			txtFd.setEditable(false);
			txtFd.setToolTipText(toolTipText);
			p.add(txtFd);
			p.add(Box.createRigidArea(new Dimension(10,0)));
			colPanel.setHeaderPan(p);
			
			
			initGrpChkBoxes();
			
			
		}	
		
	}
	private void initGrpChkBoxes(){
		Identifiers identifiers = bitString.getIdentifiers();
		Collection<String> values = identifiers.values();
		ArrayList<String> list = new ArrayList<String> (values);
		Collections.sort(list);
		JPanel p2 = new JPanel();
		p2.setLayout(new GridLayout(0,2));
		
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			JPanel p = new JPanel();
			//p.add(Box.createRigidArea(new Dimension(20,0)));
			p.setLayout(new BorderLayout());
			p.setBorder(BorderFactory.createEmptyBorder(0,10,0,10));
			String val = (String) iter.next();
			val += "("+getIdentifierKey(val)+")";
			JCheckBox chkBox = new JCheckBox(val);
			chkBox.addActionListener(this);
			chkBox.setSelected(false);
			p.add(chkBox, BorderLayout.WEST);
			p.add(Box.createRigidArea(new Dimension(10,0)));
			vectChkBoxes.add(chkBox);
			p2.add(p);
		}
		panel.add(p2);
	}
	public boolean saveData() {
		boolean ret = true;
		if(vectChkBoxes != null){
			bitString.setData(getValue());
		}
		else if(!ValidateAsnObject.isValid(bitString,txtFd.getText())){
			ret = false;
		}
		else
			bitString.setData(txtFd.getText().getBytes());
		return ret;
		
	}

	public void updateDataComp() {
		byte[] byteArray = bitString.getData();
		if(vectChkBoxes != null){
		for(int k = 0; k < vectChkBoxes.size(); k++){
			(vectChkBoxes.get(k)).setSelected(false);
		}
		
		if(byteArray != null){
			for(int i = 0; i < byteArray.length; i++){
				for(int j = 0; j < 8; j++){
					if((byte)(byteArray[i] & (byte)Math.pow(2, 8 - j -1))== (byte)Math.pow(2, 8 - j - 1)){
						// the bit is set up
						int key = i*8+j;
						String value = getIdentifierValue(key+"")+"("+key+")";
						if(value != ""){
							for(int k = 0; k < vectChkBoxes.size(); k++){
								if((vectChkBoxes.get(k)).getText().equals(value))
									(vectChkBoxes.get(k)).setSelected(true);
							}
						}
					}
				}
			}
		}
		}
		if(byteArray != null)
			txtFd.setText(Services.Bytes(byteArray));
		
	}

	public Component getComponent() {
		return colPanel;
	}
	
	private String getIdentifierValue(String key){
		String value = "";
		Identifiers identifiers = bitString.getIdentifiers();
		
		for (Iterator iter = identifiers.keySet().iterator(); iter.hasNext();) {
			INTEGER element = (INTEGER) iter.next();
			if(element.getDataAsBigInteger().equals(new BigInteger(key)))
				value = identifiers.get(element);
		}
			
		return value;
	}
	
	private String getIdentifierKey(String val){
		String key = "-1";
		Identifiers identifiers = bitString.getIdentifiers();
		for (Iterator iter = identifiers.keySet().iterator(); iter.hasNext();) {
			INTEGER element = (INTEGER) iter.next();
			if(identifiers.get(element).equals(val))
				key = element.getDataAsBigInteger().toString();
		}
		return key;
	}

	public void actionPerformed(ActionEvent arg0) {
		for(int i = 0; i < vectChkBoxes.size(); i++){
			JCheckBox chkBox = (JCheckBox) vectChkBoxes.get(i);
			if(arg0.getSource() == chkBox){
				txtFd.setText(Services.Bytes(getValue()));
			}
		}
		
	}
	
	private byte[] getValue(){
		byte[] byteArray = new byte[bitString.getFixedDataSize()];
		for(int i = 0; i < byteArray.length; i++){
			byteArray[i] = (byte)0x00;
		}
		for(int i = 0; i < vectChkBoxes.size(); i++){
			JCheckBox chBox = vectChkBoxes.get(i);			
			if(chBox.isSelected()){
				String val = chBox.getText();
				val = val.substring(0, val.indexOf("("));
				BigInteger integer = new BigInteger(getIdentifierKey(val));
				
				int index = integer.intValue()% 8 + 1;
				byte byteObj = byteArray[integer.intValue()/8];
				byteObj =(byte)( byteObj | (int)(Math.pow(2,8 - index)));
				byteArray[integer.intValue()/8] = byteObj;
			}
		}
		return byteArray;
	}
	
	public Asn1Object getAsn1Object() {
		return bitString;
	}

}
