package addingsToAsnLib;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1Lib.ANY;
import gov.nist.div897.Asn1Lib.BITSTRING;
import gov.nist.div897.Asn1Lib.CHOICE;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Asn1Lib.OCTETSTRING;
import gov.nist.div897.Asn1Lib.SEQUENCE;
import gov.nist.div897.Asn1Lib.SEQUENCEOF;
import gov.nist.div897.DimLib.FLOATType;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import dataTypeInterface.Configuration;
import dataTypeInterface.XMlXSLTClass;

public class ParseXmlDataType {
	static void parseSequence(Node node, SEQUENCE sequence){
		if(node.hasChildNodes()){
    		NodeList l_NodeList = node.getChildNodes();
    		int k = 0;
    		for(int i = 0; i < l_NodeList.getLength() && k < sequence.getSequenceCount(); i++){
    			Node l_Node = l_NodeList.item(i);
    			if(l_Node.getNodeType() == Node.ELEMENT_NODE){
	    			Asn1Object l_Asn1Object = (Asn1Object)sequence.getSequenceObject(k);
	    			if(l_Asn1Object.getNameInstance() == l_Node.getNodeName()){
	    				parseASN1Object(l_Node, l_Asn1Object);
	    				k++;
	    			}
    			}
    		}
    	}
	}
	static void parseSequenceOf(Node node, SEQUENCEOF sequenceOf){
		if(node.hasChildNodes()){
    		NodeList l_NodeList = node.getChildNodes();
    		for(int i = 0; i < l_NodeList.getLength(); i++){
    			Node l_Node = l_NodeList.item(i);
    			if(l_Node.getNodeType() == Node.ELEMENT_NODE){
	    			Asn1Object l_Asn1Object = (Asn1Object)sequenceOf.instantiateNextSequenceOfAsn1Object();
	    				parseASN1Object(l_Node, l_Asn1Object);
    			}
    		}
    	}
	}
	static void parseInteger(Node node, INTEGER integer){
		String val = node.getTextContent().replaceAll("\n","").trim();
		if(val != null && !val.equals(""))
			if (integer instanceof FLOATType) {
				integer.setData(NodeXmlDataType.fromFLOATToBytes(val));				
			}
			else
				integer.setData(new BigInteger(val).toByteArray());
	}
	static void parseBitString(Node node, BITSTRING bitString){
		String val = node.getTextContent().replaceAll("\n","").trim();
		if(val != null && !val.equals("")){
			char[] charArray = val.toCharArray();
			BitSet bitSet = new BitSet(charArray.length);
			bitSet.clear();
			for(int i = 0; i < charArray.length; i++){
				if(charArray[i]== '1'){
					bitSet.set(charArray.length - 1 - i);
				}
			}
			bitString.setData(toByteArray(bitSet));
		}
	}
	static void parseOctetString(Node node, OCTETSTRING octetstring){
		String val = node.getTextContent().replaceAll("\n","").trim();
		if(val != null && !val.equals(""))
			//octetstring.setData(val.getBytes());
			octetstring.setData(new BigInteger(val,16).toByteArray());
	}
	static void parseChoice(Node node, CHOICE choice){
		if(node.hasChildNodes()){
    		NodeList l_NodeList = node.getChildNodes();
    		int k = 0;
    		for(int i = 0; i < l_NodeList.getLength() && k < 1; i++){
    			Node l_Node = l_NodeList.item(i);
    			if(l_Node.getNodeType() == Node.ELEMENT_NODE){
	    	Set l_Set = choice.getChoices().entrySet();
	        for (Iterator l_Iterator = l_Set.iterator(); l_Iterator.hasNext();) {
	            Map.Entry l_MapEntry = (Map.Entry)l_Iterator.next();
	            Asn1Object l_Asn1Object = (Asn1Object)l_MapEntry.getKey();
	            if(l_Asn1Object.getNameInstance().equals(l_Node.getNodeName())){
	            	choice.MakeChoice(l_Asn1Object.getData());
	            	parseASN1Object(l_Node, choice.getChosenASN1Object());
	            	k++;
	            }
	        }
    			}
    		}
    	}
	}
	static void parseAny(Node node, ANY any){
		String val = node.getTextContent().replaceAll("\n","").trim();
		if(val != null && !val.equals(""))
			any.setData(val.getBytes());
	}
	static public void parseASN1Object(Node node, Asn1Object asnObj){
		if (asnObj instanceof SEQUENCE) {
			SEQUENCE sequence = (SEQUENCE) asnObj;
			parseSequence(node, sequence);
		}
		if (asnObj instanceof SEQUENCEOF) {
			SEQUENCEOF sequenceof = (SEQUENCEOF) asnObj;
			parseSequenceOf(node, sequenceof);
		}
		if (asnObj instanceof INTEGER) {
			INTEGER integer = (INTEGER) asnObj;
			parseInteger(node, integer);
		}
		if (asnObj instanceof BITSTRING) {
			BITSTRING bitString = (BITSTRING) asnObj;
			parseBitString(node, bitString);
		}
		if (asnObj instanceof OCTETSTRING) {
			OCTETSTRING octetString = (OCTETSTRING) asnObj;
			parseOctetString(node, octetString);
		}
		if (asnObj instanceof CHOICE) {
			CHOICE choice = (CHOICE) asnObj;
			parseChoice(node, choice);
		}
		if (asnObj instanceof ANY) {
			ANY any = (ANY) asnObj;
			parseAny(node, any);
			
		}
	}
	public static Asn1Object parseASN1ObjectNode(Node node){
		String typeName  = node.getNodeName().replace("dtp:","");
		typeName = typeName.replaceAll("_", "");
		
		Asn1Object asnObj = Asn1ModuleServer.instantiateAsn1Object(typeName);
		
		parseASN1Object(node, asnObj);
		
		return asnObj;
	}
	
	public static void main(String[] args) {
		Configuration l_Configuration = new Configuration("c:/ConfigurationFiles/Test07.xml");
        
        //Load Asn1Modules
        String[] l_StringArray_Asn1ModulePaths = l_Configuration.getAsn1ModulePaths();
        String[] l_StringArray_Asn1ModuleArgumentsPaths = l_Configuration.getAsn1ModuleArgumentsPaths();
        Asn1ModuleServer.initialize(System.out,l_StringArray_Asn1ModulePaths,l_StringArray_Asn1ModuleArgumentsPaths);
        
        
		XMlXSLTClass xmlClass = new XMlXSLTClass();
		String fileName = "C:\\Documents and Settings\\mcherk\\Desktop\\Tests\\data_types\\Dest.xml";
		Document doc = xmlClass.readXMLFile(fileName);
		Node root = doc.getDocumentElement();
		NodeList listNodes = root.getChildNodes();
		
		Vector<Asn1Object> vectAsnObj = new Vector<Asn1Object>();
		
		for(int i = 0; i < listNodes.getLength(); i++){
			Node child = listNodes.item(i);
			if(child.getNodeType() == Node.ELEMENT_NODE){
				vectAsnObj.add(ParseXmlDataType.parseASN1ObjectNode(child));
			}
		}
		
		for(int i = 0; i < vectAsnObj.size(); i++){
			vectAsnObj.get(i).printXML(System.out);
		}
		
		
		
	}
	
	 public static byte[] toByteArray(BitSet bits) {
	        byte[] bytes = new byte[bits.length()/8+1];
	        for (int i=0; i<bits.length(); i++) {
	            if (bits.get(i)) {
	                bytes[bytes.length-i/8-1] |= 1<<(i%8);
	            }
	        }
	        return bytes;
	    }
}
