package icsTables;

import icsDyn.ICSManagementView;
import java.awt.Color;
import javax.swing.JFrame;
import org.w3c.dom.*;

/**
 * This class represents the window for selecting ICS Tables
 * @author MC
 */
public class ICSSelectorFrame extends javax.swing.JFrame 
{
	private static final long serialVersionUID = 1L;
	protected String strXMLFile = "";
	/**
	 * the document that represents the JTree
	 */
	protected Document doc = null; 
	/**
	 * the document that reprents the GeneralICS Table
	 */
    protected Document docGeneral = null;
    /**
     * the document that represents the ServiceICS Table
     */
    protected Document docService = null;
    /**
     * the parent view
     */
    protected ICSManagementView parent;
    
    /** Creates new form Choice 
     * @param file hte xml file containing data for ICS Tables
     * */
    public ICSSelectorFrame(String file) {
    	strXMLFile = file;
        initComponents();        
        jRBtnTable2.setEnabled(false);
    }
    
    /**
     * Creates new form Choice
     * @param docIn dom document containing the data for ICS Tables
     */
    public ICSSelectorFrame(ICSManagementView parentIn, Document docIn, Document docGeneralIn, Document docServiceIn )
    {
    	doc = docIn;
        docGeneral = docGeneralIn;
        docService = docServiceIn;
        parent = parentIn;
    	
    	initComponents();
        
        if(docGeneral == null)
            jRBtnTable1.setEnabled(false);
        if(docService == null)
            jRBtnTable2.setEnabled(false);
        if(doc == null){
        	jRBtnTable3.setEnabled(false);
        	jRBtnTable4.setEnabled(false);
        	jRBtnTable5.setEnabled(false);
        	jRBtnTable6.setEnabled(false);
        }
        
         setLocationRelativeTo( parent );
        
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * 
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jRBtnTable1 = new javax.swing.JRadioButton();
        jRBtnTable2 = new javax.swing.JRadioButton();
        jRBtnTable3 = new javax.swing.JRadioButton();
        jRBtnTable4 = new javax.swing.JRadioButton();
        jRBtnTable5 = new javax.swing.JRadioButton();
        jRBtnTable6 = new javax.swing.JRadioButton();
        jPanel2 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("ICS Tables selection");
        setResizable(false);
        jLabel1.setText("<html>   ICSs (Implementation Conformance Statements)<br>   discloses a specific implementation and specifies</br><br>   which features are provided</br><br>  </br></html>");
        jLabel1.setBorder(javax.swing.BorderFactory.createTitledBorder("ICS Tables"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 10);
        getContentPane().add(jLabel1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridLayout(6, 0, 5, 0));

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Select ICS Tables"));
        jRBtnTable1.setText("Table 10.1-- General ICS");
        jRBtnTable1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 5, 0));
        jRBtnTable1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jRBtnTable1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jPanel1.add(jRBtnTable1);

        jRBtnTable2.setText("Table 10.2-- Service Support ICS");
        jRBtnTable2.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 5, 0));
        jRBtnTable2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jRBtnTable2.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jPanel1.add(jRBtnTable2);

        jRBtnTable3.setText("Table 10.3--Template for DIM MOC ICS");
        jRBtnTable3.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 5, 0));
        jRBtnTable3.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jRBtnTable3.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jPanel1.add(jRBtnTable3);

        jRBtnTable4.setText("Table 10.4--Template for MOC Attribute ICS");
        jRBtnTable4.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 5, 0));
        jRBtnTable4.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jRBtnTable4.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jPanel1.add(jRBtnTable4);

        jRBtnTable5.setText("Table 10.5--Template for MOC Behavior ICS");
        jRBtnTable5.setAlignmentX(10.0F);
        jRBtnTable5.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 5, 0));
        jRBtnTable5.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jRBtnTable5.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jPanel1.add(jRBtnTable5);

        jRBtnTable6.setText("Table 10.6--Template for MOC Notification ICS");
        jRBtnTable6.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 5, 0));
        jRBtnTable6.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jRBtnTable6.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jPanel1.add(jRBtnTable6);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        getContentPane().add(jPanel1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridLayout(1, 2, 60, 20));

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        jButton1.setText("OK");
        jButton1.setBackground(new Color(204, 204, 255));
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                handlerOKPressed(evt);
            }
        });

        jPanel2.add(jButton1);

        jButton2.setText("Cancel");
        jButton2.setBackground(new Color(204, 204, 255));
        jButton2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                handlerCancelPressed(evt);
            }
        });
        jPanel2.add(jButton2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        getContentPane().add(jPanel2, gridBagConstraints);
        
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
       
        setBackground(new Color(236,233,216));

        pack();
    }

    /**
     * handlerOKPressed
     * @param evt java.awt.event.MouseEvent
     */
    private void handlerOKPressed(java.awt.event.MouseEvent evt) {
    	boolean tab[] = new boolean [6];
    	for( int i = 0; i < 6; i++ )
    		tab[i] = false;
    	
        if( jRBtnTable1.isSelected() == true )
            tab[0] = true;
        if( jRBtnTable2.isSelected() == true )
            tab[1] = true;
        if( jRBtnTable3.isSelected() == true )
            tab[2] = true;
        if( jRBtnTable4.isSelected() == true )
            tab[3] = true;
        if( jRBtnTable5.isSelected() == true )
            tab[5] = true;
        if( jRBtnTable6.isSelected() == true )
            tab[4] = true;
        
         
            new ICSFrame(parent, doc, docGeneral, docService ,tab).setVisible(true);
//            else if(strXMLFile != "")
//                    new ICSFrame(parent, strXMLFile ,tab).setVisible(true);
        dispose();
    }
       
    
    /**
     * handlerCancelPressed
     * @param evt java.awt.event.MouseEvent
     */
    private void handlerCancelPressed(java.awt.event.MouseEvent evt) {
    	dispose();
    }
    
    // Variables declaration
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton jRBtnTable1;
    private javax.swing.JRadioButton jRBtnTable2;
    private javax.swing.JRadioButton jRBtnTable3;
    private javax.swing.JRadioButton jRBtnTable4;
    private javax.swing.JRadioButton jRBtnTable5;
    private javax.swing.JRadioButton jRBtnTable6;
    // End of variables declaration
    
}
