
package icsDyn;
import java.util.Vector;

/**
 * This class models a MOC object
 * @author MC
 *
 */
public class MOCNode extends DIMMOC {

   public Vector<AttributeNode> vAttribute;
   private Vector<BehaviourNode> vBehaviour;
   private Vector<NotificationNode> vNotification;

   public MOCNode() {
      vAttribute = new Vector<AttributeNode>();
      vBehaviour = new Vector<BehaviourNode>();
      vNotification = new Vector<NotificationNode>();
      
      object_name               = "";
      mocIdNumber               = 0;
      object_name_label         = "";
      object_id                 = "";
      moc_termcode              = "";
      moc_services_supported    = "";
      moc_comment		= "";
      moc_restrictions		= "";
      moc_ref                   = "";
      status                    = "";
      attribute_name            = "";
      attr_grpname              = "";
      attr_grpid                = "";  
      attr_grptermcode          = ""; 
      attr_derivedfrom          = "";
      attr_keynum               = 0; 
      attribute_id              = "";
      attribute_type            = "";
      attr_ref                  = "";
      attr_qual                 = "";
      attr_status               = "";
      attr_access               = "";
      attr_value_range          = "";
      attr_restrictions         = "";
      attr_application_guidance = "";
      attr_comment              = "";
   }
  
   public MOCNode(MOCNode mn) {
      this();
      object_name               = mn.getObjectName();
      mocIdNumber               = mn.getMocIdNumber();
      object_name_label         = mn.getObjectNameLabel();
      object_id                 = mn.getObjectId();
      moc_termcode              = mn.getMocTermCode();
      moc_services_supported    = mn.getMocServicesSupported();
      moc_comment		= mn.getMocComment();
      moc_restrictions		= mn.getMocRestrictions();
      moc_ref                   = mn.getReference();
      status                    = mn.getStatus();
      attribute_name            = mn.getAttributeName();
      attr_grpname              = mn.getAttributeGroupName();
      attr_grpid                = mn.getAttributeGroupId();  
      attr_grptermcode          = mn.getAttributeGroupTermCode(); 
      attr_derivedfrom          = mn.getAttributeDerivedFrom();
      attr_keynum               = mn.getAttributeKeyNumber(); 
      attribute_id              = mn.getAttributeId();
      attribute_type            = mn.getAttributeType();
      attr_ref                  = mn.getAttributeReference();
      attr_qual                 = mn.getAttributeQual();
      attr_status               = mn.getAttributeStatus();
      attr_access               = mn.getAttributeAccess();
      attr_value_range          = mn.getAttributeValueRange();
      attr_restrictions         = mn.getAttributeRestrictions();
      attr_application_guidance = mn.getAttributeApplicationGuidance();
      attr_comment              = mn.getAttributeComment();
      isPrivate 				= mn.isPrivate;
      
   }
   
   public String toString() {
      return object_name;
   }

   public Vector<AttributeNode> getAttribute() {
      return vAttribute;
   }

   public Vector<BehaviourNode> getBehaviour() {
      return vBehaviour;
   }

   public Vector<NotificationNode> getNotification() {
      return vNotification;
   }

   public void addAttribute(AttributeNode attribute) {
      if (attribute != null) {
         vAttribute.add(attribute);
      }
   }

   public void addBehaviour(BehaviourNode behaviour) {
      if (behaviour != null) {
         vBehaviour.add(behaviour);
      }
   }

   public void addNotification(NotificationNode notification) {
      if (notification != null) {
         vNotification.add(notification);
      }
   }

}
