<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" indent="yes"/>	
	<xsl:template match="/">
		<Table>
			<xsl:for-each select="//OBJECT_NAME">
     				<xsl:sort select="../OBJECT_NAME"/>   
					<tr>
						<xsl:if test= "string(name(..))='Private-MOC'">
							<Private>true</Private>
						</xsl:if>
						<xsl:comment>computing row index</xsl:comment>
     					<td>MOC-<xsl:value-of select="position()"/></td>
       					<td><b><xsl:value-of select="../OBJECT_NAME"/></b><br>
       					<xsl:value-of select="../OBJECT_ID"/></br></td>
      					<td align="center"><xsl:value-of select="substring-after(../Reference, 'clause')"/></td>
      					<td>Implemented</td>
      					<td><xsl:value-of select="../MOC_RESTRICTIONS"/></td>
      					<td><xsl:value-of select="../MOC_COMMENT"/></td>
     				</tr>
     		 </xsl:for-each>
		</Table>
	</xsl:template>
</xsl:stylesheet>
