/*
 * Asn1ModuleServer.java
 *
 * Created on November 21, 2006, 11:27 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package gov.nist.div897.Asn1ILib;
import java.io.*;
import java.net.URL;
import java.util.*;
import gov.nist.div897.Services.*;
import java.lang.reflect.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

/**
 *
 * @author rtheimer
 */
public class Asn1ModuleServer {
    static private boolean m_boolean_Initialized = false;
    static private PrintStream m_PrintStream = System.out;
    static private ArrayList<URL> m_ArrayListURL_Asn1ModuleURLs;
    //static private ArrayList<String> m_ArrayListString_Asn1ModuleArgumentsPaths;
    static private ArrayList<Class> m_ArrayListClass_Asn1ObjectClasses;
    //static private ArrayList<Class> m_ArrayListClass_Asn1ModuleClasses;
    static private HashMap<String,Class> m_HashMapStringClass_Asn1ObjectClasses;
    /** Creates a new instance of Asn1ModuleServer */
    public Asn1ModuleServer() {
    }
    static public boolean initialize(PrintStream a_PrintStream,
            String[] a_StringArray_ModulePaths,
            String[] a_StringArray_ModuleArgumentsPaths){
        m_PrintStream = a_PrintStream;
        createAsn1ModuleURLs(a_StringArray_ModulePaths);
        //createAsn1ModuleClasses();
        createAsn1ObjectClasses();
        createAsn1ModuleArguments(a_StringArray_ModuleArgumentsPaths);
        //initAsn1ModuleArguments(a_StringArray_ModuleArgumentsPaths);
        m_boolean_Initialized = true;
        return m_boolean_Initialized;
    }
    static private void createAsn1ModuleArguments(String[] a_StringArray_ModuleArgumentsPaths){
        DocumentBuilder l_DocumentBuilder = Services.getDocumentBuilder();
        if(l_DocumentBuilder != null){
            for(String l_String : a_StringArray_ModuleArgumentsPaths){
                FileInputStream l_FileInputStream = Services.getFileInputStream(l_String);
                if(l_FileInputStream != null){
                    Document l_Document = Services.parse(l_DocumentBuilder, l_FileInputStream);
                    Element l_Element = l_Document.getDocumentElement();
                    NodeList l_NodeList_Parentclass = l_Document.getElementsByTagName("parentclass");
                    parseNodeList_Parentclass(l_NodeList_Parentclass);
                }
            }
        }
    }
    static Boolean addArgumentNodeList(Class a_Class, NodeList a_NodeList){
        Boolean l_Boolean_Return = false;
        Method l_Method = Services.getMethod(a_Class, "addArgumentNodeList", NodeList.class);
        if(l_Method != null){
            l_Boolean_Return = (Boolean)Services.InvokeMethod(l_Method,a_Class, a_NodeList);
        }
        return l_Boolean_Return;
    }
    static private void parseNodeList_Parentclass(NodeList a_NodeList){
        for(int l_int_Index_InputNodeList=0; l_int_Index_InputNodeList<a_NodeList.getLength(); l_int_Index_InputNodeList++){
            Node l_Node = a_NodeList.item(l_int_Index_InputNodeList);
            Node l_Node_Classname = l_Node.getAttributes().getNamedItem("classname");
            String l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
                    l_Node_Classname.getNodeName(),
                    l_Node_Classname.getNodeType(),
                    l_Node_Classname.getNodeValue(),
                    l_Node_Classname.getTextContent());
            System.out.println(l_String_Line);
            String l_String_Classname = l_Node_Classname.getNodeValue();
            Class l_Class = m_HashMapStringClass_Asn1ObjectClasses.get(l_String_Classname);
            Node l_Node_Null = null;
            if(l_Class != null){
                NodeList l_NodeList_Children = l_Node.getChildNodes();
                Boolean l_Boolean = addArgumentNodeList(l_Class, l_NodeList_Children);
                if(l_Boolean == false) outputMessage_CouldNotAddArgumentsNodeListForClass(l_Class.getName());
            }
        }
    }
//    static private void parseNodeList_Parentclass(NodeList a_NodeList){
//        for(int l_int_Index_InputNodeList=0; l_int_Index_InputNodeList<a_NodeList.getLength(); l_int_Index_InputNodeList++){
//            Node l_Node = a_NodeList.item(l_int_Index_InputNodeList);
//            Node l_Node_Classname = l_Node.getAttributes().getNamedItem("classname");
//            String l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
//                    l_Node_Classname.getNodeName(),
//                    l_Node_Classname.getNodeType(),
//                    l_Node_Classname.getNodeValue(),
//                    l_Node_Classname.getTextContent());
//            System.out.println(l_String_Line);
//            String l_String_Classname = l_Node_Classname.getNodeValue();
//            Class l_Class = m_HashMapStringClass_Asn1ObjectClasses.get(l_String_Classname);
//            Node l_Node_Null = null;
//            if(l_Class != null){
//                Method l_Method = Services.getMethod(l_Class, "addArgument", Node.class);
//                if(l_Method != null){
//                    NodeList l_NodeList_Children = l_Node.getChildNodes();
//                    for(int l_int_Index_ChildrenNodeList=0; l_int_Index_ChildrenNodeList<l_NodeList_Children.getLength(); l_int_Index_ChildrenNodeList++){
//                        Node l_Node_Child = l_NodeList_Children.item(l_int_Index_ChildrenNodeList);
//                        if(l_Node_Child.getNodeType() == Node.ELEMENT_NODE) Services.InvokeMethod(l_Method, l_Class, l_Node_Child);
//                    }
//                }
//            }
//        }
//    }
//    static public ANYArguments getANYArguments(Class a_Class, String a_String){
//        ANYArguments l_ANYArguments_Return = null;
//        Method l_Method = Services.getMethod(a_Class, "getANYArguments", a_String.getClass());
//        if(l_Method != null){
//            l_ANYArguments_Return = (ANYArguments)Services.InvokeMethod(l_Method,a_Class, a_String);
//        }
//        return l_ANYArguments_Return;
//    }
    static public Tag getTag(Class l_Class){
        Tag l_Tag_Return = null;
        Method l_Method = Services.getMethod(l_Class, "getTag");
        if(l_Method != null){
            l_Tag_Return = (Tag)Services.InvokeMethod(l_Method,l_Class);
        }
        return l_Tag_Return;
    }
    static public String getNameASN1Type(Class l_Class){
        String l_String_Return = "";
        Method l_Method = Services.getMethod(l_Class, "getNameASN1Type");
        if(l_Method != null){
            l_String_Return = Services.InvokeMethod(l_Method,l_Class).toString();
        }
        return l_String_Return;
    }
    static public String getNameXMLElement(Class l_Class){
        String l_String_Return = getNameASN1Type(l_Class).replace(" ","_");
        return l_String_Return;
    }
    static public Boolean IsCHOICE(Class l_Class){
        Boolean l_Boolean_Return = false;
        Method l_Method = Services.getMethodDeep(l_Class, "IsCHOICE");
        if(l_Method != null){
            l_Boolean_Return = (Boolean)Services.InvokeMethod(l_Method,l_Class);
        }
        return l_Boolean_Return;
    }
    static public Boolean IsINTEGER(Class l_Class){
        Boolean l_Boolean_Return = false;
        Method l_Method = Services.getMethodDeep(l_Class, "IsINTEGER");
        if(l_Method != null){
            l_Boolean_Return = (Boolean)Services.InvokeMethod(l_Method,l_Class);
        }
        return l_Boolean_Return;
    }
    static public Boolean IsSEQUENCE(Class l_Class){
        Boolean l_Boolean_Return = false;
        Method l_Method = Services.getMethodDeep(l_Class, "IsSEQUENCE");
        if(l_Method != null){
            l_Boolean_Return = (Boolean)Services.InvokeMethod(l_Method,l_Class);
        }
        return l_Boolean_Return;
    }
    static public Boolean IsSEQUENCEOF(Class l_Class){
        Boolean l_Boolean_Return = false;
        Method l_Method = Services.getMethodDeep(l_Class, "IsSEQUENCEOF");
        if(l_Method != null){
            l_Boolean_Return = (Boolean)Services.InvokeMethod(l_Method,l_Class);
        }
        return l_Boolean_Return;
    }
    static public Boolean IsBITSTRING(Class l_Class){
        Boolean l_Boolean_Return = false;
        Method l_Method = Services.getMethodDeep(l_Class, "IsBITSTRING");
        if(l_Method != null){
            l_Boolean_Return = (Boolean)Services.InvokeMethod(l_Method,l_Class);
        }
        return l_Boolean_Return;
    }
    static public Boolean IsOCTETSTRING(Class l_Class){
        Boolean l_Boolean_Return = false;
        Method l_Method = Services.getMethodDeep(l_Class, "IsOCTETSTRING");
        if(l_Method != null){
            l_Boolean_Return = (Boolean)Services.InvokeMethod(l_Method,l_Class);
        }
        return l_Boolean_Return;
    }
    static public Boolean IsANYDEFINEDBY(Class l_Class){
        Boolean l_Boolean_Return = false;
        Method l_Method = Services.getMethod(l_Class, "IsANYDEFINEDBY");
        if(l_Method != null){
            l_Boolean_Return = (Boolean)Services.InvokeMethod(l_Method,l_Class);
        }
        return l_Boolean_Return;
    }
//    static public String getSequenceOfClassNameASN1Name(Class l_Class){
//        String l_String_Return = "";
//        Method l_Method = Services.getMethod(l_Class, "getSequenceOfClassNameASN1Name");
//        if(l_Method != null){
//            l_String_Return = Services.InvokeMethod(l_Method,l_Class).toString();
//        }
//        return l_String_Return;
//    }
    static private void createAsn1ModuleURLs(String[] a_StringArray){
        boolean l_boolean_Return = false;
        m_ArrayListURL_Asn1ModuleURLs = new ArrayList<URL>();
        for(String l_String : a_StringArray){
            URL l_URL = Services.createURL(l_String);
            if(l_URL == null) outputMessage_CouldNotCreateURL(l_String);
            else m_ArrayListURL_Asn1ModuleURLs.add(l_URL);
        }
    }
    static private void createAsn1ObjectClasses(){
        m_ArrayListClass_Asn1ObjectClasses = Services.hasInterface(
                m_ArrayListURL_Asn1ModuleURLs,
                "gov.nist.div897.Asn1ILib.IAsn1Object");
        createAsn1ObjectClassesHashMap();
    }
    static private void createAsn1ObjectClassesHashMap(){
        boolean l_boolean_Return = false;
        m_HashMapStringClass_Asn1ObjectClasses = new HashMap<String,Class>();
        Class[] l_ClassArray = m_ArrayListClass_Asn1ObjectClasses.toArray(new Class[m_ArrayListClass_Asn1ObjectClasses.size()]);
        for(Class l_Class : l_ClassArray){
            //m_HashMapStringClass_Asn1ObjectClasses.put(l_Class.getName(),l_Class);
            m_HashMapStringClass_Asn1ObjectClasses.put(getNameASN1Type(l_Class),l_Class);
        }
    }
    static public Asn1Object instantiateAsn1Object(String a_String){
        Asn1Object l_Asn1Object_Return = null;
        Class l_Class = m_HashMapStringClass_Asn1ObjectClasses.get(a_String);
        if(l_Class != null){
            try{
                l_Asn1Object_Return = (Asn1Object)l_Class.newInstance();
            } catch(Exception l_Exception){
                Services.outputMessage_Exception(l_Exception);
            }
        }
        if(l_Asn1Object_Return == null){
            outputMessage_CouldNotInstantiateAsn1Object(a_String);
            l_Asn1Object_Return = new Asn1Object();
        }
        return l_Asn1Object_Return;
    }
    static public Asn1Object instantiateAsn1ObjectAbsolute(String a_String){
        Asn1Object l_Asn1Object_Return = null;
        Class l_Class = m_HashMapStringClass_Asn1ObjectClasses.get(a_String);
        if(l_Class != null){
            try{
                l_Asn1Object_Return = (Asn1Object)l_Class.newInstance();
            } catch(Exception l_Exception){
                Services.outputMessage_Exception(l_Exception);
            }
        }
        if(l_Asn1Object_Return == null){
            outputMessage_CouldNotInstantiateAsn1Object(a_String);
        }
        return l_Asn1Object_Return;
    }
    static public Asn1Object cloneAsn1Object(Asn1Object a_Asn1Object){
        Asn1Object l_Asn1Object_Return = null;
        
        if(a_Asn1Object != null){
            String l_String_NameASN1Type = getNameASN1Type(a_Asn1Object.getClass());
            l_Asn1Object_Return = instantiateAsn1ObjectAbsolute(l_String_NameASN1Type);
        }
        if(l_Asn1Object_Return != null){
            copyAsn1Object(l_Asn1Object_Return, a_Asn1Object);
        }
        return l_Asn1Object_Return;
    }
    static public void copyAsn1Object(Asn1Object a_Asn1Object_Destination, Asn1Object a_Asn1Object_Source){
        boolean l_boolean_Continue = true;
        if(l_boolean_Continue){
            if(a_Asn1Object_Destination == null){
                l_boolean_Continue = false;
            }
        }
        if(l_boolean_Continue){
            if(a_Asn1Object_Source == null){
                l_boolean_Continue = false;
            }
        }
        if(l_boolean_Continue){
            if(a_Asn1Object_Destination.getClass() != a_Asn1Object_Source.getClass()){
                l_boolean_Continue = false;
            }
        }
        if(l_boolean_Continue){
            a_Asn1Object_Destination.m_String_NameInstance = a_Asn1Object_Source.m_String_NameInstance;
            a_Asn1Object_Destination.m_Attributes = null;
            if(a_Asn1Object_Source.m_Attributes != null)
                a_Asn1Object_Destination.m_Attributes = (Attributes)a_Asn1Object_Source.m_Attributes.clone();
            if(a_Asn1Object_Source.m_byteArray_Data != null)
                a_Asn1Object_Destination.m_byteArray_Data = (byte[])a_Asn1Object_Source.m_byteArray_Data.clone();
            if(IsCHOICE(a_Asn1Object_Source.getClass())){
                a_Asn1Object_Destination.setChoices(a_Asn1Object_Source.getChoices());
                Asn1Object l_Asn1Object = a_Asn1Object_Destination.MakeChoice(a_Asn1Object_Source.getChoiceTag());
                copyAsn1Object(l_Asn1Object, a_Asn1Object_Source.getChoice());
            }
            if(IsINTEGER(a_Asn1Object_Source.getClass())){
                a_Asn1Object_Destination.setRangeArrayList(a_Asn1Object_Source.getRangeArrayList());
                a_Asn1Object_Destination.setIdentifiers(a_Asn1Object_Source.getIdentifiers());
            }
            if(IsBITSTRING(a_Asn1Object_Source.getClass())){
                a_Asn1Object_Destination.setSizeRangeArrayList(a_Asn1Object_Source.getSizeRangeArrayList());
                a_Asn1Object_Destination.setIdentifiers(a_Asn1Object_Source.getIdentifiers());
            }
            if(IsOCTETSTRING(a_Asn1Object_Source.getClass())){
                a_Asn1Object_Destination.setSizeRangeArrayList(a_Asn1Object_Source.getSizeRangeArrayList());
                a_Asn1Object_Destination.setIdentifiers(a_Asn1Object_Source.getIdentifiers());
            }
            if(IsANYDEFINEDBY(a_Asn1Object_Source.getClass())){
                a_Asn1Object_Destination.setANYArguments(a_Asn1Object_Source.getANYArguments());
                Asn1Object l_Asn1Object = cloneAsn1Object(a_Asn1Object_Source.getANYOption());
                a_Asn1Object_Destination.setANYOption(l_Asn1Object);
                l_Asn1Object = a_Asn1Object_Destination.getANYAsn1Object();
                if(a_Asn1Object_Destination != l_Asn1Object) copyAsn1Object(l_Asn1Object, a_Asn1Object_Source.getANYAsn1Object());
            }
            if(IsSEQUENCE(a_Asn1Object_Source.getClass())){
                Integer l_Integer_Count = a_Asn1Object_Source.getSequenceCount();
                for(Integer l_Integer=0;l_Integer<l_Integer_Count;l_Integer++){
                    copyAsn1Object(a_Asn1Object_Destination.getSequenceObject(l_Integer),a_Asn1Object_Source.getSequenceObject(l_Integer));
                }
            }
            if(IsSEQUENCEOF(a_Asn1Object_Source.getClass())){
                a_Asn1Object_Destination.setSequenceOfClassNameASN1Name(a_Asn1Object_Source.getSequenceOfClassNameASN1Name());
                Integer l_Integer_Count = a_Asn1Object_Source.getSequenceOfCount();
                for(Integer l_Integer=0;l_Integer<l_Integer_Count;l_Integer++){
                    Asn1Object l_Asn1Object = a_Asn1Object_Destination.instantiateNextSequenceOfAsn1Object();
                    copyAsn1Object(l_Asn1Object,a_Asn1Object_Source.getSequenceOfObject(l_Integer));
                }
            }
        }
    }
    static private void outputMessage_CouldNotCreateURL(String a_String){
        String l_String_Line = String.format("Could not create URL from path: %1$s",a_String);
        m_PrintStream.println(l_String_Line);
    }
    static private void outputMessage_CouldNotAddArgumentsNodeListForClass(String a_String){
        String l_String_Line = String.format("Could not add argument node list for class: %1$s",a_String);
        m_PrintStream.println(l_String_Line);
    }
    static private void outputMessage_CouldNotInstantiateAsn1Object(String a_String){
        String l_String_Line = String.format("Could not instantiate Asn1Object: %1$s",a_String);
        m_PrintStream.println(l_String_Line);
    }
    static public void outputAsn1ObjectClassNames(){
        Class[] l_ClassArray = m_ArrayListClass_Asn1ObjectClasses.toArray(new Class[m_ArrayListClass_Asn1ObjectClasses.size()]);
        m_PrintStream.println("START - Printing Asn1Object Class Names : Asn1 Names");
        for(Class l_Class : l_ClassArray){
            m_PrintStream.println(l_Class.getName() + " : " + getNameASN1Type(l_Class));
        }
        m_PrintStream.println("END - Printing Asn1Object Class Names : Asn1 Names");
    }
//    static private void initAsn1ModuleArguments(String[] a_StringArray_ModuleArgumentsPaths){
//        try{
//            String l_String_Line = "";
//            String l_String_DefinedByField = "";
//            String l_String_ParentClass = "";
//            DocumentBuilderFactory l_DocumentBuilderFactory = DocumentBuilderFactory.newInstance();
//            DocumentBuilder l_DocumentBuilder = l_DocumentBuilderFactory.newDocumentBuilder();
//            if(l_DocumentBuilder != null){
//                for(String l_String : a_StringArray_ModuleArgumentsPaths){
//                    //FileInputStream l_FileInputStream = new FileInputStream("C:/ConfigurationFiles/RoseLib.xml");
//                    FileInputStream l_FileInputStream = new FileInputStream(l_String);
//                    Document l_Document = l_DocumentBuilder.parse(l_FileInputStream);
//                    Element l_Element = l_Document.getDocumentElement();
//                    System.out.println(l_Element.getTagName());
//                    NodeList l_NodeList_Any = l_Document.getElementsByTagName("any");
//                    int l_int_NodeListLength_Any = l_NodeList_Any.getLength();
//                    for(int l_int_Index_Any = 0;l_int_Index_Any < l_int_NodeListLength_Any;l_int_Index_Any++){
//                        System.out.println(l_NodeList_Any.item(l_int_Index_Any).getNodeName());
//                        NodeList l_NodeList_AnyChildren = l_NodeList_Any.item(l_int_Index_Any).getChildNodes();
//                        int l_int_NodeListLength_AnyChildren = l_NodeList_AnyChildren.getLength();
//                        for(int l_int_Index_AnyChildren = 0;l_int_Index_AnyChildren < l_int_NodeListLength_AnyChildren;l_int_Index_AnyChildren++){
//                            String l_String_NodeName_AnyChild = l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeName();
//                            if(l_String_NodeName_AnyChild == "parentclass"){
//                                l_String_ParentClass = l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getTextContent();
//                                l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
//                                        l_String_NodeName_AnyChild,
//                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeType(),
//                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeValue(),
//                                        l_String_ParentClass);
//                                System.out.println(l_String_Line);
//
//                            } else if(l_String_NodeName_AnyChild == "AnyField"){
//                                l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
//                                        l_String_NodeName_AnyChild,
//                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeType(),
//                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeValue(),
//                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getTextContent());
//                                System.out.println(l_String_Line);
//
//                            } else if(l_String_NodeName_AnyChild == "DefinedByField"){
//                                l_String_DefinedByField = l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getTextContent();
//                                l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
//                                        l_String_NodeName_AnyChild,
//                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeType(),
//                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeValue(),
//                                        l_String_DefinedByField);
//                                System.out.println(l_String_Line);
//
//                            } else if(l_String_NodeName_AnyChild == "mapping"){
////                                l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
////                                        l_String_NodeName_AnyChild,
////                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeType(),
////                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getNodeValue(),
////                                        l_NodeList_AnyChildren.item(l_int_Index_AnyChildren).getTextContent());
////                                System.out.println(l_String_Line);
//                                Node l_Node = l_NodeList_AnyChildren.item(l_int_Index_AnyChildren);
//                                NodeList l_NodeList_MappingChildren = l_Node.getChildNodes();
//                                int l_int_NodeListLength_MappingChildren = l_NodeList_MappingChildren.getLength();
//                                for(int l_int_Index_MappingChildren = 0;l_int_Index_MappingChildren < l_int_NodeListLength_MappingChildren;l_int_Index_MappingChildren++){
//                                    Node l_Node_Data = l_NodeList_MappingChildren.item(l_int_Index_MappingChildren);
//                                    String l_String_NodeName_MappingChild = l_Node_Data.getNodeName();
//                                    if(l_String_NodeName_MappingChild == "data"){
//                                        l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
//                                                l_String_NodeName_MappingChild,
//                                                l_Node_Data.getNodeType(),
//                                                l_Node_Data.getNodeValue(),
//                                                l_Node_Data.getTextContent());
//                                        System.out.println(l_String_Line);
//                                        String l_String_Data = l_Node_Data.getTextContent();
//
//                                        Node l_Node_Data_Size = l_Node_Data.getAttributes().getNamedItem("size");
//                                        l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
//                                                l_Node_Data_Size.getNodeName(),
//                                                l_Node_Data_Size.getNodeType(),
//                                                l_Node_Data_Size.getNodeValue(),
//                                                l_Node_Data_Size.getTextContent());
//                                        System.out.println(l_String_Line);
//                                        String l_String_Data_Size = l_Node_Data_Size.getNodeValue();
//
//                                        Node l_Node_Data_Format = l_Node_Data.getAttributes().getNamedItem("format");
//                                        l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
//                                                l_Node_Data_Format.getNodeName(),
//                                                l_Node_Data_Format.getNodeType(),
//                                                l_Node_Data_Format.getNodeValue(),
//                                                l_Node_Data_Format.getTextContent());
//                                        System.out.println(l_String_Line);
//                                        String l_String_Data_Format = l_Node_Data_Format.getNodeValue();
//
//
////                                        Asn1Object l_Asn1Object = getAsn1Object(l_String_ParentClass);
////                                        if(l_Asn1Object != null){
////                                            if(l_Asn1Object.IsSequence()){
////                                                Asn1Object l_Asn1Object_DefinedByField = l_Asn1Object.getSequenceObject(l_String_DefinedByField);
////                                                if(l_Asn1Object_DefinedByField != null){
////                                                    String l_String_DefinedByFieldClass = l_Asn1Object_DefinedByField.getClass().getName();
////                                                    Asn1Object l_Asn1Object_1 = getAsn1Object(l_String_DefinedByFieldClass);
////                                                    l_Asn1Object_1.setName("{ANY}");
////                                                    l_Asn1Object_1.setData(Dump.toByteArray(Integer.valueOf(l_String_Data_Size),l_String_Data_Format,l_String_Data));
////                                                    l_Asn1Object_1.printXML(System.out);
////                                                    //System.out.println(l_String_Line);
////                                                }
////                                            }
////                                        }
//                                    } else if(l_String_NodeName_MappingChild == "mappedclass"){
//                                        l_String_Line = String.format("Name: %1$s, Type: %2$d, Value: %3$s, Text: %4$s",
//                                                l_String_NodeName_MappingChild,
//                                                l_NodeList_MappingChildren.item(l_int_Index_MappingChildren).getNodeType(),
//                                                l_NodeList_MappingChildren.item(l_int_Index_MappingChildren).getNodeValue(),
//                                                l_NodeList_MappingChildren.item(l_int_Index_MappingChildren).getTextContent());
//                                        System.out.println(l_String_Line);
//
//                                    }
//                                }
//                            }
//                        }
//                    }
//                }
//            }
//        } catch (Exception l_Exception){
//            System.out.println(l_Exception.toString());
//        }
//    }
}
