package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.BITS32;
import gov.nist.div897.Asn1Lib.INTEGER;

public class SystemCapability extends BITS32 {
	static final private String m_String_NameAsn1Type="SystemCapability";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTEGER("","0"),"sc-multiple-context"),
		new Identifier(new INTEGER("","1"),"sc-dyn-configuration"),
		new Identifier(new INTEGER("","2"),"sc-dyn-scanner-create"),
		new Identifier(new INTEGER("","3"),"sc-auto-init-scan-list"),
		new Identifier(new INTEGER("","4"),"sc-auto-updt-scan-list"),
	};
	public SystemCapability(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));	
}
	public SystemCapability(String a_name){
		 this();
		 setNameInstance(a_name);
	}
	public SystemCapability(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public SystemCapability(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public SystemCapability(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
