package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1ILib.Identifier;
import gov.nist.div897.Asn1ILib.Identifiers;
import gov.nist.div897.MderLib.BITS16;
import gov.nist.div897.Asn1Lib.INTEGER;

public class MeasurementStatus extends BITS16 {
	static final private String m_String_NameAsn1Type="MeasurementStatus";
	static final private Identifier[] m_IdentifierArray = {
		new Identifier(new INTEGER("","0"),"invalid"),
		new Identifier(new INTEGER("","1"),"questionable"),
		new Identifier(new INTEGER("","2"),"not-available"),
		new Identifier(new INTEGER("","3"),"calibration-ongoing"),
		new Identifier(new INTEGER("","4"),"test-data"),
		new Identifier(new INTEGER("","5"),"demo-data"),
		new Identifier(new INTEGER("","8"),"validated-data"),
		new Identifier(new INTEGER("","9"),"early-indication"),
		new Identifier(new INTEGER("","10"),"msmt-ongoing"),
		new Identifier(new INTEGER("","14"),"msmt-state-in-alarm"),
		new Identifier(new INTEGER("","15"),"msmt-state-al-inhibited"),
	};
	public MeasurementStatus(){
		super();
		setIdentifiers(new Identifiers(m_IdentifierArray));	
}
	public MeasurementStatus(String a_name){
		 this();
		 setNameInstance(a_name);
	}
	public MeasurementStatus(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public MeasurementStatus(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public MeasurementStatus(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
