package gov.nist.div897.DimLib;

import gov.nist.div897.Asn1Lib.*;
import gov.nist.div897.MderLib.*;

import gov.nist.div897.Asn1ILib.*;

public class AlertCapabEntry extends SEQUENCE {
	static final private String m_String_NameAsn1Type="AlertCapabEntry";
	public AlertCapabEntry(){
		super();
		HANDLE objreference = new HANDLE();
		objreference.setNameInstance("obj-reference");
		m_ArrayListAsn1Object.add(objreference);
		OIDType objclass = new OIDType();
		objclass.setNameInstance("obj-class");
		m_ArrayListAsn1Object.add(objclass);
		OIDType alertgroup = new OIDType();
		alertgroup.setNameInstance("alert-group");
		m_ArrayListAsn1Object.add(alertgroup);
		BITS16 alrepflags = new BITS16();
		alrepflags.setNameInstance("al-rep-flags");
		Identifier[] m_IdentifierArray = {
			new Identifier(new INTU16("","1"),"dyn-inst-contents"),
			new Identifier(new INTU16("","2"),"rep-all-inst"),
		};
		alrepflags.setIdentifiers(new Identifiers(m_IdentifierArray));
		m_ArrayListAsn1Object.add(alrepflags);
		AlertType maxtseverity = new AlertType();
		maxtseverity.setNameInstance("max-t-severity");
		m_ArrayListAsn1Object.add(maxtseverity);
		INTU16 maxtobjal = new INTU16();
		maxtobjal.setNameInstance("max-t-obj-al");
		m_ArrayListAsn1Object.add(maxtobjal);
		AlertType maxpseverity = new AlertType();
		maxpseverity.setNameInstance("max-p-severity");
		m_ArrayListAsn1Object.add(maxpseverity);
		INTU16 maxpobjal = new INTU16();
		maxpobjal.setNameInstance("max-p-obj-al");
		m_ArrayListAsn1Object.add(maxpobjal);

	}
	public AlertCapabEntry(String a_name){
		this();
		setNameInstance(a_name);
	}
	public AlertCapabEntry(String a_name, String a_String_Data){
		 this();
		 setNameInstance(a_name);
		setData(a_String_Data);;	}
	public AlertCapabEntry(String a_name, byte[] a_byteArray){
		 this();
		setNameInstance(a_name);
		setData(a_byteArray);	}
	public AlertCapabEntry(byte[] a_byteArray){
		 this();
		setData(a_byteArray);	}
	static public String getNameASN1Type(){
		return m_String_NameAsn1Type;
	}

}
