package dataTypeInterface;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

import addingsToAsnLib.RandomValuesServer;

import com.sun.org.apache.bcel.internal.generic.Select;


import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1Lib.ANY;
import gov.nist.div897.Asn1Lib.BITSTRING;
import gov.nist.div897.Asn1Lib.CHOICE;
import gov.nist.div897.Asn1Lib.INTEGER;
import gov.nist.div897.Asn1Lib.OCTETSTRING;
import gov.nist.div897.Asn1Lib.SEQUENCE;
import gov.nist.div897.Asn1Lib.SEQUENCEOF;
import gov.nist.div897.DimLib.AVAType;
import gov.nist.div897.DimLib.AbsoluteTime;
import gov.nist.div897.DimLib.CCOid;
import gov.nist.div897.DimLib.EnumObsValue;
import gov.nist.div897.DimLib.EnumVal;
import gov.nist.div897.DimLib.MarkerListRelTim;
import gov.nist.div897.DimLib.MeasurementStatus;
import gov.nist.div897.DimLib.MibIdList;
import gov.nist.div897.DimLib.NomenclatureVersion;
import gov.nist.div897.DimLib.ProdSpecEntry;
import gov.nist.div897.DimLib.ProductionSpec;
import gov.nist.div897.DimLib.SegmSelection;
import gov.nist.div897.DimLib.SelectList;
import gov.nist.div897.DimLib.SimpleColour;

public class TestingDataTypesInterface {
	static SEQUENCE seq; 
	static IComponentAsn comp;
	static INTEGER integer;
	static BITSTRING measurementStatus;
	static SEQUENCEOF sequenceOf;
	static CHOICE choice;
	static OCTETSTRING octetString;
	static ANY any;
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
            	 Configuration l_Configuration = new Configuration("c:/ConfigurationFiles/Test07.xml");
                 
                 //Load Asn1Modules
                 String[] l_StringArray_Asn1ModulePaths = l_Configuration.getAsn1ModulePaths();
                 String[] l_StringArray_Asn1ModuleArgumentsPaths = l_Configuration.getAsn1ModuleArgumentsPaths();
                 Asn1ModuleServer.initialize(System.out,l_StringArray_Asn1ModulePaths,l_StringArray_Asn1ModuleArgumentsPaths);
                 
//               Output Asn1ModulePaths, Asn1ModuleArgumentsPaths, and Asn1ObjectClasses
                 for(String l_String : l_StringArray_Asn1ModulePaths) System.out.println("Asn1ModulePath : "+l_String);
                 for(String l_String : l_StringArray_Asn1ModuleArgumentsPaths) System.out.println("Asn1ModuleArgumentsPath : "+l_String);
                 Asn1ModuleServer.outputAsn1ObjectClassNames();
                 
                 RandomValuesServer.setRandom();
                 
//            	seq = new AbsoluteTime("AbsoluteTime");
//            	seq.getSequenceObject(0).setData("20");
//            	seq.getSequenceObject(1).setData("200");
//            	seq.getSequenceObject(2).setData("11");
//            	seq.getSequenceObject(3).setData("20");
//            	seq.getSequenceObject(4).setData("2");
//            	seq.getSequenceObject(5).setData("4");
//            	seq.getSequenceObject(6).setData("00");
//            	seq.getSequenceObject(7).setData("00");
//            	integer = new SimpleColour("colour");
//            	integer.setData("4");
//            	
//            	measurementStatus = new MeasurementStatus(MeasurementStatus.getASN1Name());
//            	measurementStatus.setData(new byte[]{(byte)0xFF,(byte)0xFF});

                
                //seq = new EnumObsValue("EnumObsVal");
//            	sequenceOf = new MarkerListRelTim("MarkerListRelTim");
//            	sequenceOf.instantiateNextSequenceOfAsn1Object();
//            	sequenceOf.instantiateNextSequenceOfAsn1Object();
                 sequenceOf = new ProductionSpec("productionSpec");
            	octetString = new OCTETSTRING("octetString", new byte[]{(byte)0x68, (byte)0x65, (byte)0x6c,(byte)0x6c,(byte)0x6f});
            	//seq = new AVAType("ava type");
            	
            	//choice = new SegmSelection("segmentSelection");
            	//choice = new EnumVal("enumVal");
            	choice = new SelectList("selectList");
            	choice.MakeChoice(new byte[]{(byte)0x00, (byte)0x03});
            	//comp = new ComponentAsnChoice(choice);
            	comp = new ComponentAsnSequenceOf(sequenceOf);
            	//comp = new ComponentAsnBitString(measurementStatus);
            	//comp = new ComponentAsnSequence(seq);
            	//comp = new ComponentAsnInteger(integer);
            	//comp = new ComponentAsnOctetString(octetString);
            	RandomValuesServer.setRandomValue(comp.getAsn1Object());
            	comp.updateDataComp();
            	
            	JFrame frame = new JFrame("Testing ASN.1 Data Types Interface");
            	frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            	frame.getContentPane().setLayout(new BorderLayout());
            	
            	frame.getContentPane().add(comp.getComponent(), BorderLayout.PAGE_START);
            	
            	JButton btnOK = new JButton("Save");
            	btnOK.addActionListener(new ActionListener(){

					public void actionPerformed(ActionEvent arg0) {
						comp.saveData();
						//comp.updateDataComp();
						sequenceOf.printXML(System.out);
						RandomValuesServer.setRandomValue(comp.getAsn1Object());
						comp.updateDataComp();
						comp.getComponent().validate();
					}
            		
            	});
            	
            	frame.add(btnOK, BorderLayout.PAGE_END);
            	
            	frame.pack();
            	frame.setLocationRelativeTo(null);
            	frame.setVisible(true);
            }
         });
	}

}

