/*
 * Configuration.java
 *
 * Created on November 9, 2006, 12:30 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package dataTypeInterface;
import java.util.*;
import java.util.regex.*;
import java.io.*;

/**
 *
 * @author rtheimer
 */
public class Configuration {
    private String m_String_Path;
    private Properties m_Properties;
    private String[] m_StringArray_Asn1ModulePaths;
    private String[] m_StringArray_Asn1ModuleArgumentsPaths;
    /** Creates a new instance of Configuration */
    public Configuration() {
        m_String_Path = "";
        m_Properties = null;
        m_StringArray_Asn1ModulePaths = null;
        m_StringArray_Asn1ModuleArgumentsPaths = null;
    }
    public Configuration(String a_String) {
        this();
        setPath(a_String);
        loadProperties();
        parseAsn1ModulePaths();
        parseAsn1ModuleArgumentsPaths();
    }
    public void setPath(String a_String){
        m_String_Path = a_String;
    }
    public String getPath(){
        return m_String_Path;
    }
    private void loadProperties(){
        try{
            FileInputStream l_FileInputStream = new FileInputStream(getPath());
            m_Properties = new Properties();
            m_Properties.loadFromXML(l_FileInputStream);
        } catch (Exception l_Exception){
            System.out.println(l_Exception.toString());
        }
    }
    private void parseAsn1ModulePaths(){
        Pattern l_Pattern = Pattern.compile("^Asn1Module-[A-Za-z0-9]+$");
        ArrayList<String> l_ArrayListString_Properties = new ArrayList<String>();
        int l_int_Index = 0;
        if(m_Properties != null){
            Enumeration l_Enumeration_Properties = m_Properties.propertyNames();
            for (Enumeration l_Enumeration=l_Enumeration_Properties;l_Enumeration.hasMoreElements();){
                String l_String_Property = (String)l_Enumeration.nextElement();
                Matcher l_Matcher = l_Pattern.matcher(l_String_Property);
                if(l_Matcher.matches()) l_ArrayListString_Properties.add(l_String_Property);
            }
            String[] l_StringArray_Properties = new String[l_ArrayListString_Properties.size()];
            for(String l_String:l_ArrayListString_Properties){
                l_StringArray_Properties[l_int_Index] = l_String;
                l_int_Index++;
            }
            Arrays.sort(l_StringArray_Properties);
            m_StringArray_Asn1ModulePaths = new String[l_StringArray_Properties.length];
            l_int_Index=0;
            for(String l_String:l_StringArray_Properties){
                String l_String_Property = m_Properties.getProperty(l_String);
                l_String_Property = l_String_Property.replace("\"","");
                m_StringArray_Asn1ModulePaths[l_int_Index]=l_String_Property;
                //String l_String_Line = String.format("%1$s : %2$s",l_String,l_String_Property);
                //System.out.println(l_String_Line);
                l_int_Index++;
            }
        }
    }
    private void parseAsn1ModuleArgumentsPaths(){
        Pattern l_Pattern = Pattern.compile("^Asn1ModuleArguments-[A-Za-z0-9]+$");
        ArrayList<String> l_ArrayListString_Properties = new ArrayList<String>();
        int l_int_Index = 0;
        if(m_Properties != null){
            Enumeration l_Enumeration_Properties = m_Properties.propertyNames();
            for (Enumeration l_Enumeration=l_Enumeration_Properties;l_Enumeration.hasMoreElements();){
                String l_String_Property = (String)l_Enumeration.nextElement();
                Matcher l_Matcher = l_Pattern.matcher(l_String_Property);
                if(l_Matcher.matches()) l_ArrayListString_Properties.add(l_String_Property);
            }
            String[] l_StringArray_Properties = new String[l_ArrayListString_Properties.size()];
            for(String l_String:l_ArrayListString_Properties){
                l_StringArray_Properties[l_int_Index] = l_String;
                l_int_Index++;
            }
            Arrays.sort(l_StringArray_Properties);
            m_StringArray_Asn1ModuleArgumentsPaths = new String[l_StringArray_Properties.length];
            l_int_Index=0;
            for(String l_String:l_StringArray_Properties){
                String l_String_Property = m_Properties.getProperty(l_String);
                l_String_Property = l_String_Property.replace("\"","");
                m_StringArray_Asn1ModuleArgumentsPaths[l_int_Index]=l_String_Property;
                //String l_String_Line = String.format("%1$s : %2$s",l_String,l_String_Property);
                //System.out.println(l_String_Line);
                l_int_Index++;
            }
        }
    }
    public String[] getAsn1ModulePaths(){
        return (m_StringArray_Asn1ModulePaths == null) ? null : m_StringArray_Asn1ModulePaths.clone();
    }
    public String[] getAsn1ModuleArgumentsPaths(){
        return (m_StringArray_Asn1ModuleArgumentsPaths == null) ? null : m_StringArray_Asn1ModuleArgumentsPaths.clone();
    }
}
