package dataTypeInterface;

import gov.nist.div897.Asn1ILib.ANYArguments;
import gov.nist.div897.Asn1ILib.Asn1ModuleServer;
import gov.nist.div897.Asn1ILib.Asn1Object;
import gov.nist.div897.Asn1Lib.ANY;
import gov.nist.div897.Asn1Lib.CHOICE;
import gov.nist.div897.Asn1Lib.INTEGER;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

import addingsToAsnLib.ValidateAsnObject;

public class ComponentAsnAny implements IComponentAsn, ActionListener{

	ANY any;
	JPanel panel;
	JPanel choicePan;
	CollapsablePanel colPanel;
	Vector<IComponentAsn> vectChoiceComp;
	JComboBox cbBox = null;
	int indexSelected = -1;
	Asn1Object asnObjSaved = null;
	IComponentAsn compDefinedBy;
	ANYArguments anyArgs;
	
	public ComponentAsnAny(ANY asnObj, IComponentAsn compDefinedByIn){
		compDefinedBy = compDefinedByIn;
		any = asnObj;
		vectChoiceComp = new Vector<IComponentAsn>();
		asnObjSaved = any.getANYAsn1Object();
		initComponent();		
	}
	public void initComponent(){
		String toolTipText = Asn1ModuleServer.getNameASN1Type(any.getClass());
		
		panel = new JPanel();
		
		colPanel = new CollapsablePanel();
		colPanel.setCollapsablePan(panel);
		
		panel.setLayout(new BorderLayout());
		//panel.setBorder(BorderFactory.createTitledBorder(any.getNameInstance()));
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.LINE_AXIS));	
		JLabel label = new JLabel(any.getNameInstance());
		label.setPreferredSize(new Dimension(90,0));
		label.setToolTipText(toolTipText);
		p.add(label);
		p.add(Box.createRigidArea(new Dimension(10,0)));
		
		colPanel.setHeaderPan(p);
		
		choicePan = new JPanel();
		choicePan.setLayout(new BoxLayout(choicePan, BoxLayout.PAGE_AXIS));
		choicePan.add(Box.createRigidArea(new Dimension(0,10)));
		
		JPanel p2 = new JPanel();
		p2.setLayout(new BoxLayout(p2, BoxLayout.PAGE_AXIS));
		p2.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		
		//Choices choices = choice.getChoices();
		anyArgs = any.getANYArguments();
		Vector<String> vectDataTypes = new Vector<String>();
		
		if(anyArgs != null){
            Set<Asn1Object> l_SetAsn1Object = anyArgs.keySet();
            Asn1Object[] l_Asn1ObjectArray = l_SetAsn1Object.toArray(new Asn1Object[l_SetAsn1Object.size()]);
            if(l_Asn1ObjectArray != null){
                for(Asn1Object l_Asn1Object : l_Asn1ObjectArray){
                	String labelText = anyArgs.get(l_Asn1Object);
                    String l_String_Classname = labelText;
                    labelText += "("+l_Asn1Object.getDataAsBigInteger()+")";
                    vectDataTypes.add(labelText);
                    l_String_Classname = l_String_Classname.replaceAll("_", " ");
        			Asn1Object asnObj = Asn1ModuleServer.instantiateAsn1Object(l_String_Classname);
        			vectChoiceComp.add(ComponentAsnServer.instantiateAsnComponent(this, asnObj));
                        
                }
                Collections.sort(vectDataTypes);
                cbBox = new JComboBox(vectDataTypes.toArray());
    			panel.add(cbBox);
    			cbBox.addActionListener(this);
    			p.add(cbBox);
    			p.add(Box.createRigidArea(new Dimension(10,0)));
            }
        }
		JPanel p4 = new JPanel();
		p4.setLayout(new BorderLayout());
		p4.add(p2, BorderLayout.PAGE_START);
		panel.add(p4, BorderLayout.WEST);
		JPanel p3 = new JPanel();
		p3.setLayout(new BorderLayout());
		p3.add(choicePan, BorderLayout.PAGE_START);
		panel.add(p3, BorderLayout.CENTER);
	}
	public boolean saveData() {
		boolean ret = true;
		String error = "";
		if(indexSelected != -1){
		if(!vectChoiceComp.get(indexSelected).saveData()){
			ret = false;
			error = error.concat(ValidateAsnObject.getErrorMessage());
		}
		else{
			//look for the option related to the selected object
			String class_name = cbBox.getSelectedItem().toString();
			class_name = class_name.substring(0, class_name.indexOf("("));
			class_name = class_name.replaceAll("_", " ");
			if(anyArgs != null){
	            Set<Asn1Object> l_SetAsn1Object = anyArgs.keySet();
	            Asn1Object[] l_Asn1ObjectArray = l_SetAsn1Object.toArray(new Asn1Object[l_SetAsn1Object.size()]);
	            if(l_Asn1ObjectArray != null){
	                for(Asn1Object l_Asn1Object : l_Asn1ObjectArray){
	                    String l_String_Classname = anyArgs.get(l_Asn1Object);
	                    if(l_String_Classname.equals(class_name)){
	                    	//set the option in the any object
	                    	any.setANYOption(l_Asn1Object);
	                    }
	                }
	            }
	        }
	//		get the selected object in the any
			Asn1Object objTemp = any.getANYAsn1Object();
			
			//copy data
			Asn1ModuleServer.copyAsn1Object(objTemp, vectChoiceComp.get(indexSelected).getAsn1Object());
			}
		}
		ValidateAsnObject.setErrorMessage(error);
		return ret;
	}

	public void updateDataComp() {
		String class_name;
		
		if(any.getANYOption() != null && anyArgs.containsKey(any.getANYOption())){
			class_name = anyArgs.get(any.getANYOption());		
			class_name = class_name+"("+any.getANYOption().getDataAsBigInteger()+")";
			cbBox.setSelectedItem(class_name);
			
			for(int i = 0; i < cbBox.getItemCount(); i++){
				if(cbBox.getItemAt(i).toString().equals(class_name)){
					indexSelected = i;
					i = cbBox.getItemCount();
				}
			}
			
			vectChoiceComp.get(indexSelected).updateDataComp();
			
			choicePan.removeAll();
			
			choicePan.add(vectChoiceComp.get(indexSelected).getComponent());
			//panel.validate();
			choicePan.updateUI();
		}
	}

	public Component getComponent() {
		return colPanel;
	}
	
	public Asn1Object getAsn1Object() {
		return any;
	}
	public void actionPerformed(ActionEvent arg0) {
		if(arg0.getSource().equals(cbBox)){
				int i = cbBox.getSelectedIndex();
				choicePan.removeAll();
				
				choicePan.add(vectChoiceComp.get(i).getComponent());
				//panel.validate();
				choicePan.updateUI();
				indexSelected = i;
				String class_name = cbBox.getSelectedItem().toString();
				
				
				//ANYArguments anyArgs = any.getANYArguments();		
				if(anyArgs != null){
		            Set<Asn1Object> l_SetAsn1Object = anyArgs.keySet();
		            Asn1Object[] l_Asn1ObjectArray = l_SetAsn1Object.toArray(new Asn1Object[l_SetAsn1Object.size()]);
		            if(l_Asn1ObjectArray != null){
		                for(Asn1Object l_Asn1Object : l_Asn1ObjectArray){
		                    String l_String_Classname = anyArgs.get(l_Asn1Object)+"("+l_Asn1Object.getDataAsBigInteger()+")";
		                    if(l_String_Classname.equals(class_name)){		                    	
		                    	compDefinedBy.getAsn1Object().setData(l_Asn1Object.getData());
		                    }
		                }
		            }
		        }
				
				
				compDefinedBy.updateDataComp();
		}
		
	}

}
