package transport;

import icsTables.XMlXSLTClass;

import java.util.Vector;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * This class builds the Transport ICS model from the xml file
 * @author mcherk
 *
 */
public class TransportModelsBuilder {
	protected Vector<TransportProfile> vectTransProfiles;
	private TransportProfile curTProfile;
	private TransportICS curTICS;
	public Document doc;
	
	static final String defaultXmlFile = "..//xml//transportICS.xml";
	
	public TransportModelsBuilder(String xmlFile){
		vectTransProfiles = new Vector<TransportProfile>();
		
		XMlXSLTClass xmlClass = new XMlXSLTClass();
		
		doc = xmlClass.readXMLFile(defaultXmlFile);
		doc = xmlClass.readXMLFile(xmlFile);
		
		//create the current tabletree
		Node root = doc.getDocumentElement();
		parseNode(root, vectTransProfiles);
	}

	private void parseNode(Node root, Vector<TransportProfile> profile)
	{
		if (root.hasChildNodes()){
	         NodeList children;
	         String name;
	         int numChildren;
	         Node node;
	         children = root.getChildNodes();
	         numChildren = children.getLength();
	         for (int i=0; i < numChildren; i++) {
	        	 node = children.item(i);                 
		         if (node != null) {                     
		 	          if (node.getNodeType() == Node.ELEMENT_NODE) {
		 	        	  // Transport profile
		 	        	  if (node.getNodeName().equals("Transport-Profile")) {
		 	        		 name = node.getAttributes().getNamedItem("name").getNodeValue();
		 	        		 curTProfile = new TransportProfile(name);
		 	        		 
		 	        		 NodeList icsChildren = node.getChildNodes();
		 	        		 for(int j = 0; j < icsChildren.getLength(); j++){
		 	        			 node = icsChildren.item(j);
//		 	        			 Transport ics
				 	        	  if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals("Transport-ICS")) {
				 	        		 name = node.getAttributes().getNamedItem("name").getNodeValue();
				 	        		 curTICS = new TransportICS(name);
				 	        		 NodeList functionChildren = node.getChildNodes();
				 	        		 // functions
				 	        		 for(int f = 0; f < functionChildren.getLength(); f++){
				 	        			node = functionChildren.item(f);
				 	        			if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals("Function")) 
				 	        				parseNodeFunction(node, curTICS.getRoot());
					 	        		 
				 	        		 }
				 	        		 curTProfile.addTransportICS(curTICS);
				 	        	  }
		 	        		 }
		 	        		 profile.add(curTProfile);		 	        		 
		 	        	  }
		 	        	  
		 	          }
		         }
	         }
		}
	}
	private void parseNodeFunction(Node node, TableNode tNode)
	{
		String name = node.getAttributes().getNamedItem("name").getNodeValue();
		String BCC = node.getAttributes().getNamedItem("BCC").getNodeValue();
		String DCC = node.getAttributes().getNamedItem("DCC").getNodeValue();
		String Supported = node.getAttributes().getNamedItem("Supported").getNodeValue();
		String Values = node.getAttributes().getNamedItem("Values").getNodeValue();
		if(name.equals("none"))
			name = "";
		if(BCC.equals("none"))
			BCC = "";
		if(DCC.equals("none"))
			DCC = "";
		if(Values.equals("none"))
			Values = "";
		if(Supported.equals("none"))
			Supported = "";
		String[] str = {name, BCC, DCC, Supported};
		TableNode tNodeChild = new TableNode(str);
		tNodeChild.defaultValues = Values;
		tNode.addChild(tNodeChild);
		
		NodeList functionChildren = node.getChildNodes();
		 for(int f = 0; f < functionChildren.getLength(); f++){
			Node node2 = functionChildren.item(f);
			if (node2.getNodeType() == Node.ELEMENT_NODE && node2.getNodeName().equals("Function")) {
				parseNodeFunction(node2, tNodeChild);    		 
			}
		 }
	}
	
	public void fillNode(Node root, Vector profile)
	{
		if (root.hasChildNodes()){
	         NodeList children;
	         int numChildren;
	         Node node;
	         children = root.getChildNodes();
	         numChildren = children.getLength();
	         
	         int profileIndex = 0;
	         for (int i=0; i < numChildren; i++) {
	        	 node = children.item(i);                 
		         if (node != null) {                     
		 	          if (node.getNodeType() == Node.ELEMENT_NODE) {
		 	        	  // Transport profile
		 	        	  if (node.getNodeName().equals("Transport-Profile")) {
		 	        		 curTProfile = (TransportProfile)vectTransProfiles.get(profileIndex);
		 	        		 profileIndex++;
		 	        		 
		 	        		 int icsIndex = 0;
		 	        		 NodeList icsChildren = node.getChildNodes();
		 	        		 for(int j = 0; j < icsChildren.getLength(); j++){
		 	        			 node = icsChildren.item(j);
//		 	        			 Transport ics
				 	        	  if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals("Transport-ICS")) {
				 	        		 curTICS = (TransportICS)curTProfile.vectTransportICS.get(icsIndex);
				 	        		 icsIndex ++;
				 	        		 
				 	        		 NodeList functionChildren = node.getChildNodes();
				 	        		 // functions
				 	        		 for(int f = 0; f < functionChildren.getLength(); f++){
				 	        			node = functionChildren.item(f);
				 	        			if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals("Function")) 
				 	        				fillNodeFunction(node, curTICS.getRoot());
					 	        		 
				 	        		 }
				 	        	  }
		 	        		 }
		 	        				 	        		 
		 	        	  }
		 	        	  
		 	          }
		         }
	         }
		}
	}
	
	private void fillNodeFunction(Node node, TableNode tNode)
	{
		String name = node.getAttributes().getNamedItem("name").getNodeValue();
		
		
		TableNode tNodeChild = null;
		for(int i = 0; i < tNode.children.size(); i++){
			TableNode n = (TableNode)tNode.children.get(i);
			if(n.row[0].equals(name)){
				tNodeChild = n;
				i = tNode.children.size();
			}
		}
		
		if(tNodeChild != null)
			node.getAttributes().getNamedItem("Supported").setNodeValue(tNodeChild.row[3]);
		
		NodeList functionChildren = node.getChildNodes();
		 for(int f = 0; f < functionChildren.getLength(); f++){
			Node node2 = functionChildren.item(f);
			if (node2.getNodeType() == Node.ELEMENT_NODE && node2.getNodeName().equals("Function")) {
				fillNodeFunction(node2, tNodeChild);    		 
			}
		 }
	}

}
