package pdfReport;


import transport.TableNode;
import transport.TreeTableModel;

import com.lowagie.text.pdf.PdfPTable;

/**
 * This class creates a PDFTable from a tree table model in order to then export JTable information to PDF document
 * @author MC
 *
 */
public class PdfTableFromTreeTableModel {
	public PdfPTable pdfTable;
	public PdfTableFromTreeTableModel(TreeTableModel model){
		pdfTable = new PdfPTable(model.getColumnCount());
		
		for(int i = 0; i < model.getColumnCount(); i++){
			pdfTable.addCell(model.getColumnName(i));
		}
		
		for(int i = 0; i < model.getChildCount(model.getRoot()); i++){
			parseNode(model, model.getChild(model.getRoot(), i));
		}
	}
	
	public void parseNode(TreeTableModel model, Object node){
		String text = null;
		for(int i = 0; i < model.getColumnCount(); i++){
			text = model.getValueAt(node, i).toString();
			if( i == 3 ){
				TableNode node2 = (TableNode) model.getValueAt(node, i);
				text = node2.row[3];
			}
			if(text == null) text = "";
			pdfTable.addCell(text);
		}
		for(int i = 0; i < model.getChildCount(node); i++)
			parseNode(model, model.getChild(node, i));
	}
}
