package pdfReport;

import javax.swing.table.TableModel;
import com.lowagie.text.pdf.PdfPTable;

/**
 * This class creates a PDFTable from a table model in order to then export JTable information to PDF document 
 * @author MC
 *
 */
public class PDFTableFromTableModel {
	public PdfPTable pdfTable;
	public PDFTableFromTableModel(TableModel jtable){
		pdfTable = new PdfPTable(jtable.getColumnCount());
		
		for(int i = 0; i < jtable.getColumnCount(); i++){
			pdfTable.addCell(jtable.getColumnName(i));
		}
		
		for(int i = 0; i < jtable.getRowCount(); i++){
			for(int j = 0; j < jtable.getColumnCount(); j++){
				String text = null;
				try{
					text = jtable.getValueAt(i, j).toString();
					if(text.startsWith("<html>")){
						text = text.replace("<html>", "");
						text = text.replace("</html>", "");
					}
					else if(text.equals("true"))
						text = "X";
					else if(text.equals("false"))
						text = "";
				}
				catch(Exception e){
					
				}
				if(text == null) text = "";
				pdfTable.addCell(text);
			}
		}
	}

}
