package modifyIcs;

import icsDyn.XMLFileFilter;
import icsTables.ICSTableModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * This panel allows the user loading an ICS table
 * @author MC
 */
public class JPanelLoad extends JPanel implements ActionListener {

    private static final long serialVersionUID = 1L;
    private String FileName;
    private JButton btnReload;
    private JButton btnNew;
    private JLabel lbl;
    
    private ICSDocuments icsDocs;
    private ICSTableModel icsTable;
    
    /** Creates a new instance of JPanelLoad */    
    public JPanelLoad(ICSTableModel icsTableIn) {
        initComponents(); 
        icsTable = icsTableIn;
        setDescription(icsTable.getStrDescription());
        setTitle(icsTable.getStrTitle()); 
        FileName = icsTable.getDefaultXmlFile();
    }
    /**
     * init
     *
     */
    public void init()
    {
        btnNew.setEnabled(true);
        btnReload.setEnabled(true);
        FileName = icsTable.getDefaultXmlFile();
    }
    /**
     * setDescription
     * @param description
     */
    private void setDescription(String description)
    {
        lbl.setText("<html>"+description+"</html>");
    }
    /**
     * setTitle
     * @param title
     */
    private void setTitle(String title)
    {
        setBorder(javax.swing.BorderFactory.createTitledBorder(title));
    }
    /**
     * setICSDocs
     * @param obj
     */
    public void setICSDocs(ICSDocuments obj)
    {
        icsDocs = obj;
    }
    /**
     * initComponents
     *
     */
    private void initComponents()
    {
        java.awt.GridBagConstraints gridBagConstraints;
        setLayout(new java.awt.GridBagLayout());
        
        
        lbl = new JLabel("");
        lbl.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        lbl.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(lbl, gridBagConstraints);
     
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        
      	btnNew = new JButton("New");
      	btnNew.setBackground(new Color(204, 204, 255));
      	btnNew.setEnabled(true);
      	btnNew.addActionListener(this);
      	add(btnNew, gridBagConstraints);
      	
      	gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
      
      	btnReload = new JButton("Reload...");
      	btnReload.setBackground(new Color(204, 204, 255));
      	btnReload.setEnabled(true);
      	btnReload.addActionListener(this);
      	add(btnReload, gridBagConstraints);
      	
    }
    /**
     * @see ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == btnNew)
        {		   
		   initializeDoc();
		}
		if (evt.getSource() == btnReload) 
		{				    													
		   JFileChooser fc = new JFileChooser();
		   // Set the chooser to accept only XML files.
	       fc.addChoosableFileFilter(new XMLFileFilter());
		   fc.setAcceptAllFileFilterUsed(false);
           fc.setCurrentDirectory(new File("..\\xml"));
		   int returnVal = fc.showOpenDialog(this);
		   File f = null;
		   if(returnVal == JFileChooser.APPROVE_OPTION) 
		   {
			 f = fc.getSelectedFile();
			 FileName = f.getAbsolutePath();
             initializeDoc();
		    }
		      
		 }
    }
    /**
     * initializeDoc
     *
     */
    private void initializeDoc()
    {
    	icsDocs.setXMLFile(icsTable.getStrTitle(), new File(FileName));
        icsTable.setDocumentFromXML(FileName);
        icsDocs.setDocument(icsTable.getStrTitle(), icsTable.getDocument());
    }
    public void disableButtons()
    {
    	btnReload.setEnabled(false);
        btnNew.setEnabled(false);
    }
    
}
