package icsDyn;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

/**
 * This class is used to capture/restore the JTree structure
 * @author  Rick Rivello
 */

public class TreeExpansionUtils {

    public static Enumeration saveExpansionState(JTree tree) {
        return tree.getExpandedDescendants(new TreePath(tree.getModel().getRoot()));
    }
    public static void loadExpansionState(JTree tree, Enumeration enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = (TreePath) enumeration.nextElement();
                tree.expandPath(treePath);
            }
        }
    }
}
