package icsDyn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * This class represents the dialig for adding a private object's properties
 * @author MC
 *
 */
public class AddPrivateDialog extends JDialog implements ActionListener{

	private static final long serialVersionUID = 1L;
	
	private JButton btnOK;
	private JButton btnClose;
	private JTextField[] txtFd;
	private String[] strLabels;
	private final static int widthLabel = 120;
	public Object parent;
	private String strGoal;
	
	public static final String privateAtt = "Attributes";
	public static final String privateBehav = "Behaviour";
	public static final String privateNoti = "Notification";
	public static final String privateMoc = "MOC";
	
	ICSModel icsModel;

	public AddPrivateDialog(Object p,JFrame f, String[] vectString, String g){
		super(f, f.getTitle(), true);
		parent = p;
		strGoal = g;
		strLabels = vectString;
		txtFd = new JTextField[vectString.length];
		init();
	}
	public void setICSModel(ICSModel ics){
		icsModel = ics;
		
	}
	private void init(){
		getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));
		
		JPanel p1 = new JPanel();
		p1.setLayout(new BoxLayout(p1, BoxLayout.PAGE_AXIS));
		p1.add(Box.createRigidArea(new Dimension(0, 20)));
		p1.setBorder(BorderFactory.createEtchedBorder());
		for(int i = 0; i < strLabels.length; i++){
			JPanel p11 = new JPanel();
			p11.setLayout(new BoxLayout(p11, BoxLayout.LINE_AXIS));
			p11.add(Box.createRigidArea(new Dimension(20, 0)));
			JLabel lbl = new JLabel(strLabels[i]);
			lbl.setPreferredSize(new Dimension(widthLabel, 0));
			p11.add(lbl);
			txtFd[i] = new JTextField();
			txtFd[i].setEditable(true);
			txtFd[i].setBackground(Color.WHITE);
			txtFd[i].setPreferredSize(new Dimension(widthLabel, 20));
			p11.add(txtFd[i]);
			p11.add(Box.createRigidArea(new Dimension(20, 0)));
			p1.add(p11);
			p1.add(Box.createRigidArea(new Dimension(0, 5)));
		}
		p1.add(Box.createRigidArea(new Dimension(0, 15)));
		JPanel p2 = new JPanel();
		p2.setLayout(new BorderLayout());
		
		btnClose = new JButton("Close");
		btnOK = new JButton("OK");
		btnClose.setBackground(new Color(204, 204, 255));
		btnOK.setBackground(new Color(204, 204, 255));
		btnOK.addActionListener(this);
		btnClose.addActionListener(this);
		
		p2.setBorder(BorderFactory.createEmptyBorder(5,20,5,20));
		p2.add(btnOK, BorderLayout.WEST);
		p2.add(btnClose,BorderLayout.EAST);
		
		getContentPane().add(p1);
		getContentPane().add(p2);
		
	}
	public void actionPerformed(ActionEvent arg0) {
		if(arg0.getSource() == btnOK){
			boolean valid = true;
			for(int i = 0; i < strLabels.length; i++){
				strLabels[i] = txtFd[i].getText();
				if(strLabels[i].equals(""))
					valid = false;
				
			}
			if(valid){
				icsModel.fireEvent(new MVCArg("private/"+strGoal, strLabels));
				dispose();				
			}
			else
				JOptionPane.showMessageDialog(this, "All fields must be filled!","Error!", JOptionPane.ERROR_MESSAGE);
		}
		else if(arg0.getSource() == btnClose){
			this.dispose();
		}
		
	}

}
