package drawing;

import drawing.UnitClass;
/**
 * This class represents a graph vertice
 * @author MC
 *
 */
public class Vertice implements Comparable {
	/**
	 * the x coordinate
	 */
	public double x;
	/**
	 * the y coordinate
	 */
	public double y;
	public int height;
	public int width;
	/**
	 * the index of the classunit that it represents
	 */
	public int index;
	/**
	 * whether the vertice is virtual
	 */
	public boolean isVirtual;
	/**
	 * constructor
	 * @param u
	 * @param i
	 */
	public Vertice(UnitClass u, int i){
		height = u.getHeight();
		width = u.getWidth();
		index = i;
		isVirtual = false;
		x = u.x;
		y = u.y;
	}
	/**
	 * constructor
	 *
	 */
	public Vertice(){
		height = 0;
		width = 0;
		index = -1;
		isVirtual = true;
		
	}
	/**
	 * @see Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object arg0) {
		Vertice v = (Vertice) arg0;
		int ret;
		if(y > v.y)
			ret = 1;
		else if(y < v.y)
			ret = -1;
		else if(y == v.y && x > v.x)
			ret = 1;
		else if(y == v.y && x < v.x)
			ret = -1;
		else
			ret = 0;
		return ret;
	}
}
