package comparingDevices;

import java.util.Collections;
import java.util.List;
import java.util.Vector;

/**
 * This class represents an MOC object
 * @author MC
 *
 */
public class MOC extends Base{
	public Vector<Attribute> vectAttributes;
	public Vector<Behavior> vectBehaviors;
	public Vector<Notification> vectNotifications;
	public MOC(String nameIn)
	{
		super(nameIn);
		vectAttributes = new Vector<Attribute>();
		vectBehaviors = new Vector<Behavior>();
		vectNotifications = new Vector<Notification>();
	}
	public void setOwner(Integer index){
		super.setOwner(index);
		for(int i = 0; i<vectAttributes.size(); i++){
			Attribute obj = (Attribute) vectAttributes.get(i);
			obj.setOwner(index);
		}
		for(int i = 0; i<vectBehaviors.size(); i++){
			Behavior obj = (Behavior) vectBehaviors.get(i);
			obj.setOwner(index);
		}
		for(int i = 0; i<vectNotifications.size(); i++){
			Notification obj = (Notification) vectNotifications.get(i);
			obj.setOwner(index);
		}
	}
	public void addAttribute(Attribute att)
	{
		vectAttributes.add(att);
	}
	public void addBehavior(Behavior behav)
	{
		vectBehaviors.add(behav);
	}
	public void addNotification(Notification notif)
	{
		vectNotifications.add(notif);
	}
	public void addListAttribute(List<Attribute> att)
	{
		vectAttributes.addAll(att);
	}
	public void addListBehavior(List<Behavior> behav)
	{
		vectBehaviors.addAll(behav);
	}
	public void addListNotification(List<Notification> notif)
	{
		vectNotifications.addAll(notif);
	}
	public boolean isImplemented(Base obj)
	{
		Vector vect = null;
		if(obj instanceof Attribute) {
			vect = vectAttributes;
		}
		else if(obj instanceof Notification){
			vect = vectNotifications;
		}
		else if(obj instanceof Behavior){
			vect = vectBehaviors;
		}			
		int i = 0;
		boolean found = false;
		while(!found && i<vect.size()){
			Base base = (Base) vect.get(i);
			if(base.compareTo(obj) == 0)
				found = true;
			else
				i++;
		}
		return found;
	}
	public void addToOwners(MOC objMOC)
	{
		super.addToOwners(objMOC);
		addListAttribute(objMOC.vectAttributes);
		addListBehavior(objMOC.vectBehaviors);
		addListNotification(objMOC.vectNotifications);
		sort();
	}
	/**
	 * this methode sorts attributes, notifications, behaviours alphabatically
	 *
	 */
	public void sort(){

                Collections.sort(vectAttributes);
                Collections.sort(vectBehaviors);
                Collections.sort(vectNotifications);
		
		//we remove doublons
		for(int i=1; i<vectAttributes.size(); i++){
			Attribute objPrec = (Attribute)vectAttributes.get(i - 1);
			Attribute obj = (Attribute)vectAttributes.get(i);
			if(obj.compareTo(objPrec) == 0)
			{
				objPrec.addToOwners(obj);
				vectAttributes.remove(i);
				i--;
			}
		}
		
		for(int i=1; i<vectBehaviors.size(); i++){
			Behavior objPrec = (Behavior)vectBehaviors.get(i - 1);
			Behavior obj = (Behavior)vectBehaviors.get(i);
			if(obj.compareTo(objPrec) == 0)
			{
				objPrec.addToOwners(obj);
				vectBehaviors.remove(i);
				i--;
			}
		}
		
		for(int i=1; i<vectNotifications.size(); i++){
			Notification objPrec = (Notification)vectNotifications.get(i - 1);
			Notification obj = (Notification)vectNotifications.get(i);
			if(obj.compareTo(objPrec) == 0)
			{
				objPrec.addToOwners(obj);
				vectNotifications.remove(i);
				i--;
			}
		}
	}

}
